/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.publishing.AllowedOutlineTypes;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.IncludeHeadings;
import org.eclipse.osee.framework.core.publishing.IncludeMainContentForHeadings;
import org.eclipse.osee.framework.core.publishing.IncludeMetadataAttributes;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class OutliningOptions
implements ToMessage {
    public static final String CONTENT_ATTRIBUTE_TYPE_FORMAT = "<format-content-attribute-type>";
    private static String CONTENT_ATTRIBUTE_TYPE_DEFAULT = "<format-content-attribute-type>";
    public static final String HEADING_ARTIFACT_TYPE_ANY = "<any-heading-artifact-type>";
    public static final String HEADING_ARTIFACT_TYPE_FOLDERS_AND_HEADERS_ONLY = "<folders-and-headers-only-heading-artifact-type>";
    public static final String HEADING_ARTIFACT_TYPE_FOLDERS_ONLY = "<folders-only-heading-artifact-type>";
    public static final String HEADING_ARTIFACT_TYPE_FORMAT = "<format-heading-artifact-type>";
    public static final String HEADING_ARTIFACT_TYPE_HEADERS_ONLY = "<headers-only-heading-artifact-type>";
    private static String HEADING_ARTIFACT_TYPE_DEFAULT = "<any-heading-artifact-type>";
    public static final String HEADING_ATTRIBUTE_TYPE_FORMAT = "<format-heading-attribute-type>";
    private static String HEADING_ATTRIBUTE_TYPE_DEFAULT = "<format-heading-attribute-type>";
    @Deprecated
    @JsonProperty(value="ArtifactName")
    private String artifactName = null;
    @JsonProperty(value="ContentAttributeType")
    private String contentAttributeType = null;
    @JsonProperty(value="ExcludeArtifactTypes")
    private String[] excludeArtifactTypes = null;
    @JsonProperty(value="HeadingArtifactType")
    private String headingArtifactType = null;
    @JsonProperty(value="HeadingAttributeType")
    private String headingAttributeType = null;
    @Deprecated
    @JsonProperty(value="IncludeEmptyHeaders")
    private Boolean includeEmptyHeaders = null;
    @JsonProperty(value="IncludeHeadings")
    private IncludeHeadings includeHeadings = null;
    @JsonProperty(value="IncludeMainContentForHeadings")
    private IncludeMainContentForHeadings includeMainContentForHeadings;
    @JsonProperty(value="IncludeMetadataAttributes")
    private IncludeMetadataAttributes includeMetadataAttributes = null;
    @JsonProperty(value="OutlineNumber")
    private String outlineNumber = null;
    @Deprecated
    @JsonProperty(value="OutlineOnlyHeaderFolders")
    private Boolean outlineOnlyHeaderFolders = null;
    @Deprecated
    @JsonProperty(value="Outlining")
    private Boolean outlining = null;
    @JsonProperty(value="OverrideOutlineNumber")
    private Boolean overrideOutlineNumber = null;
    @JsonProperty(value="RecurseChildren")
    private Boolean recurseChildren = null;
    @JsonProperty(value="TemplateFooter")
    private Boolean templateFooter = null;

    public static void setValues(@NonNull OutliningOptions[] outliningOptionsArray, @NonNull FormatIndicator formatIndicator, @NonNull RendererMap rendererMap, @NonNull OrcsTokenService tokenService, @NonNull Consumer<AllowedOutlineTypes> allowedOutlineTypesSetter, @NonNull Consumer<AttributeTypeToken> contentAttributeTypeSetter, @NonNull Consumer<Collection<ArtifactTypeToken>> excludeArtifactTypesSetter, @NonNull Consumer<ArtifactTypeToken> headingArtifactTypeSetter, @NonNull Consumer<AttributeTypeToken> headingAttributeTypeSetter, @NonNull Consumer<IncludeHeadings> includeHeadingsSetter, @NonNull Consumer<IncludeMainContentForHeadings> includeMainContentForHeadingsSetter, @NonNull Consumer<IncludeMetadataAttributes> includeMetadataAttributesSetter, @NonNull Consumer<String> initialOutlineNumberSetter, @NonNull Consumer<Boolean> overrideOutlineNumberSetter, @NonNull Consumer<Boolean> recurseChildrenSetter, @NonNull Consumer<Boolean> templateFooterSetter) {
        String headingAttributeTypeTokenName;
        String headingArtifactTypeTokenName;
        String contentAttributeTypeTokenName;
        OutliningOptions[] safeOutliningOptionsArray = (OutliningOptions[])Conditions.requireNonNull((Object)outliningOptionsArray, (String)"outliningOptionsArray");
        FormatIndicator safeFormatIndicator = (FormatIndicator)((Object)Conditions.requireNonNull((Object)((Object)formatIndicator), (String)"formatIndicator"));
        RendererMap safeRendererMap = (RendererMap)Conditions.requireNonNull((Object)rendererMap, (String)"rendererMap");
        OrcsTokenService safeTokenService = (OrcsTokenService)Conditions.requireNonNull((Object)tokenService, (String)"tokenService");
        Consumer safeAllowedOutlineTypesSetter = (Consumer)Conditions.requireNonNull(allowedOutlineTypesSetter, (String)"allowedOutlineTypesSetter");
        Consumer safeContentAttributeTypeSetter = (Consumer)Conditions.requireNonNull(contentAttributeTypeSetter, (String)"contentAttributeTypeSetter");
        Consumer safeExcludeArtifactTypesSetter = (Consumer)Conditions.requireNonNull(excludeArtifactTypesSetter, (String)"excludeArtifactTypesSetter");
        Consumer safeHeadingArtifactTypeSetter = (Consumer)Conditions.requireNonNull(headingArtifactTypeSetter, (String)"headingArtifactTypeSetter");
        Consumer safeHeadingAttributeTypeSetter = (Consumer)Conditions.requireNonNull(headingAttributeTypeSetter, (String)"headingAttributeTypeSetter");
        Consumer safeIncludeHeadingsSetter = (Consumer)Conditions.requireNonNull(includeHeadingsSetter, (String)"includeHeadingsSetter");
        Consumer safeIncludeMainContentForHeadingsSetter = (Consumer)Conditions.requireNonNull(includeMainContentForHeadingsSetter, (String)"includeMainContentForHeadingsSetter");
        Consumer safeIncludeMetadataAttributesSetter = (Consumer)Conditions.requireNonNull(includeMetadataAttributesSetter, (String)"includeMetadataAttributesSetter");
        Consumer safeInitialOutlineNumberSetter = (Consumer)Conditions.requireNonNull(initialOutlineNumberSetter, (String)"initialOutlineNumberSetter");
        Consumer safeOverrideOutlineNumberSetter = (Consumer)Conditions.requireNonNull(overrideOutlineNumberSetter, (String)"overrideOutlineNumberSetter");
        Consumer safeRecurseChildrenSetter = (Consumer)Conditions.requireNonNull(recurseChildrenSetter, (String)"recurseChildrenSetter");
        Consumer safeTemplateFooterSetter = (Consumer)Conditions.requireNonNull(templateFooterSetter, (String)"templateFooterSetter");
        OutliningOptions outliningOptions = safeOutliningOptionsArray.length >= 1 ? safeOutliningOptionsArray[0] : new OutliningOptions().defaults();
        switch (contentAttributeTypeTokenName = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_CONTENT_ATTRIBUTE_TYPE) ? (String)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_CONTENT_ATTRIBUTE_TYPE) : outliningOptions.getContentAttributeType()) {
            case "*": 
            case "<format-content-attribute-type>": {
                safeContentAttributeTypeSetter.accept(safeFormatIndicator.getContentAttributeTypeToken());
                break;
            }
            default: {
                safeContentAttributeTypeSetter.accept(safeTokenService.getAttributeType(contentAttributeTypeTokenName));
            }
        }
        Collection excludeArtifactTypes = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_EXCLUDE_ARTIFACT_TYPES) ? (Collection)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_EXCLUDE_ARTIFACT_TYPES) : (Collection)Arrays.stream(outliningOptions.getExcludeArtifactTypes()).map(safeTokenService::getArtifactType).collect(Collectors.toList());
        safeExcludeArtifactTypesSetter.accept(excludeArtifactTypes);
        switch (headingArtifactTypeTokenName = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_HEADING_ARTIFACT_TYPE) ? (String)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_HEADING_ARTIFACT_TYPE) : outliningOptions.getHeadingArtifactType()) {
            case "<any-heading-artifact-type>": {
                safeAllowedOutlineTypesSetter.accept(AllowedOutlineTypes.ANYTHING);
                safeHeadingArtifactTypeSetter.accept(null);
                break;
            }
            case "<folders-and-headers-only-heading-artifact-type>": {
                safeAllowedOutlineTypesSetter.accept(AllowedOutlineTypes.HEADERS_AND_FOLDERS_ONLY);
                safeHeadingArtifactTypeSetter.accept(null);
                break;
            }
            case "<folders-only-heading-artifact-type>": {
                safeAllowedOutlineTypesSetter.accept(AllowedOutlineTypes.FOLDERS_ONLY);
                safeHeadingArtifactTypeSetter.accept(null);
                break;
            }
            case "<format-heading-artifact-type>": {
                safeAllowedOutlineTypesSetter.accept(AllowedOutlineTypes.RESTRICTED);
                safeHeadingArtifactTypeSetter.accept(safeFormatIndicator.getDefaultHeadingArtifactTypeToken());
                break;
            }
            case "<headers-only-heading-artifact-type>": {
                safeAllowedOutlineTypesSetter.accept(AllowedOutlineTypes.HEADERS_ONLY);
                safeHeadingArtifactTypeSetter.accept(null);
                break;
            }
            default: {
                safeAllowedOutlineTypesSetter.accept(AllowedOutlineTypes.RESTRICTED);
                safeHeadingArtifactTypeSetter.accept(safeTokenService.getArtifactType(headingArtifactTypeTokenName));
            }
        }
        switch (headingAttributeTypeTokenName = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_HEADING_ATTRIBUTE_TYPE) ? (String)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_HEADING_ATTRIBUTE_TYPE) : outliningOptions.getHeadingAttributeType()) {
            case "<format-heading-attribute-type>": {
                safeHeadingAttributeTypeSetter.accept(safeFormatIndicator.getDefaultHeadingContentAttributTypeToken());
                break;
            }
            default: {
                safeHeadingAttributeTypeSetter.accept(safeTokenService.getAttributeType(headingAttributeTypeTokenName));
            }
        }
        IncludeHeadings includeHeadings = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_INCLUDE_HEADINGS) ? (IncludeHeadings)((Object)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_INCLUDE_HEADINGS)) : outliningOptions.getIncludeHeadings();
        safeIncludeHeadingsSetter.accept(includeHeadings);
        IncludeMainContentForHeadings includeMainContentForHeadings = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_INCLUDE_MAIN_CONTENT_FOR_HEADINGS) ? (IncludeMainContentForHeadings)((Object)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_INCLUDE_MAIN_CONTENT_FOR_HEADINGS)) : outliningOptions.getIncludeMainContentForHeadings();
        safeIncludeMainContentForHeadingsSetter.accept(includeMainContentForHeadings);
        IncludeMetadataAttributes includeMetadataAttributes = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_INCLUDE_METADATA_ATTRIBUTES) ? (IncludeMetadataAttributes)((Object)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_INCLUDE_METADATA_ATTRIBUTES)) : outliningOptions.getIncludeMetadataAttributes();
        safeIncludeMetadataAttributesSetter.accept(includeMetadataAttributes);
        String initialOutlineNumber = safeRendererMap.isRendererOptionSet(RendererOption.OUTLINING_OPTION_OVERRIDE_OUTLINE_NUMBER) ? (String)safeRendererMap.getRendererOptionValue(RendererOption.OUTLINING_OPTION_OVERRIDE_OUTLINE_NUMBER) : outliningOptions.getOutlineNumber();
        safeInitialOutlineNumberSetter.accept(initialOutlineNumber);
        boolean overrideOutlineNumber = outliningOptions.isOverrideOutlineNumber();
        safeOverrideOutlineNumberSetter.accept(overrideOutlineNumber);
        boolean recurseChildren = safeRendererMap.isRendererOptionSet(RendererOption.RECURSE_ON_LOAD) ? ((Boolean)safeRendererMap.getRendererOptionValue(RendererOption.RECURSE_ON_LOAD)).booleanValue() : outliningOptions.isRecurseChildren();
        safeRecurseChildrenSetter.accept(recurseChildren);
        boolean templateFooter = outliningOptions.isTemplateFooter();
        safeTemplateFooterSetter.accept(templateFooter);
    }

    public OutliningOptions defaults() {
        if (this.contentAttributeType == null) {
            this.contentAttributeType = CONTENT_ATTRIBUTE_TYPE_DEFAULT;
        }
        if (this.excludeArtifactTypes == null) {
            this.excludeArtifactTypes = new String[0];
        }
        if (this.headingArtifactType == null) {
            String string = this.headingArtifactType = Objects.nonNull(this.outlineOnlyHeaderFolders) && this.outlineOnlyHeaderFolders != false ? HEADING_ARTIFACT_TYPE_FOLDERS_AND_HEADERS_ONLY : HEADING_ARTIFACT_TYPE_DEFAULT;
        }
        if (this.headingAttributeType == null) {
            this.headingAttributeType = HEADING_ATTRIBUTE_TYPE_DEFAULT;
        }
        if (this.includeHeadings == null) {
            IncludeHeadings includeHeadings = this.includeEmptyHeaders == null ? IncludeHeadings.ALWAYS : (this.includeHeadings = this.includeEmptyHeaders != false ? IncludeHeadings.ALWAYS : IncludeHeadings.ONLY_WITH_NON_HEADING_DESCENDANTS);
        }
        if (this.includeMainContentForHeadings == null) {
            this.includeMainContentForHeadings = IncludeMainContentForHeadings.ALWAYS;
        }
        if (this.includeMetadataAttributes == null) {
            this.includeMetadataAttributes = IncludeMetadataAttributes.ALWAYS;
        }
        if (this.outlineNumber == null) {
            this.outlineNumber = "";
        }
        if (Objects.isNull(this.overrideOutlineNumber)) {
            this.overrideOutlineNumber = false;
        }
        if (Objects.isNull(this.recurseChildren)) {
            this.recurseChildren = false;
        }
        if (Objects.isNull(this.templateFooter)) {
            this.templateFooter = false;
        }
        if (this.artifactName == null) {
            this.artifactName = "";
        }
        if (this.includeEmptyHeaders == null) {
            this.includeEmptyHeaders = false;
        }
        if (this.outlineOnlyHeaderFolders == null) {
            this.outlineOnlyHeaderFolders = false;
        }
        if (this.outlining == null) {
            this.outlining = false;
        }
        return this;
    }

    @Deprecated
    public String getArtifactName() {
        Conditions.requireMemberSet((Object)this.artifactName, (String)"artifactName");
        return this.artifactName;
    }

    public String getContentAttributeType() {
        Conditions.requireMemberSet((Object)this.contentAttributeType, (String)"contentAttributeType");
        return this.contentAttributeType;
    }

    public String[] getExcludeArtifactTypes() {
        Conditions.requireMemberSet((Object)this.excludeArtifactTypes, (String)"excludeArtifactTypes");
        return this.excludeArtifactTypes;
    }

    public String getHeadingArtifactType() {
        Conditions.requireMemberSet((Object)this.headingArtifactType, (String)"headingArtifactType");
        return this.headingArtifactType;
    }

    public String getHeadingAttributeType() {
        if (Objects.isNull(this.headingAttributeType)) {
            throw new IllegalStateException("OutliningOptions::getHeadingAttributeType, the member \"headingAttributeType\" has not been set.");
        }
        return this.headingAttributeType;
    }

    public IncludeHeadings getIncludeHeadings() {
        Conditions.requireMemberSet((Object)((Object)this.includeHeadings), (String)"includeHeadings");
        return this.includeHeadings;
    }

    public IncludeMainContentForHeadings getIncludeMainContentForHeadings() {
        Conditions.requireMemberSet((Object)((Object)this.includeMainContentForHeadings), (String)"includeMainContentForHeadings");
        return this.includeMainContentForHeadings;
    }

    public IncludeMetadataAttributes getIncludeMetadataAttributes() {
        Conditions.requireMemberSet((Object)((Object)this.includeMetadataAttributes), (String)"includeMetadataAttributes");
        return this.includeMetadataAttributes;
    }

    public String getOutlineNumber() {
        if (Objects.isNull(this.outlineNumber)) {
            throw new IllegalStateException("OutliningOptions::getOutlineNumber, the member \"outlineNumber\" has not been set.");
        }
        return this.outlineNumber;
    }

    @Deprecated
    public boolean isIncludeEmptyHeaders() {
        Conditions.requireMemberSet((Object)this.includeEmptyHeaders, (String)"includeEmptyHeaders");
        return this.includeEmptyHeaders;
    }

    @Deprecated
    public boolean isOutlineOnlyHeaderFolders() {
        if (Objects.isNull(this.outlineOnlyHeaderFolders)) {
            throw new IllegalStateException("OutliningOptions::isOutlineOnlyHeaderFolders, the member \"outlineOnlyHeaderFolders\" has not been set.");
        }
        return this.outlineOnlyHeaderFolders;
    }

    @Deprecated
    public boolean isOutlining() {
        if (Objects.isNull(this.outlining)) {
            throw new IllegalStateException("OutliningOptions::isOutlining, the member \"outlining\" has not been set.");
        }
        return this.outlining;
    }

    public boolean isOverrideOutlineNumber() {
        if (Objects.isNull(this.overrideOutlineNumber)) {
            throw new IllegalStateException("OutliningOptions::isOverrideOutlineNumber, the member \"overrideOutlineNumber\" has not been set.");
        }
        return this.overrideOutlineNumber;
    }

    public boolean isRecurseChildren() {
        if (Objects.isNull(this.recurseChildren)) {
            throw new IllegalStateException("OutliningOptions::isRecurseChildren, the member \"recurseChildren\" has not been set.");
        }
        return this.recurseChildren;
    }

    public boolean isTemplateFooter() {
        if (Objects.isNull(this.templateFooter)) {
            throw new IllegalStateException("OutliningOptions::isTemplateFooter, the member \"templateFooter\" has not been set.");
        }
        return this.templateFooter;
    }

    @JsonIgnore
    public boolean isValid() {
        return Objects.nonNull(this.contentAttributeType) && Objects.nonNull(this.excludeArtifactTypes) && Objects.nonNull(this.headingArtifactType) && Objects.nonNull(this.headingAttributeType) && Objects.nonNull((Object)this.includeHeadings) && Objects.nonNull(this.outlineNumber) && Objects.nonNull(this.overrideOutlineNumber) && Objects.nonNull(this.recurseChildren) && Objects.nonNull(this.templateFooter) && Objects.nonNull(this.artifactName) && Objects.nonNull(this.includeEmptyHeaders) && Objects.nonNull(this.outlineOnlyHeaderFolders) && Objects.nonNull(this.outlining);
    }

    @Deprecated
    public void setArtifactName(String artifactName) {
        if (Objects.nonNull(this.artifactName)) {
            throw new IllegalStateException("OutliningOptions::setArtifactName, member \"artifactName\" has already been set.");
        }
        this.artifactName = (String)Conditions.requireNonNull((Object)artifactName, (String)"artifactName");
    }

    public void setContentAttributeType(String contentAttributeType) {
        Conditions.requireNull((Object)this.contentAttributeType, (String)"contentAttributeType");
        this.contentAttributeType = (String)Conditions.requireNonNull((Object)contentAttributeType, (String)"contentAttributeType");
    }

    public void setExcludeArtifactTypes(String[] excludeArtifactTypes) {
        Conditions.requireNull((Object)this.excludeArtifactTypes, (String)"excludeArtifactTypes");
        this.excludeArtifactTypes = (String[])Conditions.requireNonNull((Object)excludeArtifactTypes, (String)"excludeArtifactTypes ");
    }

    public void setHeadingArtifactType(String headingArtifactType) {
        if (Objects.nonNull(this.headingArtifactType)) {
            throw new IllegalStateException("OutliningOptions::setHeadingArtifactType, member \"headingArtifactType\" has already been set.");
        }
        this.headingArtifactType = (String)Conditions.requireNonNull((Object)headingArtifactType, (String)"headingArtifactType");
    }

    public void setHeadingAttributeType(String headingAttributeType) {
        if (Objects.nonNull(this.headingAttributeType)) {
            throw new IllegalStateException("OutliningOptions::setHeadingAttributeType, member \"headingAttributeType\" has already been set.");
        }
        this.headingAttributeType = (String)Conditions.requireNonNull((Object)headingAttributeType, (String)"headingAttributeType");
    }

    public void setIncludeEmptyHeaders(Boolean includeEmptyHeaders) {
        if (Objects.nonNull(this.includeEmptyHeaders)) {
            throw new IllegalStateException("OutliningOptions::setIncludeEmptyHeaders, member \"includeEmptyHeaders\" has already been set.");
        }
        this.includeEmptyHeaders = (Boolean)Conditions.requireNonNull((Object)includeEmptyHeaders, (String)"includeEmptyHeaders");
    }

    public void setIncludeHeadings(IncludeHeadings includeHeadings) {
        Conditions.requireNull((Object)((Object)this.includeHeadings), (String)"includeHeadings");
        this.includeHeadings = (IncludeHeadings)((Object)Conditions.requireNonNull((Object)((Object)includeHeadings), (String)"includeHeadings"));
    }

    public void setIncludeMainContentForHeadings(IncludeMainContentForHeadings includeMainContentForHeadings) {
        Conditions.requireNull((Object)((Object)this.includeMainContentForHeadings), (String)"includeMainContentForHeadings");
        this.includeMainContentForHeadings = (IncludeMainContentForHeadings)((Object)Conditions.requireNonNull((Object)((Object)includeMainContentForHeadings), (String)"includeMainContentForHeadings"));
    }

    public void setOutlineNumber(String outlineNumber) {
        if (Objects.nonNull(this.outlineNumber)) {
            throw new IllegalStateException("OutliningOptions::setOutlineNumber, member \"outlineNumber\" has already been set.");
        }
        this.outlineNumber = (String)Conditions.requireNonNull((Object)outlineNumber, (String)"outlineNumber");
    }

    public void setOutlineOnlyHeaderFolders(Boolean outlineOnlyHeaderFolders) {
        if (Objects.nonNull(this.outlineOnlyHeaderFolders)) {
            throw new IllegalStateException("OutliningOptions::setOutlineOnlyHeaderFolders, member \"outlineOnlyHeaderFolders\" has already been set.");
        }
        this.outlineOnlyHeaderFolders = (Boolean)Conditions.requireNonNull((Object)outlineOnlyHeaderFolders, (String)"outlineOnlyHeaderFolders");
    }

    public void setOutlining(Boolean outlining) {
        if (Objects.nonNull(this.outlining)) {
            throw new IllegalStateException("OutliningOptions::setOutlining, member \"outlining\" has already been set.");
        }
        this.outlining = (Boolean)Conditions.requireNonNull((Object)outlining, (String)"outlining");
    }

    public void setOverrideOutlineNumber(Boolean overrideOutlineNumber) {
        if (Objects.nonNull(this.overrideOutlineNumber)) {
            throw new IllegalStateException("OutliningOptions::setOverrideOutlineNumber, member \"overrideOutlineNumber\" has already been set.");
        }
        this.overrideOutlineNumber = (Boolean)Conditions.requireNonNull((Object)overrideOutlineNumber, (String)"overrideOutlineNumber");
    }

    public void setRecurseChildren(Boolean recurseChildren) {
        if (Objects.nonNull(this.recurseChildren)) {
            throw new IllegalStateException("OutliningOptions::setRecurseChildren, member \"recurseChildren\" has already been set.");
        }
        this.recurseChildren = (Boolean)Conditions.requireNonNull((Object)recurseChildren, (String)"recurseChildren");
    }

    public void setTemplateFooter(Boolean templateFooter) {
        if (Objects.nonNull(this.templateFooter)) {
            throw new IllegalStateException("OutliningOptions::setTemplateFooter, member \"templateFooter\" has already been set.");
        }
        this.templateFooter = (Boolean)Conditions.requireNonNull((Object)templateFooter, (String)"templateFooter");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Outlining Options").indentInc().segment((CharSequence)"Content Attribute Type", (Object)this.contentAttributeType).segment((CharSequence)"Heading Artifact Type", (Object)this.headingArtifactType).segment((CharSequence)"Heading Attribute Type", (Object)this.headingAttributeType).segment((CharSequence)"Include Headings", (Object)this.includeHeadings).segment((CharSequence)"Include Main Content For Headings", (Object)this.includeMainContentForHeadings).segment((CharSequence)"Include Metadata Attributes", (Object)this.includeMetadataAttributes).segment((CharSequence)"Outline Number", (Object)this.outlineNumber).segment((CharSequence)"Override Outline Number", (Object)this.overrideOutlineNumber).segment((CharSequence)"Recurse Children", (Object)this.recurseChildren).segment((CharSequence)"Template Footers", (Object)this.templateFooter).indentDec().title((CharSequence)"Deprecated Outlining Options").indentInc().segment((CharSequence)"Artifact Name", (Object)this.artifactName).segment((CharSequence)"Include Empty Headers", (Object)this.includeEmptyHeaders).segment((CharSequence)"Outline Only Header Folders", (Object)this.outlineOnlyHeaderFolders).segment((CharSequence)"Outlining", (Object)this.outlining).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

