/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.FilenameSpecification;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class FilenameFactory {
    private static String FILENAME_CLEAN_CHAR_REPLACEMENT = " ";
    private static final Pattern FILENAME_CLEANER_PATTERN = Pattern.compile("[/<>(){}\\[\\].:;\\\"'\\\\|?*+]+");
    private static final String FILENAME_DATE_TIME_FORMAT = "yyyyMMdd-HHmmss-SSS";
    private static char FILENAME_EXTENSION_SEPARATOR = (char)46;
    private static String FILENAME_SAFE_CHAR_REPLACEMENT = "-";
    private static final int FILENAME_SAFE_LENGTH = 20;
    private static String FILENAME_SEGMENT_SEPARATOR = "-";
    private static final Random generator = new Random();
    private static final Pattern WHITESPACE_CLEANER_PATTERN = Pattern.compile("\\s+");
    private static final Pattern FILENNAME_SAFE_CHAR_CONSOLIDATION_PATTERN = Pattern.compile(String.valueOf(FILENAME_SAFE_CHAR_REPLACEMENT) + FILENAME_SAFE_CHAR_REPLACEMENT + "+");
    private static final int WINDOWS_FILENAME_LIMIT = 215;

    public static @NonNull String create(@Nullable CharSequence extension, @NonNull CharSequence name) {
        CharSequence safeName = (CharSequence)Conditions.require((Object)name, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"name", (String)"cannot be null or blank", Strings::isInvalidOrBlank, IllegalArgumentException::new);
        String cleanName = FilenameFactory.makeNameCleaner(safeName);
        boolean extensionValid = Strings.isValidAndNonBlank((CharSequence)extension) && (extension.length() != 1 || extension.charAt(0) != FILENAME_EXTENSION_SEPARATOR);
        int length = cleanName.length() + (extensionValid ? extension.length() : 0) + 1;
        StringBuilder filename = new StringBuilder(length).append(cleanName);
        if (extensionValid) {
            if (extension.charAt(0) != FILENAME_EXTENSION_SEPARATOR) {
                filename.append(FILENAME_EXTENSION_SEPARATOR);
            }
            filename.append(extension);
        }
        return filename.toString();
    }

    public static @NonNull String create(CharSequence extension, CharSequence ... segments) {
        String dateSegment = FilenameFactory.getDateSegment();
        String randomSegment = FilenameFactory.getRandomSegment();
        return FilenameFactory.create((CharSequence)dateSegment, (CharSequence)randomSegment, extension, segments);
    }

    static @NonNull String create(CharSequence dateSegment, CharSequence randomSegment, CharSequence extension, CharSequence ... segments) {
        String safeDateSegment = FilenameFactory.makeNameSafer(dateSegment);
        safeDateSegment = safeDateSegment.isEmpty() ? FilenameFactory.getDateSegment() : safeDateSegment;
        String safeRandomSegment = FilenameFactory.makeNameSafer(randomSegment);
        safeRandomSegment = safeRandomSegment.isEmpty() ? FilenameFactory.getRandomSegment() : safeRandomSegment;
        String safeExtension = FilenameFactory.makeNameSafer(extension);
        String safeSegments = Objects.nonNull(segments) && segments.length > 0 ? Arrays.stream(segments).map(FilenameFactory::makeNameSafer).filter(Strings::isValidAndNonBlank).collect(Collectors.joining(FILENAME_SEGMENT_SEPARATOR)) : "";
        String name = Arrays.stream(new String[]{safeSegments, safeDateSegment, safeRandomSegment}).filter(Strings::isValidAndNonBlank).collect(Collectors.joining(FILENAME_SEGMENT_SEPARATOR));
        StringBuilder filename = new StringBuilder(name.length() + safeExtension.length() + 1).append(name);
        if (Strings.isValidAndNonBlank((String)safeExtension)) {
            if (safeExtension.charAt(0) != FILENAME_EXTENSION_SEPARATOR) {
                filename.append(FILENAME_EXTENSION_SEPARATOR);
            }
            filename.append(safeExtension);
        }
        return filename.toString();
    }

    public static Map<String, String> create(@NonNull List<@NonNull FilenameSpecification> filenameSpecifications) {
        Conditions.require(filenameSpecifications, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"list of filename specifications", (String)"non-null and no null elements", (Predicate)Conditions.collectionContainsNull, NullPointerException::new);
        return filenameSpecifications.stream().collect(Collectors.toMap(FilenameSpecification::getKey, FilenameSpecification::build));
    }

    static String getDateSegment() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FILENAME_DATE_TIME_FORMAT);
        String dateSegment = dateFormat.format(new Date());
        return dateSegment;
    }

    static String getRandomSegment() {
        int randomValue = generator.nextInt(99999) + 1;
        String randomSegment = String.format("%05d", randomValue);
        return randomSegment;
    }

    public static boolean isInLimit(CharSequence filename) {
        return Lib.isWindows() ? Objects.isNull(filename) || filename.length() <= 215 : true;
    }

    public static @NonNull String makeNameSafer(CharSequence name) {
        String cleanName = FilenameFactory.makeNameCleaner(name);
        String shortCleanName = cleanName.length() > 20 ? cleanName.substring(0, 20) : cleanName;
        return shortCleanName;
    }

    public static @NonNull String makeNameCleaner(CharSequence name) {
        String characterCleanName = Strings.totallySaferReplace((CharSequence)name, (Pattern)FILENAME_CLEANER_PATTERN, (String)FILENAME_CLEAN_CHAR_REPLACEMENT);
        if (Strings.isInvalidOrBlank((String)characterCleanName)) {
            return Strings.emptyString();
        }
        String trimCharacterCleanName = characterCleanName.trim();
        String whiteSpaceCleanTrimCharacterCleanName = Strings.totallySaferReplace((CharSequence)trimCharacterCleanName, (Pattern)WHITESPACE_CLEANER_PATTERN, (String)FILENAME_SAFE_CHAR_REPLACEMENT);
        String consolidatedSafeWhiteSpaceCleanTrimCharacterCleanName = Strings.totallySaferReplace((CharSequence)whiteSpaceCleanTrimCharacterCleanName, (Pattern)FILENNAME_SAFE_CHAR_CONSOLIDATION_PATTERN, (String)FILENAME_SAFE_CHAR_REPLACEMENT);
        return consolidatedSafeWhiteSpaceCleanTrimCharacterCleanName;
    }

    private FilenameFactory() {
    }
}

