/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Objects;
import org.eclipse.osee.framework.core.publishing.Cause;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class DataAccessException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Cause dataAccessCause;

    public DataAccessException(CharSequence title, Cause DataAccessCause, Throwable throwable) {
        super(DataAccessException.buildMessage(title, DataAccessCause, throwable));
        this.dataAccessCause = Objects.requireNonNull(DataAccessCause);
        this.initCause(Objects.requireNonNull(throwable));
    }

    public DataAccessException(CharSequence title, Cause DataAccessCause) {
        super(DataAccessException.buildMessage(title, DataAccessCause, null));
        this.dataAccessCause = Objects.requireNonNull(DataAccessCause);
    }

    public DataAccessException(CharSequence title, Throwable throwable) {
        super(DataAccessException.buildMessage(title, Cause.ERROR, throwable));
        this.dataAccessCause = Cause.ERROR;
        this.initCause(Objects.requireNonNull(throwable));
    }

    public Cause getPublishingUtilCause() {
        return this.dataAccessCause;
    }

    public boolean isError() {
        return this.dataAccessCause.equals((Object)Cause.ERROR);
    }

    public boolean isMoreThanOne() {
        return this.dataAccessCause.equals((Object)Cause.MORE_THAN_ONE);
    }

    public boolean isNotFound() {
        return this.dataAccessCause.equals((Object)Cause.NOT_FOUND);
    }

    public static String buildMessage(CharSequence title, Cause dataAccessCause, Throwable throwable) {
        return new Message().title(title).indentInc().segment((CharSequence)"Publishing Utils Cause", (Object)dataAccessCause).reasonFollowsIfNonNull(throwable).toString();
    }
}

