/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public enum FileExtension implements ToMessage
{
    CSV(2, "csv"),
    JSON(3, "json"),
    TXT(6, "txt"),
    XLS(4, "xls"),
    XLSX(5, "xlsx"),
    XML(0, "xml"),
    ZIP(1, "zip");

    private static final Map<FileExtensionEnum, FileExtension> fileExtensionEnumMap;
    private static final Map<String, FileExtension> fileExtensionMap;
    private static final Character separator;
    private final FileExtensionEnum enumToken;

    static {
        separator = Character.valueOf('.');
        fileExtensionMap = Arrays.stream(FileExtension.values()).collect(Collectors.toUnmodifiableMap(FileExtension::getFileExtension, Function.identity()));
        fileExtensionEnumMap = Arrays.stream(FileExtension.values()).collect(Collectors.toUnmodifiableMap(FileExtension::getEnumToken, Function.identity()));
    }

    public static Optional<FileExtension> valueOfAttribute(String attributeValueString) {
        return Optional.ofNullable(fileExtensionMap.get(attributeValueString));
    }

    public static Optional<FileExtension> valueOfEnumToken(FileExtensionEnum enumToken) {
        return Optional.ofNullable(fileExtensionEnumMap.get((Object)enumToken));
    }

    private FileExtension(int enumTokenOrdinal, String enumTokenName) {
        this.enumToken = new FileExtensionEnum(enumTokenOrdinal, Objects.requireNonNull(enumTokenName));
    }

    public StringBuilder append(String input) {
        String fileExtension = this.enumToken.getName();
        return new StringBuilder(Objects.requireNonNull(input).length() + 1 + fileExtension.length()).append(input).append(separator).append(fileExtension);
    }

    public StringBuilder append(StringBuilder input) {
        Objects.requireNonNull(input).append(separator).append(this.enumToken.getName());
        return input;
    }

    public String getFileExtension() {
        return this.enumToken.getName();
    }

    public FileExtensionEnum getEnumToken() {
        return this.enumToken;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.isNull(message) ? new Message() : message;
        outMessage.segment((CharSequence)this.name(), (Object)this.enumToken.getName());
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    public static class FileExtensionEnum
    extends EnumToken {
        public FileExtensionEnum(int ordinal, String name) {
            super(ordinal, name, new NamespaceToken[0]);
        }
    }
}

