/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public class RelationTypeSide
extends NamedIdBase
implements RelationTypeToken {
    public static final RelationTypeSide SENTINEL = new RelationTypeSide(RelationTypeToken.SENTINEL, RelationSide.SIDE_A);
    private final RelationTypeToken type;
    private final RelationSide side;
    private RelationTypeSide opposite;

    public RelationTypeSide(RelationTypeToken type, RelationSide side) {
        super(type.getId(), type.getName());
        this.type = type;
        this.side = side;
    }

    public static RelationTypeSide create(RelationTypeToken type, RelationSide side) {
        return new RelationTypeSide(type, side);
    }

    public synchronized RelationTypeSide getOpposite() {
        if (this.opposite == null) {
            this.opposite = new RelationTypeSide(this.type, this.side.oppositeSide());
        }
        return this.opposite;
    }

    public RelationTypeToken getRelationType() {
        return this.type;
    }

    public boolean isOfType(RelationTypeToken type) {
        return this.type.equals(type);
    }

    public RelationSide getSide() {
        return this.side;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationTypeSide) {
            RelationTypeSide rel = (RelationTypeSide)obj;
            return this.type.equals(rel.type) && this.side.equals((Object)rel.side);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "RelationTypeSide [type=" + this.type.getName() + ", side=" + (Object)((Object)this.side) + "]";
    }

    public Long getGuid() {
        return this.getId();
    }

    @Override
    public RelationTypeMultiplicity getMultiplicity() {
        return this.type.getMultiplicity();
    }

    @Override
    public RelationSorter getOrder() {
        return this.type.getOrder();
    }

    @Override
    public ArtifactTypeToken getArtifactType(RelationSide relationSide) {
        return this.type.getArtifactType(relationSide);
    }

    @Override
    public String getSideName(RelationSide relationSide) {
        return this.type.getSideName(relationSide);
    }

    @Override
    public boolean isArtifactTypeAllowed(RelationSide relationSide, ArtifactTypeToken artifactType) {
        return this.type.isArtifactTypeAllowed(relationSide, artifactType);
    }

    @Override
    public boolean isOrdered() {
        return this.type.isOrdered();
    }

    @Override
    public boolean isNewRelationTable() {
        return this.type.isNewRelationTable();
    }

    @Override
    public ArtifactTypeToken getRelationArtifactType() {
        return this.type.getRelationArtifactType();
    }

    @Override
    public RelationTypeToken getOldRelationTypeToken() {
        return this.type.getOldRelationTypeToken();
    }
}

