/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ArtifactAnnotation {
    private Type type;
    private String namespace;
    private String content;
    private static String TYPE_TAG = "type";
    private static String NAMESPACE_TAG = "NAMESPACE";
    private static String CONTENT_TAG = "content";

    public ArtifactAnnotation(Type type, String namespace, String message) {
        this.type = type;
        this.content = message;
        this.namespace = namespace;
    }

    public ArtifactAnnotation(String xml) {
        this.fromXml(xml);
    }

    public static ArtifactAnnotation getError(String namespace, String message) {
        return new ArtifactAnnotation(Type.Error, namespace, message);
    }

    public static ArtifactAnnotation getInfo(String namespace, String message) {
        return new ArtifactAnnotation(Type.Info, namespace, message);
    }

    public static ArtifactAnnotation getHidden(String namespace, String message) {
        return new ArtifactAnnotation(Type.Hidden, namespace, message);
    }

    public static ArtifactAnnotation getWarning(String namespace, String message) {
        return new ArtifactAnnotation(Type.Warning, namespace, message);
    }

    public String toXml() {
        return String.valueOf(AXml.addTagData((String)TYPE_TAG, (String)this.type.name())) + AXml.addTagData((String)NAMESPACE_TAG, (String)this.namespace) + AXml.addTagData((String)CONTENT_TAG, (String)this.content);
    }

    public void fromXml(String xml) {
        String typeStr = AXml.getTagData((String)xml, (String)TYPE_TAG);
        this.type = !Strings.isValid((String)typeStr) ? Type.None : Type.valueOf(typeStr);
        this.namespace = AXml.getTagData((String)xml, (String)NAMESPACE_TAG);
        this.content = AXml.getTagData((String)xml, (String)CONTENT_TAG);
    }

    public Type getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static enum Type {
        None,
        Info,
        Warning,
        Error,
        Hidden;

        private static Type[] orderedTypes;

        static {
            orderedTypes = new Type[]{Error, Warning, Info, Hidden, None};
        }

        public static Type[] getOrderedTypes() {
            return orderedTypes;
        }
    }
}

