/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.Collection;
import org.eclipse.osee.coverage.PartitionResultApi;
import org.eclipse.osee.coverage.PartitionResultEndpoint;
import org.eclipse.osee.coverage.internal.PartitionResultToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class PartitionResultEndpointImpl
implements PartitionResultEndpoint {
    private final PartitionResultApi partitionResultApi;
    private final BranchId branch;

    public PartitionResultEndpointImpl(BranchId branch, PartitionResultApi partitionResultApi) {
        this.partitionResultApi = partitionResultApi;
        this.branch = branch;
    }

    @Override
    public Collection<PartitionResultToken> getAllPartitionResults(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType, boolean activeOnly) {
        ArtifactId artifactId = viewId = viewId.isValid() ? viewId : ArtifactId.SENTINEL;
        if (Strings.isValid((String)filter)) {
            return this.partitionResultApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.partitionResultApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public PartitionResultToken getPartitionResult(ArtifactId partitionResultId) {
        return this.partitionResultApi.get(this.branch, partitionResultId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.partitionResultApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

