/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.Collection;
import org.eclipse.osee.coverage.PartitionDefApi;
import org.eclipse.osee.coverage.PartitionDefEndpoint;
import org.eclipse.osee.coverage.internal.PartitionDefToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class PartitionDefEndpointImpl
implements PartitionDefEndpoint {
    private final PartitionDefApi partitionDefApi;
    private final BranchId branch;

    public PartitionDefEndpointImpl(BranchId branch, PartitionDefApi partitionDefApi) {
        this.partitionDefApi = partitionDefApi;
        this.branch = branch;
    }

    @Override
    public Collection<PartitionDefToken> getAllPartitionDefs(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType, boolean activeOnly) {
        ArtifactId artifactId = viewId = viewId.isValid() ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.partitionDefApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.partitionDefApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public PartitionDefToken getPartitionDef(ArtifactId partitionDefId) {
        return this.partitionDefApi.get(this.branch, partitionDefId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.partitionDefApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

