/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing;

import java.util.List;
import java.util.Objects;
import org.eclipse.osee.define.api.publishing.PublishingOptions;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.OutliningOptions;
import org.eclipse.osee.framework.core.publishing.RendererOptions;

public class TemplatePublishingData {
    private final RendererOptions rendererOptions;
    private final PublishingOptions publishingOptions;

    private TemplatePublishingData(RendererOptions rendererOptions, PublishingOptions publishingOptions) {
        this.rendererOptions = rendererOptions;
        this.publishingOptions = publishingOptions;
    }

    public String getElementType() {
        return this.rendererOptions.getElementType();
    }

    public List<AttributeOptions> getAttributeElements() {
        return List.of(this.rendererOptions.getAttributeOptions());
    }

    public List<MetadataOptions> getMetadataElements() {
        return List.of(this.rendererOptions.getMetadataOptions());
    }

    public PublishingOptions getPublishingOptions() {
        return this.publishingOptions;
    }

    public OutliningOptions getOutliningOptions() {
        return this.rendererOptions.getOutliningOptions()[0];
    }

    public static TemplatePublishingData create(RendererOptions rendererOptions, PublishingOptions publishingOptions) {
        if (!"Artifact".equals(rendererOptions.getElementType())) {
            return new TemplatePublishingData(rendererOptions, null);
        }
        publishingOptions = Objects.isNull(publishingOptions) ? new PublishingOptions() : publishingOptions;
        return new TemplatePublishingData(rendererOptions, publishingOptions);
    }
}

