/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoProgamDescriptorData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.DispoAdminEndpoint;
import org.eclipse.osee.disposition.rest.resources.DispoConfigEndpoint;
import org.eclipse.osee.disposition.rest.resources.DispoSetEndpoint;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;

@Path(value="program")
@Swagger
public class DispoProgramEndpoint {
    private final DispoApi dispoApi;

    public DispoProgramEndpoint(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Operation(summary="Create a new Disposition Set given a DispoSetDescriptor")
    @Tags(value={@Tag(name="create"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK. Created the Disposition Set"), @ApiResponse(responseCode="409", description="Conflict. Tried to create a Disposition Set with same name"), @ApiResponse(responseCode="400", description="Bad Request. Did not provide both a Name and a valid Import Path")})
    public Response createProgram(DispoProgamDescriptorData programDescriptor, @Parameter(description="The Username") @QueryParam(value="userName") String userName) {
        Response response;
        String name = "(DISPO)" + programDescriptor.getName();
        if (!name.isEmpty()) {
            boolean isUniqueName = this.dispoApi.isUniqueProgramName(name);
            if (isUniqueName) {
                long createdProgramId = this.dispoApi.createDispoProgram(name, userName);
                Response.Status status = Response.Status.CREATED;
                response = Response.status((Response.Status)status).entity((Object)createdProgramId).build();
            } else {
                Response.Status status = Response.Status.CONFLICT;
                response = Response.status((Response.Status)status).entity((Object)"Can't create sets with the same name").build();
            }
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Set must have a name and import path").build();
        }
        return response;
    }

    @Path(value="{name}")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"text/plain"})
    @Operation(summary="Create a new Disposition Set given a name")
    @Tags(value={@Tag(name="create"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK. Created the Disposition Set"), @ApiResponse(responseCode="409", description="Conflict. Tried to create a Disposition Set with same name"), @ApiResponse(responseCode="400", description="Bad Request. Did not provide both a Name and a valid Import Path")})
    public Response createDispoProgramByName(@PathParam(value="name") String name, @QueryParam(value="userName") String userName) {
        DispoProgamDescriptorData programDescriptor = new DispoProgamDescriptorData();
        programDescriptor.setName(name);
        return this.createProgram(programDescriptor, userName);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all Disposition Programs as JSON")
    @Tag(name="program")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Disposition Programs"), @ApiResponse(responseCode="400", description="Not Found. Could not find any Disposition Programs")})
    public Response getAllPrograms() {
        List<BranchToken> allPrograms = this.dispoApi.getDispoPrograms();
        Collections.sort(allPrograms, new Comparator<BranchToken>(){

            @Override
            public int compare(BranchToken o1, BranchToken o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        LinkedList branchList = new LinkedList();
        for (BranchToken branch : allPrograms) {
            HashMap<String, String> mapObject = new HashMap<String, String>();
            String uuid = branch.getIdString();
            mapObject.put("value", uuid);
            mapObject.put("text", branch.getName());
            branchList.add(mapObject);
        }
        Response.Status status = allPrograms.isEmpty() ? Response.Status.NOT_FOUND : Response.Status.OK;
        String branchListJson = JsonUtil.toJson(branchList);
        return Response.status((Response.Status)status).entity((Object)branchListJson).build();
    }

    @Path(value="getDispoBranchId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Operation(summary="Get a Branch ID given a Branch name")
    @Tag(name="branch")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Branch ID"), @ApiResponse(responseCode="400", description="Not Found. Could not find any Branch ID")})
    public String getDispoBranchId(@Parameter(description="The Branch name", required=true) @FormParam(value="name") String branchName) {
        return this.dispoApi.getDispoProgramIdByName(branchName).getIdString();
    }

    @Path(value="importAll")
    @PUT
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Operation(summary="Import All Disposition Sets that are in a given State. Default state is \"NONE\"")
    @Tags(value={@Tag(name="import"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Import successful"), @ApiResponse(responseCode="404", description="Not Found. Can't connect to server"), @ApiResponse(responseCode="405", description="Method Not Allowed. Invalid permission"), @ApiResponse(responseCode="415", description="Unsupported Media Type")})
    public Response importAllDispoSets(String filterState) {
        this.dispoApi.importAllDispoPrograms(filterState, "OSEE System Auto-Import (All)");
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="importDispoBranch")
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Import All Disposition Sets that are in a given Branch and State. Default state is \"NONE\"")
    @Tags(value={@Tag(name="import"), @Tag(name="branch")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Import successful"), @ApiResponse(responseCode="404", description="Not Found. Can't connect to server"), @ApiResponse(responseCode="415", description="Unsupported Media Type")})
    public Response importDispoBranchByName(@Parameter(description="The Filter state", required=true) @FormParam(value="filterState") String filterState, @Parameter(description="The Branch name", required=true) @FormParam(value="name") String branchName) {
        BranchToken branch = this.dispoApi.getDispoProgramIdByName(branchName);
        this.dispoApi.importAllDispoSets((BranchId)branch, filterState, "OSEE System Auto-Import (Branch)");
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{branchId}/set")
    @Operation(summary="Get Annotation")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Annotation found"), @ApiResponse(responseCode="404", description="Not Found. Can't find annotation")})
    public DispoSetEndpoint getAnnotation(@Parameter(description="The Branch ID", required=true) @PathParam(value="branchId") BranchId branch) {
        return new DispoSetEndpoint(this.dispoApi, branch);
    }

    @Path(value="{branchId}/admin")
    @Operation(summary="Get Dispo Set report")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Retrieved Dispo Set report"), @ApiResponse(responseCode="404", description="Not Found. Can't find Dispo Set report")})
    public DispoAdminEndpoint getDispoSetReport(@Parameter(description="The Branch ID", required=true) @PathParam(value="branchId") BranchId branch) {
        return new DispoAdminEndpoint(this.dispoApi, branch);
    }

    @Path(value="{branchId}/config")
    @Operation(summary="Get Dispo Datastore")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Retrieved the Dispo Datastore"), @ApiResponse(responseCode="404", description="Not Found. Can't find the Dispo Datastore")})
    public DispoConfigEndpoint getDispoDataStore(@Parameter(description="The Branch ID", required=true) @PathParam(value="branchId") BranchId branch) {
        return new DispoConfigEndpoint(this.dispoApi, branch);
    }
}

