/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.LocationRange;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.disposition.rest.util.LocationRangeComparator;
import org.eclipse.osee.disposition.rest.util.LocationRangeUtil;
import org.eclipse.osee.logger.Log;

public class DispoConnector {
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start() {
        this.logger.trace("Starting DispoConnector...", new Object[0]);
    }

    public void stop() {
        this.logger.trace("Stopping DispoConnector...", new Object[0]);
    }

    public List<String> getAllUncoveredDiscrepancies(DispoItem item) {
        Map discrepancies = item.getDiscrepanciesList();
        List annotationsList = item.getAnnotationsList();
        HashSet<String> allCoveredDiscrepancies = this.getAllCoveredDiscrepanciesFromAnnotations(discrepancies, annotationsList);
        ArrayList<String> allDiscrepancies = this.createDiscrepanciesList(discrepancies);
        allDiscrepancies.removeAll(allCoveredDiscrepancies);
        return allDiscrepancies;
    }

    public String getItemStatus(DispoItem item) {
        List annotations = item.getAnnotationsList();
        boolean isPass = true;
        boolean isAnalysis = false;
        boolean needsModify = false;
        boolean isIncomplete = false;
        if (annotations != null) {
            for (DispoAnnotationData annotation : annotations) {
                if (annotation.getIsPairAnnotation()) continue;
                if (!annotation.getIsResolutionValid()) {
                    isIncomplete = true;
                    isPass = false;
                }
                if (annotation.getIsAnalyze()) {
                    isAnalysis = true;
                    isPass = false;
                }
                if (annotation.getNeedsModify()) {
                    needsModify = true;
                    isPass = false;
                }
                if (annotation.getIsDefault()) continue;
                isPass = false;
            }
        }
        String toReturn = isPass ? "PASS" : (isIncomplete ? "INCOMPLETE" : (needsModify ? "MODIFY" : (isAnalysis ? "ANALYSIS-COMPLETE" : "COMPLETE")));
        return toReturn;
    }

    private ArrayList<String> createDiscrepanciesList(Map<String, Discrepancy> discrepancies) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = discrepancies.get(key);
            toReturn.add(discrepancy.getLocation());
        }
        return toReturn;
    }

    private HashSet<String> getAllCoveredDiscrepanciesFromAnnotations(Map<String, Discrepancy> discrepancies, List<DispoAnnotationData> annotations) {
        HashSet<String> toReturn = new HashSet<String>();
        if (annotations != null) {
            for (DispoAnnotationData annotation : annotations) {
                List idsOfCoveredDiscrepancies = annotation.getIdsOfCoveredDiscrepancies();
                for (String id : idsOfCoveredDiscrepancies) {
                    if (!discrepancies.containsKey(id)) continue;
                    Discrepancy discrepancy = discrepancies.get(id);
                    toReturn.add(discrepancy.getLocation());
                }
            }
        }
        return toReturn;
    }

    public boolean connectAnnotation(DispoAnnotationData annotation, Map<String, Discrepancy> discrepanciesList) {
        if (DispoUtil.isNumericLocations(annotation.getLocationRefs())) {
            return this.connectNumberLocationRangeAnnotation(annotation, discrepanciesList);
        }
        return this.connectStringLocationRangeAnnotation(annotation, discrepanciesList);
    }

    private boolean connectNumberLocationRangeAnnotation(DispoAnnotationData annotation, Map<String, Discrepancy> discrepanciesList) {
        boolean isAllLocRefValid = true;
        HashMap<String, String> testPointNumberToId = this.getPointNumbersToIds(discrepanciesList);
        List<LocationRange> listOfLocationRefs = this.sortList(annotation.getLocationRefs());
        ArrayList<String> workingIdsOfCovered = new ArrayList<String>();
        block0: for (LocationRange singleLocationRef : listOfLocationRefs) {
            if (singleLocationRef.getStart() != singleLocationRef.getEnd()) {
                int i = singleLocationRef.getStart();
                while (i <= singleLocationRef.getEnd()) {
                    if (!this.tryToAddDiscrepancyForTestPointNumber(testPointNumberToId, i, workingIdsOfCovered)) {
                        isAllLocRefValid = false;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (this.tryToAddDiscrepancyForTestPointNumber(testPointNumberToId, singleLocationRef.getStart(), workingIdsOfCovered)) continue;
            isAllLocRefValid = false;
            break;
        }
        annotation.setLocationRefs(DispoConnector.getLocRefsAsString(listOfLocationRefs));
        if (isAllLocRefValid) {
            annotation.setIsConnected(true);
            annotation.setIdsOfCoveredDiscrepancies(new ArrayList(workingIdsOfCovered));
        } else {
            annotation.setIsConnected(false);
        }
        return isAllLocRefValid;
    }

    private boolean connectStringLocationRangeAnnotation(DispoAnnotationData annotation, Map<String, Discrepancy> discrepanciesList) {
        boolean isAllLocRefValid = true;
        HashMap<String, String> testPointIdentifierToId = this.getPointIdentifiersToIds(discrepanciesList);
        String locationRef = annotation.getLocationRefs();
        ArrayList<String> workingIdsOfCovered = new ArrayList<String>();
        if (locationRef.contains(",")) {
            List<String> indvLocationRefs = Arrays.asList(locationRef.split(","));
            for (String indvLocationRef : indvLocationRefs) {
                if (this.tryToAddDiscrepancyForStringLocationRef(testPointIdentifierToId, indvLocationRef.trim(), workingIdsOfCovered)) continue;
                isAllLocRefValid = false;
                break;
            }
        } else if (!this.tryToAddDiscrepancyForStringLocationRef(testPointIdentifierToId, locationRef.trim(), workingIdsOfCovered)) {
            isAllLocRefValid = false;
        }
        if (isAllLocRefValid) {
            annotation.setIsConnected(true);
            annotation.setIdsOfCoveredDiscrepancies(new ArrayList<String>(workingIdsOfCovered));
        } else {
            annotation.setIsConnected(false);
        }
        return isAllLocRefValid;
    }

    private boolean tryToAddDiscrepancyForStringLocationRef(HashMap<String, String> locationToId, String locationRef, List<String> workingList) {
        String idOfMatched = locationToId.get(locationRef);
        if (idOfMatched == null) {
            return false;
        }
        workingList.add(idOfMatched);
        return true;
    }

    private boolean tryToAddDiscrepancyForTestPointNumber(HashMap<String, String> testPointLocationToId, int testPoint, List<String> workingList) {
        String idOfMatched = testPointLocationToId.get(String.valueOf(testPoint));
        if (idOfMatched == null) {
            return false;
        }
        workingList.add(idOfMatched);
        return true;
    }

    private HashMap<String, String> getPointIdentifiersToIds(Map<String, Discrepancy> discrepancies) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (Discrepancy discrepancy : discrepancies.values()) {
            toReturn.put(discrepancy.getLocation().trim(), discrepancy.getId());
        }
        return toReturn;
    }

    private HashMap<String, String> getPointNumbersToIds(Map<String, Discrepancy> discrepancies) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        Set<String> keys = discrepancies.keySet();
        for (String key : keys) {
            Discrepancy discrepancy = discrepancies.get(key);
            String pointNumber = discrepancy.getLocation();
            toReturn.put(pointNumber, discrepancy.getId());
        }
        return toReturn;
    }

    public List<LocationRange> getAllUncovered(LocationRange toBeCovered, List<LocationRange> allLocationRefs) {
        int startIndex = toBeCovered.getStart();
        int endIndex = toBeCovered.getEnd();
        int firstUncoveredIndex = startIndex;
        Collections.reverse(allLocationRefs);
        Stack<LocationRange> locationRefsStack = new Stack<LocationRange>();
        locationRefsStack.addAll(allLocationRefs);
        ArrayList<LocationRange> allUncovered = new ArrayList<LocationRange>();
        while (locationRefsStack.size() > 0) {
            LocationRange locRef = (LocationRange)locationRefsStack.pop();
            if (locRef.getEnd() < startIndex) continue;
            if (locRef.getStart() == firstUncoveredIndex) {
                if (locRef.getEnd() == endIndex) {
                    firstUncoveredIndex = -1;
                    break;
                }
                firstUncoveredIndex = locRef.getEnd() + 1;
                continue;
            }
            if (locationRefsStack.size() <= 0) continue;
            LocationRange nextLocRef = (LocationRange)locationRefsStack.peek();
            LocationRange uncoveredRange = new LocationRange(firstUncoveredIndex, nextLocRef.getStart() - 1);
            allUncovered.add(uncoveredRange);
        }
        if (firstUncoveredIndex != -1) {
            LocationRange uncoveredRange = new LocationRange(firstUncoveredIndex, endIndex);
            allUncovered.add(uncoveredRange);
        }
        return allUncovered;
    }

    private static String getLocRefsAsString(List<LocationRange> list) {
        StringBuilder sb = new StringBuilder();
        for (LocationRange range : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(range.toString());
        }
        return sb.toString();
    }

    private List<LocationRange> sortList(String allLocationRefsString) {
        allLocationRefsString = allLocationRefsString.replaceAll("\\s*", "");
        ArrayList<LocationRange> toReturn = new ArrayList<LocationRange>();
        StringTokenizer tokenizer = new StringTokenizer(allLocationRefsString, ",");
        while (tokenizer.hasMoreTokens()) {
            String singleLocationRefString = tokenizer.nextToken();
            LocationRange range = LocationRangeUtil.parseLocation(singleLocationRefString);
            toReturn.add(range);
        }
        Collections.sort(toReturn, new LocationRangeComparator());
        return toReturn;
    }
}

