/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.OrcsVisitor;
import org.eclipse.osee.orcs.core.ds.OrcsVisitorAdapter;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionProcessor;
import org.eclipse.osee.orcs.search.IndexerCollector;

public class TransactionIndexer
implements TransactionProcessor {
    private final Log logger;
    private final QueryEngineIndexer indexer;
    private final OrcsTokenService tokenService;

    public TransactionIndexer(Log logger, QueryEngineIndexer indexer, OrcsTokenService tokenService) {
        this.logger = logger;
        this.indexer = indexer;
        this.tokenService = tokenService;
    }

    @Override
    public void process(HasCancellation cancellation, OrcsSession session, TransactionData txData) {
        try {
            final LinkedHashSet datas = new LinkedHashSet();
            txData.getChangeSet().accept((OrcsVisitor)new OrcsVisitorAdapter(){

                public <T> void visit(AttributeData<T> data) {
                    if (TransactionIndexer.this.tokenService.getAttributeType(((AttributeTypeToken)data.getType()).getId()).isTaggable()) {
                        datas.add(data.getVersion().getGammaId().getId());
                    }
                }
            });
            List futures = (List)this.indexer.indexResources(session, this.tokenService, datas, new IndexerCollector[0]).call();
            for (Future future : futures) {
                if (cancellation != null && cancellation.isCancelled()) {
                    future.cancel(true);
                    continue;
                }
                future.get();
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error indexing transaction [%s]", new Object[]{txData});
        }
    }
}

