/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.orcs.ImportOptions;
import org.eclipse.osee.orcs.db.internal.exchange.ExchangeDb;
import org.eclipse.osee.orcs.db.internal.exchange.IdTranslator;

public class TranslationManager {
    private static final String IMPORT_MAPPED_INDEX_SEQ = "SKYNET_IMPORT_MAPPED_INDEX_SEQ";
    private static final String INSERT_INTO_IMPORT_MAP = "INSERT INTO osee_import_map (import_id, sequence_id, sequence_name) VALUES (?, ?, ?)";
    private final List<IdTranslator> translators;
    private final Map<String, IdTranslator> translatorMap;
    private final JdbcClient jdbcClient;
    private boolean useOriginalIds;

    public TranslationManager(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
        this.useOriginalIds = true;
        this.translators = ExchangeDb.createTranslators(jdbcClient);
        this.translatorMap = new HashMap<String, IdTranslator>();
        for (IdTranslator translator : this.translators) {
            for (String alias : translator.getAliases()) {
                this.translatorMap.put(alias, translator);
            }
        }
    }

    public void configure(PropertyStore options) {
        if (options != null) {
            this.useOriginalIds = options.getBoolean(ImportOptions.USE_IDS_FROM_IMPORT_FILE.name());
        }
    }

    public void loadTranslators(String sourceDatabaseId) {
        for (IdTranslator translator : this.translators) {
            translator.load(sourceDatabaseId);
        }
    }

    public List<String> getSequenceNames() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (IdTranslator translatedIdMap : this.translators) {
            toReturn.add(translatedIdMap.getSequenceName());
        }
        return toReturn;
    }

    public void store(JdbcConnection connection, int importIdIndex) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (IdTranslator translatedIdMap : this.translators) {
            if (!translatedIdMap.hasItemsToStore()) continue;
            int importSeqId = (int)this.jdbcClient.getNextSequence(IMPORT_MAPPED_INDEX_SEQ, true);
            data.add(new Object[]{importIdIndex, importSeqId, translatedIdMap.getSequenceName()});
            translatedIdMap.store(connection, importSeqId);
        }
        this.jdbcClient.runBatchUpdate(connection, INSERT_INTO_IMPORT_MAP, data);
    }

    public boolean isTranslatable(String name) {
        return this.translatorMap.containsKey(name.toLowerCase());
    }

    public Object translate(String name, Object original) {
        IdTranslator translator;
        Object toReturn = original;
        if (original != null && !this.useOriginalIds && (translator = this.translatorMap.get(name.toLowerCase())) != null) {
            toReturn = translator.getId(original);
        }
        return toReturn;
    }

    public void checkIdMapping(String name, Long original, Long newValue) {
        Long data;
        IdTranslator translator = this.translatorMap.get(name.toLowerCase());
        if (!(translator == null || (data = translator.getFromCache(original)) != null && data.equals(newValue))) {
            translator.addToCache(original, newValue);
        }
    }
}

