/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;

public class MimChangeSummaryItem {
    private final ArtifactReadable art;
    private boolean added;
    private boolean deleted;
    private boolean addedDueToApplicChange;
    private boolean deletedDueToApplicChange;
    private ApplicabilityToken wasApplic;
    private ApplicabilityToken isApplic;
    private final List<ChangeReportRowDto> attributeChanges;
    private final List<ChangeReportRowDto> relationChanges;
    private final List<MimChangeSummaryItem> children;

    public MimChangeSummaryItem(ArtifactReadable art) {
        this.art = art;
        this.added = false;
        this.deleted = false;
        this.addedDueToApplicChange = false;
        this.deletedDueToApplicChange = false;
        this.wasApplic = ApplicabilityToken.SENTINEL;
        this.isApplic = ApplicabilityToken.SENTINEL;
        this.attributeChanges = new LinkedList<ChangeReportRowDto>();
        this.relationChanges = new LinkedList<ChangeReportRowDto>();
        this.children = new LinkedList<MimChangeSummaryItem>();
    }

    public boolean isAdded() {
        return this.added;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isAddedDueToApplicChange() {
        return this.addedDueToApplicChange;
    }

    public void setAddedDueToApplicChange(boolean addedDueToApplicChange) {
        this.addedDueToApplicChange = addedDueToApplicChange;
    }

    public boolean isDeletedDueToApplicChange() {
        return this.deletedDueToApplicChange;
    }

    public void setDeletedDueToApplicChange(boolean deletedDueToApplicChange) {
        this.deletedDueToApplicChange = deletedDueToApplicChange;
    }

    public ApplicabilityToken getWasApplic() {
        return this.wasApplic;
    }

    public void setWasApplic(ApplicabilityToken wasApplic) {
        this.wasApplic = wasApplic;
    }

    public ApplicabilityToken getIsApplic() {
        return this.isApplic;
    }

    public void setIsApplic(ApplicabilityToken isApplic) {
        this.isApplic = isApplic;
    }

    public boolean isApplicabilityChanged() {
        return !this.getIsApplic().equals((Object)this.getWasApplic());
    }

    public ArtifactId getArtId() {
        return ArtifactId.valueOf((Long)this.art.getId());
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.art;
    }

    public String getName() {
        return this.art.getName();
    }

    public ArtifactTypeToken getArtType() {
        return this.art.getArtifactType();
    }

    public List<ChangeReportRowDto> getAttributeChanges() {
        return this.attributeChanges;
    }

    public List<ChangeReportRowDto> getRelationChanges() {
        return this.relationChanges;
    }

    public List<MimChangeSummaryItem> getChildren() {
        return this.children;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MimChangeSummaryItem) {
            return this.getArtId().equals(((MimChangeSummaryItem)obj).getArtId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

