/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceMessageTypeApi;
import org.eclipse.osee.mim.InterfaceMessageTypeEndpoint;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceMessageTypeEndpointImpl
implements InterfaceMessageTypeEndpoint {
    private final InterfaceMessageTypeApi messageTypeApi;
    private final BranchId branch;

    public InterfaceMessageTypeEndpointImpl(BranchId branch, InterfaceMessageTypeApi messageTypeApi) {
        this.messageTypeApi = messageTypeApi;
        this.branch = branch;
    }

    @Override
    public Collection<PLGenericDBObject> getAllMessageTypes(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.messageTypeApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.messageTypeApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public PLGenericDBObject getMessageType(ArtifactId messageTypeId) {
        return this.messageTypeApi.get(this.branch, messageTypeId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.messageTypeApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

