/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementSearchEndpoint;
import org.eclipse.osee.mim.types.ElementPosition;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureElementTokenWithPath;

public class InterfaceElementSearchEndpointImpl
implements InterfaceElementSearchEndpoint {
    private final BranchId branch;
    private final InterfaceElementApi elementApi;

    public InterfaceElementSearchEndpointImpl(BranchId branch, InterfaceElementApi interfaceElementApi) {
        this.branch = branch;
        this.elementApi = interfaceElementApi;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements(long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        return this.elementApi.getAll(this.branch, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements(String filter, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        return this.elementApi.getFiltered(this.branch, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElementsOfType(ArtifactId platformTypeId) {
        return this.elementApi.getElementsByType(this.branch, platformTypeId);
    }

    @Override
    public ElementPosition findElement(ArtifactId elementId) {
        return new ElementPosition();
    }

    @Override
    public Collection<InterfaceStructureElementTokenWithPath> getElementsByType() {
        return this.elementApi.getElementsByType(this.branch);
    }

    @Override
    public Collection<InterfaceStructureElementTokenWithPath> getElementsByType(String filter) {
        return this.elementApi.getElementsByTypeFilter(this.branch, filter);
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElementsByName(String name, long pageNum, long pageSize) {
        return this.elementApi.getElementsByName(this.branch, name, pageNum, pageSize);
    }

    @Override
    public int getElementsByNameCount(String name) {
        return this.elementApi.getElementsByNameCount(this.branch, name);
    }
}

