/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public final class AttributeSetRule
extends AbstractValidationRule {
    private final ArtifactTypeToken baseArtifactType;
    private final AttributeTypeToken attributeType;
    private final Integer minimumValues;
    private final String invalidValue;

    public AttributeSetRule(AtsApi atsApi, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, Integer minimumValues, String invalidValue) {
        super(atsApi);
        this.baseArtifactType = artifactType;
        this.attributeType = attributeType;
        this.minimumValues = minimumValues;
        this.invalidValue = invalidValue;
    }

    public boolean hasArtifactType(ArtifactTypeToken artifactType) {
        return artifactType.inheritsFrom((ArtifactTypeId)this.baseArtifactType);
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        if (this.hasArtifactType(this.atsApi.getStoreService().getArtifactType((ArtifactId)artifact))) {
            List attributeValues = this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)artifact, this.attributeType);
            int validValueFound = 0;
            for (String attributeValue : attributeValues) {
                if (attributeValue.equals(this.invalidValue)) {
                    String errStr = "has invalid " + this.invalidValue + " \"" + this.attributeType + "\" attribute";
                    this.logError(artifact, errStr, rd);
                    continue;
                }
                ++validValueFound;
            }
            if (validValueFound < this.minimumValues) {
                String errStr = "has less than minimum " + this.minimumValues + " values set for attribute \"" + this.attributeType + "\"";
                this.logError(artifact, errStr, rd);
            }
        }
    }

    public String getRuleDescription() {
        return "For \"" + this.baseArtifactType + "\", ensure \"" + this.attributeType + "\" attribute has at least " + this.minimumValues + " value(s)" + (this.invalidValue != null ? " and does NOT have \"" + this.invalidValue + "\" values" : "");
    }

    public String getRuleTitle() {
        return "Attribute Set Check:";
    }
}

