/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TaskPointsColumn
extends AbstractServicesColumn {
    public TaskPointsColumn(AtsApi atsApi) {
        super(atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        String result = "";
        if (this.atsApi.getStoreService().isDeleted(atsObject)) {
            return "<deleted>";
        }
        if (atsObject instanceof IAtsTeamWorkflow) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)atsObject;
            Collection tasks = this.atsApi.getTaskService().getTasks(teamWf);
            double value = 0.0;
            for (IAtsTask task : tasks) {
                String points = this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)task);
                if (!Strings.isNumeric((String)points)) continue;
                value += Double.parseDouble(points);
            }
            return value > 0.0 ? Double.toString(value) : result;
        }
        if (atsObject instanceof IAtsTask) {
            IAtsTask task = (IAtsTask)atsObject;
            return this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)task);
        }
        return result;
    }
}

