/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.util;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.WordUtils;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.HexUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ConvertOracleToOseeTypes {
    public void run() {
        try {
            String folder = "C:/UserData/TraxIssues/";
            String file = Lib.fileToString((File)new File(String.valueOf(folder) + "issues.txt"));
            StringBuilder oseeAttrDefFile = new StringBuilder();
            StringBuilder oseeAttrArtFile = new StringBuilder();
            StringBuilder typesFile = new StringBuilder();
            StringBuilder workDefFile = new StringBuilder();
            StringBuilder workDefWidgets = new StringBuilder();
            String[] stringArray = file.split("\r\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                System.out.println("line: " + line);
                String[] items = line.split(",");
                String origName = items[0];
                String type = items[1];
                String javaFieldName = "issue" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, origName);
                String attrDisplayName = WordUtils.capitalizeFully((String)origName, (char[])new char[]{'_'}).replaceAll("_", " ");
                String attrTypeName = "lba.issue." + attrDisplayName;
                System.out.println("name: [" + origName + "] attrType: [" + attrTypeName + "] java: [" + javaFieldName + "] attrDisplay: [" + attrDisplayName + "]");
                String hexId = HexUtil.toString((long)Lib.generateArtifactIdAsInt());
                if (type.equals("VARCHAR") || type.equals("CLOB") || type.equals("DATE")) {
                    String workDefStr;
                    this.replaceNameAndId(oseeAttrDefFile, attrTypeName, hexId, this.getVarCharAttrOseeTypes());
                    this.replaceNameAndId(typesFile, attrTypeName, hexId, this.getAttrJavaType(javaFieldName, attrTypeName));
                    this.replaceNameAndId(oseeAttrArtFile, attrTypeName, hexId, this.getArtAttrJavaType());
                    boolean fillVertically = type.equals("CLOB");
                    if (type.equals("CLOB") || type.equals("VARCHAR")) {
                        workDefStr = this.getWorkDefStrAttr(attrDisplayName, attrTypeName, "XTextDam", fillVertically);
                        workDefFile.append(workDefStr);
                    } else if (type.equals("DATE")) {
                        workDefStr = this.getWorkDefStrAttr(attrDisplayName, attrTypeName, "XDateDam", fillVertically);
                        workDefFile.append(workDefStr);
                    }
                } else if (type.equals("NUMBER")) {
                    this.replaceNameAndId(oseeAttrDefFile, attrTypeName, hexId, this.getIntegerAttrOseeTypes());
                    this.replaceNameAndId(typesFile, attrTypeName, hexId, this.getAttrJavaType(javaFieldName, attrTypeName));
                    this.replaceNameAndId(oseeAttrArtFile, attrTypeName, hexId, this.getArtAttrJavaType());
                    String workDefStr = this.getWorkDefStrAttr(attrDisplayName, attrTypeName, "XIntegerDam", false);
                    workDefFile.append(workDefStr);
                } else {
                    throw new OseeArgumentException("Unhandled attribute type", new Object[0]);
                }
                workDefWidgets.append("widget \"" + attrDisplayName + "\"\n");
                ++n2;
            }
            Lib.writeStringToFile((String)oseeAttrDefFile.toString(), (File)new File(String.valueOf(folder) + "out.osee"));
            typesFile.append(oseeAttrArtFile.toString());
            Lib.writeStringToFile((String)typesFile.toString(), (File)new File(String.valueOf(folder) + "out.java"));
            workDefFile.append(workDefWidgets.toString());
            Lib.writeStringToFile((String)workDefFile.toString(), (File)new File(String.valueOf(folder) + "out.ats"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String getWorkDefStrAttr(String name, String attrName, String widget, boolean fillVertically) {
        return String.format("   widgetDefinition \"%s\" {\n      attributeName \"%s\"\n      xWidgetName \"%s\"\n" + (fillVertically ? "      option FILL_VERTICALLY\n" : "") + "   }\n\n", name, attrName, widget);
    }

    private String getArtAttrJavaType() {
        return "attribute \"NAME\"\n";
    }

    private String getIntegerAttrOseeTypes() {
        return "attributeType \"NAME\" extends IntegerAttribute {\n   id ID\n   dataProvider DefaultAttributeDataProvider\n   min 0\n   max 1\n   mediaType \"text/plain\"\n}\n\n";
    }

    public String getAttrJavaType(String javaFieldName, String attrTypeName) {
        return String.format("public static final AttributeTypeId %s = AttributeTypeToken.valueOf(IDL, \"%s\");\n", javaFieldName, attrTypeName);
    }

    private void replaceNameAndId(StringBuilder sb, String attrTypeName, String hexId, String str) {
        str = str.replaceFirst("NAME", attrTypeName);
        str = str.replaceAll("ID", hexId);
        sb.append(str);
    }

    public static void main(String[] args) {
        ConvertOracleToOseeTypes convert = new ConvertOracleToOseeTypes();
        convert.run();
    }

    public String getVarCharAttrOseeTypes() {
        return "attributeType \"NAME\" extends StringAttribute {\n   id ID\n   dataProvider DefaultAttributeDataProvider\n   min 0\n   max 1\n   mediaType \"text/plain\"\n}\n\n";
    }
}

