/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.WorkItemWriterOptions;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.workitem.WorkItemJsonWriter;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;

@Provider
public class WorkItemsJsonWriter
implements MessageBodyWriter<Collection<IAtsWorkItem>> {
    private JsonFactory jsonFactory;
    private AtsApi atsApi;
    @Context
    private UriInfo uriInfo;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void setAtsApiServer(AtsApiServer atsApiServer) {
        this.atsApi = atsApiServer;
    }

    public void start() {
        this.jsonFactory = JsonUtil.getFactory();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(Collection<IAtsWorkItem> data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Lib.isCollectionOfType(type, (Type)genericType, IAtsWorkItem.class);
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void writeTo(Collection<IAtsWorkItem> workItems, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createGenerator(entityStream);
            writer.writeStartArray();
            MultivaluedMap queryParameters = this.uriInfo.getQueryParameters(true);
            LinkedList<WorkItemWriterOptions> options = new LinkedList<WorkItemWriterOptions>();
            boolean valuesWithIds = false;
            if (queryParameters.containsKey((Object)WorkItemWriterOptions.KeysAsIds.name()) && ((String)queryParameters.getFirst((Object)WorkItemWriterOptions.KeysAsIds.name())).equals("true")) {
                options.add(WorkItemWriterOptions.KeysAsIds);
            }
            if (queryParameters.containsKey((Object)WorkItemWriterOptions.DatesAsLong.name()) && ((String)queryParameters.getFirst((Object)WorkItemWriterOptions.DatesAsLong.name())).equals("true")) {
                options.add(WorkItemWriterOptions.DatesAsLong);
            }
            if (queryParameters.containsKey((Object)WorkItemWriterOptions.ValuesWithIds.name()) && ((String)queryParameters.getFirst((Object)WorkItemWriterOptions.ValuesWithIds.name())).equals("true")) {
                options.add(WorkItemWriterOptions.ValuesWithIds);
                valuesWithIds = true;
            }
            if (queryParameters.containsKey((Object)WorkItemWriterOptions.WriteRelatedAsTokens.name()) && ((String)queryParameters.getFirst((Object)WorkItemWriterOptions.WriteRelatedAsTokens.name())).equals("true")) {
                options.add(WorkItemWriterOptions.WriteRelatedAsTokens);
            }
            for (IAtsWorkItem workItem : workItems) {
                if (valuesWithIds) {
                    WorkItemJsonWriter.addWorkItemWithIds(this.atsApi, this.orcsApi, workItem, annotations, writer, this.matches(IdentityView.class, annotations), options);
                    continue;
                }
                WorkItemJsonWriter.addWorkItem(this.atsApi, this.orcsApi, workItem, annotations, writer, this.matches(IdentityView.class, annotations), options);
            }
            writer.writeEndArray();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }
}

