/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.applications;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Application;
import org.eclipse.osee.jaxrs.server.internal.JaxRsConfiguration;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitable;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitor;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsFactory;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.Bundle;

public class JaxRsApplicationRegistry
implements JaxRsVisitable {
    private final ConcurrentHashMap<String, JaxRsContainerProvider> servlets = new ConcurrentHashMap();
    private Log logger;
    private JaxRsFactory factory;
    private String baseContext = "/";

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJaxRsFactory(JaxRsFactory factory) {
        this.factory = factory;
    }

    public void start() {
        this.logger.trace("Starting [%s]...", new Object[]{this.getClass().getSimpleName()});
    }

    public void stop() {
        this.logger.trace("Stopping [%s]...", new Object[]{this.getClass().getSimpleName()});
        Iterator<JaxRsContainerProvider> iterator = this.servlets.values().iterator();
        while (iterator.hasNext()) {
            JaxRsContainer container = iterator.next().get();
            if (container != null) {
                container.stop();
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseContext() {
        JaxRsApplicationRegistry jaxRsApplicationRegistry = this;
        synchronized (jaxRsApplicationRegistry) {
            return this.baseContext;
        }
    }

    public synchronized void configure(JaxRsConfiguration config) {
        this.logger.trace("Configuring [%s]...", new Object[]{this.getClass().getSimpleName()});
        String oldBaseContext = this.baseContext;
        String newBaseContext = config.getBaseContext();
        if (!oldBaseContext.equals(newBaseContext)) {
            this.logger.trace("Configuration Changed for [%s] - [%s]", new Object[]{this.getClass().getSimpleName(), config});
            this.baseContext = newBaseContext;
            JaxRsContainerProvider removed = this.servlets.remove(oldBaseContext);
            if (removed != null && removed.hasContainer()) {
                JaxRsContainer container = removed.get();
                container.stop();
                container.accept(new JaxRsVisitor(){

                    @Override
                    public void onApplication(String applicationContext, String componentName, Bundle bundle, Application application) {
                        String baseContext = JaxRsApplicationRegistry.this.getBaseContext();
                        JaxRsContainer newContainer = JaxRsApplicationRegistry.this.getContainerInitIfNull(baseContext);
                        newContainer.addApplication(componentName, applicationContext, bundle, application);
                    }

                    @Override
                    public void onProvider(String componentName, Bundle bundle, Object provider) {
                        String baseContext = JaxRsApplicationRegistry.this.getBaseContext();
                        JaxRsContainer newContainer = JaxRsApplicationRegistry.this.getContainerInitIfNull(baseContext);
                        newContainer.addProvider(componentName, bundle, provider);
                    }
                });
            }
        }
    }

    public void register(String componentName, Bundle bundle, Application application) {
        String contextName = JaxRsUtils.getApplicationPath(componentName, application);
        String baseContext = this.getBaseContext();
        JaxRsContainer container = this.getContainerInitIfNull(baseContext);
        container.addApplication(componentName, contextName, bundle, application);
    }

    public void deregister(String componentName) {
        String baseContext = this.getBaseContext();
        JaxRsContainer container = this.getContainerOrNull(baseContext);
        if (container != null) {
            container.removeApplication(componentName);
            if (container.isEmpty()) {
                this.servlets.remove(baseContext);
            }
        }
    }

    public void registerProvider(String componentName, Bundle bundle, Object provider) {
        String baseContext = this.getBaseContext();
        JaxRsContainer container = this.getContainerInitIfNull(baseContext);
        container.addProvider(componentName, bundle, provider);
    }

    public void deregisterProvider(String componentName) {
        String baseContext = this.getBaseContext();
        JaxRsContainer container = this.getContainerOrNull(baseContext);
        if (container != null) {
            container.removeProvider(componentName);
            if (container.isEmpty()) {
                this.servlets.remove(baseContext);
            }
        }
    }

    @Override
    public void accept(JaxRsVisitor visitor) {
        visitor.onStartRegistry();
        try {
            for (JaxRsContainerProvider provider : this.servlets.values()) {
                if (!provider.hasContainer()) continue;
                JaxRsContainer container = provider.get();
                container.accept(visitor);
            }
        }
        finally {
            visitor.onEndRegistry();
        }
    }

    private JaxRsContainer getContainerOrNull(String contextName) {
        JaxRsContainer toReturn = null;
        JaxRsContainerProvider reference = this.servlets.get(contextName);
        if (reference != null) {
            toReturn = reference.get();
        }
        return toReturn;
    }

    private JaxRsContainer getContainerInitIfNull(String contextName) {
        JaxRsContainerProvider newContainer;
        JaxRsContainerProvider reference = this.servlets.get(contextName);
        if (reference == null && (reference = this.servlets.putIfAbsent(contextName, newContainer = this.factory.newJaxRsContainerProvider(contextName))) == null) {
            this.servlets.put(contextName, newContainer);
            reference = newContainer;
        }
        return reference.get();
    }

    public static interface JaxRsContainer {
        public String getServletContext();

        public void setServletContext(String var1);

        public void addApplication(String var1, String var2, Bundle var3, Application var4);

        public void removeApplication(String var1);

        public boolean isEmpty();

        public void start();

        public void stop();

        public void accept(JaxRsVisitor var1);

        public void addProvider(String var1, Bundle var2, Object var3);

        public void removeProvider(String var1);
    }

    public static interface JaxRsContainerProvider {
        public JaxRsContainer get();

        public JaxRsContainer unSet();

        public boolean hasContainer();
    }
}

