/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.logger.Log;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public final class JaxRsResourceManager
implements BundleListener {
    private static final String OSEE_WEB_RESOURCE_HDR = "Osee-JaxRs-Resource";
    private static final String OSEE_WEB_RESOURCE_HDR__PATH_ATTRIBUTE = "path";
    private static final String OSEE_WEB_RESOURCE_HDR__SECURE_ATTRIBUTE = "secure";
    private Map<String, Resource> pathToResource;
    private Map<Bundle, Set<String>> bundleToKey;
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(BundleContext context) {
        this.pathToResource = new HashMap<String, Resource>();
        this.bundleToKey = new HashMap<Bundle, Set<String>>();
        context.addBundleListener((BundleListener)this);
        Bundle[] bundles = context.getBundles();
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                int state = bundle.getState();
                this.processBundle(bundle, state);
                ++n2;
            }
        }
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        if (this.pathToResource != null) {
            this.pathToResource.clear();
            this.pathToResource = null;
        }
        if (this.bundleToKey != null) {
            this.bundleToKey.clear();
            this.bundleToKey = null;
        }
    }

    public Resource getResource(String path) {
        String toMatch = JaxRsUtils.normalize(path);
        return this.pathToResource.get(toMatch);
    }

    public Resource findResource(ContainerRequestContext requestContext) {
        UriInfo uriInfo = requestContext.getUriInfo();
        String path = Lib.getURIAbsolutePath((UriInfo)uriInfo);
        Resource resource = this.getResource(path);
        if (resource == null && !this.hasExtension(path)) {
            List<MediaType> mediaTypes = this.getMediaTypesToSearch(requestContext);
            for (MediaType mediaType : mediaTypes) {
                String resourcePath = this.addExtension(path, mediaType);
                if (Strings.isValid((String)resourcePath) && (resource = this.getResource(resourcePath)) != null) break;
            }
        }
        return resource;
    }

    private boolean hasExtension(String path) {
        String extension = null;
        if (Strings.isValid((String)path)) {
            int index = path.lastIndexOf("/");
            String toProcess = path;
            if (index > 0 && index + 1 < path.length()) {
                toProcess = path.substring(index + 1);
            }
            extension = Lib.getExtension((String)toProcess);
        }
        return Strings.isValid(extension);
    }

    private String addExtension(String path, MediaType mediaType) {
        String extension = mediaType.getSubtype();
        if ("plain".equals(extension)) {
            extension = "txt";
        } else if (extension.contains("+")) {
            int index = extension.lastIndexOf("+");
            if (index > 0 && index + 1 < extension.length()) {
                extension = extension.substring(index + 1);
            }
        } else if (extension.contains(".")) {
            extension = Lib.getExtension((String)extension);
        }
        String toReturn = null;
        if (Strings.isValid((String)extension)) {
            StringBuilder builder = new StringBuilder(path);
            builder.append(".");
            builder.append(extension);
            toReturn = builder.toString();
        }
        return toReturn;
    }

    private List<MediaType> getMediaTypesToSearch(ContainerRequestContext requestContext) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        MediaType mediaType = requestContext.getMediaType();
        if (mediaType != null) {
            acceptableMediaTypes.add(mediaType);
        }
        acceptableMediaTypes.addAll(requestContext.getAcceptableMediaTypes());
        return acceptableMediaTypes;
    }

    public void accept(JaxRsResourceVisitor visitor) {
        for (Map.Entry<Bundle, Set<String>> entry : this.bundleToKey.entrySet()) {
            visitor.onResource(entry.getKey(), Collections.unmodifiableCollection((Collection)entry.getValue()));
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        this.processBundle(bundle, event.getType());
    }

    private String getWebResourceHeader(Bundle bundle) {
        return (String)bundle.getHeaders().get(OSEE_WEB_RESOURCE_HDR);
    }

    private boolean hasWebResourceHeader(Bundle bundle) {
        String headerValue = this.getWebResourceHeader(bundle);
        return Strings.isValid((String)headerValue);
    }

    private void processBundle(Bundle bundle, int state) {
        boolean isActive = false;
        boolean isStopping = false;
        if (state == 32 || state == 8 || state == 2 || state == 4) {
            isActive = true;
        } else if (state == 16) {
            isStopping = true;
        }
        if (isActive && this.hasWebResourceHeader(bundle)) {
            this.addBundle(bundle);
        } else if (isStopping && this.hasWebResourceHeader(bundle)) {
            this.removeBundle(bundle);
        }
    }

    private void removeBundle(Bundle bundle) {
        Set<String> paths = this.bundleToKey.get(bundle);
        if (paths != null && !paths.isEmpty()) {
            for (String path : paths) {
                this.pathToResource.remove(path);
            }
        }
    }

    private boolean isValidEntry(Bundle bundle, String headerValue, String resource, String pathAttribute) {
        boolean result = false;
        if (!Strings.isValid((String)pathAttribute)) {
            this.logger.warn("Invalid path attribute [%s] for resource [%s] in bundle [%s] with header[%s]", new Object[]{pathAttribute, resource, bundle.getSymbolicName(), headerValue});
        } else if (!Strings.isValid((String)resource)) {
            this.logger.warn("Invalid resource [%s] for bundle[%s] with header[%s].", new Object[]{resource, bundle.getSymbolicName(), headerValue});
        } else {
            result = true;
        }
        return result;
    }

    private void addBundle(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        String headerValue = this.getWebResourceHeader(bundle);
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)OSEE_WEB_RESOURCE_HDR, (String)headerValue);
        }
        catch (BundleException ex) {
            this.logger.error((Throwable)ex, "Error parsing manifest header [%s] for bundle [%s]", new Object[]{OSEE_WEB_RESOURCE_HDR, bundleName});
        }
        if (elements != null && elements.length > 0) {
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                String resource = element.getValue();
                String aliasAttribute = element.getAttribute(OSEE_WEB_RESOURCE_HDR__PATH_ATTRIBUTE);
                String secureAttribute = element.getAttribute(OSEE_WEB_RESOURCE_HDR__SECURE_ATTRIBUTE);
                boolean secure = false;
                if (Strings.isValid((String)secureAttribute)) {
                    secure = Boolean.parseBoolean(secureAttribute);
                }
                if (this.isValidEntry(bundle, headerValue, resource, aliasAttribute)) {
                    List<URL> resourceUrls = this.findUrls(bundle, headerValue, true, resource);
                    if (resourceUrls != null && !resourceUrls.isEmpty()) {
                        Set<String> paths = this.bundleToKey.get(bundle);
                        if (paths == null) {
                            paths = new HashSet<String>();
                            this.bundleToKey.put(bundle, paths);
                        }
                        for (URL url : resourceUrls) {
                            this.addResource(paths, bundle, resource, aliasAttribute, url, secure);
                        }
                    } else {
                        this.logger.warn("No resource urls found for resource path [%s] in bundle[%s] with header[%s].", new Object[]{resource, bundleName, headerValue});
                    }
                }
                ++n2;
            }
        }
    }

    private List<URL> findUrls(Bundle bundle, String headerValue, boolean recurse, String ... resources) {
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        String[] stringArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceName;
            String resource = stringArray[n2];
            int index = resource.lastIndexOf(47);
            String path = index != -1 ? resource.substring(0, index) : "/";
            Enumeration urls = bundle.findEntries(path, resourceName = index != -1 ? resource.substring(index + 1) : resource, recurse);
            if (urls != null && urls.hasMoreElements()) {
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    if (url.toString().endsWith("/")) continue;
                    resourceUrls.add(url);
                }
            } else {
                this.logger.error("Unable to find resource[%s] for bundle [%s]. The component header value is [%s]", new Object[]{resource, bundle.getSymbolicName(), headerValue});
            }
            ++n2;
        }
        return resourceUrls;
    }

    private void addResource(Set<String> paths, Bundle bundle, String resourceBase, String alias, URL url, boolean secure) {
        String urlPath;
        int index = resourceBase.lastIndexOf(47);
        String path = index != -1 ? resourceBase.substring(0, index) : "/";
        String resourceName = index != -1 ? resourceBase.substring(index + 1) : resourceBase;
        String toStrip = path;
        if (!resourceName.contains("*")) {
            toStrip = String.valueOf(toStrip) + "/" + resourceName;
        }
        if ((index = (urlPath = url.getPath()).indexOf(toStrip)) >= 0) {
            urlPath = urlPath.substring(index + toStrip.length());
        }
        urlPath = JaxRsUtils.normalize(urlPath);
        String pathToMatch = String.format("%s%s", alias, urlPath);
        pathToMatch = pathToMatch.replaceAll("//", "/");
        paths.add(pathToMatch);
        ResourceImpl resource = new ResourceImpl(bundle.getSymbolicName(), url, secure);
        Resource oldResource = this.pathToResource.put(pathToMatch, resource);
        if (oldResource != null && !oldResource.getUrl().equals(url)) {
            this.logger.error("Resource collision detected for path[%s] between 1:[%s] and 2:[%s]. resource-2 will be used.", new Object[]{pathToMatch, oldResource, resource});
        }
    }

    public static interface JaxRsResourceVisitor {
        public void onResource(Bundle var1, Collection<String> var2);
    }

    public static interface Resource {
        public URL getUrl();

        public boolean isSecure();
    }

    private static final class ResourceImpl
    implements Resource {
        private final String bundleName;
        private final URL url;
        private final boolean secure;

        public ResourceImpl(String bundleName, URL url, boolean secure) {
            this.bundleName = bundleName;
            this.url = url;
            this.secure = secure;
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public boolean isSecure() {
            return this.secure;
        }

        public String toString() {
            return "resource [bundleName=" + this.bundleName + ", url=" + this.url + "]";
        }
    }
}

