/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeJoin;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OrcsTypeTokenProvider;
import org.eclipse.osee.framework.core.data.RelationTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreTypeTokenProvider;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public final class OrcsTokenServiceImpl
implements OrcsTokenService {
    private final Map<String, Class<?>> tokenClasses = new ConcurrentHashMap();
    private final Map<Long, ArtifactTypeToken> artifactTypes = new ConcurrentHashMap<Long, ArtifactTypeToken>();
    private final Map<Long, AttributeTypeGeneric<?>> attributeTypes = new ConcurrentHashMap();
    private final Map<Long, RelationTypeToken> relationTypes = new ConcurrentHashMap<Long, RelationTypeToken>();
    private final Map<Long, ArtifactTypeJoin> artifactTypeJoins = new ConcurrentHashMap<Long, ArtifactTypeJoin>();
    private final Map<Long, AttributeTypeJoin> attributeTypeJoins = new ConcurrentHashMap<Long, AttributeTypeJoin>();
    private final Map<Long, RelationTypeJoin> relationTypeJoins = new ConcurrentHashMap<Long, RelationTypeJoin>();

    public OrcsTokenServiceImpl() {
        this.artifactTypes.put(ArtifactTypeToken.SENTINEL.getId(), ArtifactTypeToken.SENTINEL);
        this.attributeTypes.put(AttributeTypeToken.SENTINEL.getId(), AttributeTypeToken.SENTINEL);
        this.relationTypes.put(RelationTypeToken.SENTINEL.getId(), RelationTypeToken.SENTINEL);
        new CoreTypeTokenProvider().registerTypes(this);
    }

    public void addTypeTokenProvider(OrcsTypeTokenProvider typeProvider) {
        typeProvider.registerTypes(this);
    }

    @Override
    public BranchToken getBranch(BranchId branch) {
        return BranchToken.valueOf(branch);
    }

    @Override
    public ArtifactTypeToken getArtifactType(Long id) {
        ArtifactTypeToken artifactType = this.artifactTypes.get(id);
        if (artifactType == null) {
            throw new OseeTypeDoesNotExist("Artifact type [%s] is not available.", id);
        }
        return artifactType;
    }

    @Override
    public ArtifactTypeToken getArtifactType(String name) {
        for (ArtifactTypeToken artifactType : this.artifactTypes.values()) {
            if (!artifactType.getName().equals(name)) continue;
            return artifactType;
        }
        throw new OseeTypeDoesNotExist("Artifact type [%s] is not available.", name);
    }

    @Override
    public AttributeTypeGeneric<?> getAttributeType(Long id) {
        AttributeTypeGeneric<?> attributeType = this.attributeTypes.get(id);
        if (attributeType == null) {
            throw new OseeTypeDoesNotExist("Attribute type [%s] is not available.", id);
        }
        return attributeType;
    }

    @Override
    public AttributeTypeGeneric<?> getAttributeType(AttributeTypeId id) {
        return this.getAttributeType(id.getId());
    }

    @Override
    public AttributeTypeGeneric<?> getAttributeType(String name) {
        for (AttributeTypeGeneric<?> attributeType : this.attributeTypes.values()) {
            if (!attributeType.getName().equals(name)) continue;
            return attributeType;
        }
        throw new OseeTypeDoesNotExist("Attribute type [%s] is not available.", name);
    }

    @Override
    public RelationTypeToken getRelationType(Long id) {
        RelationTypeToken relationType = this.relationTypes.get(id);
        if (relationType == null) {
            throw new OseeTypeDoesNotExist("Relation type [%s] is not available.", id);
        }
        return relationType;
    }

    @Override
    public RelationTypeToken getRelationType(String name) {
        for (RelationTypeToken relationType : this.relationTypes.values()) {
            if (!relationType.getName().equals(name)) continue;
            return relationType;
        }
        throw new OseeTypeDoesNotExist("Relation type [%s] is not available.", name);
    }

    @Override
    public ArtifactTypeToken getArtifactTypeOrSentinel(Long id) {
        return this.getXTypeOrSentinel(this.artifactTypes, id, ArtifactTypeToken.SENTINEL);
    }

    @Override
    public AttributeTypeGeneric<?> getAttributeTypeOrSentinel(Long id) {
        return this.getXTypeOrSentinel(this.attributeTypes, id, AttributeTypeGeneric.SENTINEL);
    }

    @Override
    public RelationTypeToken getRelationTypeOrSentinel(Long id) {
        return this.getXTypeOrSentinel(this.relationTypes, id, RelationTypeToken.SENTINEL);
    }

    private <T extends NamedId> T getXTypeOrSentinel(Map<Long, T> types, Long id, T sentinel) {
        if (id == null) {
            return sentinel;
        }
        NamedId type = (NamedId)types.get(id);
        if (type == null) {
            return sentinel;
        }
        return (T)type;
    }

    @Override
    public ArtifactTypeToken getArtifactTypeOrCreate(Long id) {
        ArtifactTypeToken artifactType = this.getArtifactTypeOrSentinel(id);
        if (artifactType.isInvalid()) {
            artifactType = ArtifactTypeToken.valueOf(id, "Mising Artifact Type " + id, new ArtifactTypeToken[0]);
            this.registerArtifactType(artifactType);
        }
        return artifactType;
    }

    @Override
    public AttributeTypeGeneric<?> getAttributeTypeOrCreate(Long id) {
        AttributeTypeGeneric<?> attributeType = this.getAttributeTypeOrSentinel(id);
        if (attributeType.isInvalid()) {
            String missing = "Missing Attribute Type " + id;
            attributeType = AttributeTypeToken.valueOf(id, missing, missing);
            this.registerAttributeType(attributeType);
        }
        return attributeType;
    }

    @Override
    public RelationTypeToken getRelationTypeOrCreate(Long id) {
        RelationTypeToken relationType = this.getRelationTypeOrSentinel(id);
        if (relationType.isInvalid()) {
            relationType = RelationTypeToken.create(id, "Mising Artifact Type " + id, null, null, null, null, null, null);
            this.registerRelationType(relationType);
        }
        return relationType;
    }

    @Override
    public void registerTokenClasses(Class<?>[] tokenClasses) {
        Class<?>[] classArray = tokenClasses;
        int n = tokenClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> tokenClass = classArray[n2];
            this.tokenClasses.put(tokenClass.getCanonicalName(), tokenClass);
            ++n2;
        }
    }

    @Override
    public Class<?> getTokenClass(String canonicalClassName) {
        return this.tokenClasses.get(canonicalClassName);
    }

    @Override
    public void registerArtifactType(ArtifactTypeToken artifactType) {
        ArtifactTypeToken existingType = this.artifactTypes.putIfAbsent(artifactType.getId(), artifactType);
        if (existingType != null) {
            throw new OseeArgumentException("An artifact type %s with the same id as %s has already been registered.", new Object[]{existingType, artifactType});
        }
    }

    @Override
    public void registerAttributeType(AttributeTypeGeneric<?> attributeType) {
        AttributeTypeGeneric<?> existingType = this.attributeTypes.get(attributeType.getId());
        if (existingType == null) {
            this.attributeTypes.put(attributeType.getId(), attributeType);
        } else if (existingType instanceof AttributeTypeEnum && attributeType instanceof AttributeTypeEnum && existingType.getId().equals(attributeType.getId())) {
            existingType.toEnum().appendEnumValues(attributeType.toEnum());
        } else {
            throw new OseeArgumentException("Cannot register the attribute type %s with ID %s. Existing attribute type %s with ID %s already exists", new Object[]{attributeType, attributeType.getId(), existingType, existingType.getId()});
        }
    }

    @Override
    public void registerRelationType(RelationTypeToken relationType) {
        RelationTypeToken existingType = this.relationTypes.putIfAbsent(relationType.getId(), relationType);
        if (existingType != null) {
            throw new OseeArgumentException("The relation type %s with the same id as %s has already been registered.", new Object[]{existingType, relationType});
        }
    }

    @Override
    public void registerArtifactTypeJoin(ArtifactTypeJoin typeJoin) {
        this.registerOrcsTypeJoin(typeJoin, this.artifactTypeJoins);
    }

    @Override
    public void registerAttributeTypeJoin(AttributeTypeJoin typeJoin) {
        this.registerOrcsTypeJoin(typeJoin, this.attributeTypeJoins);
    }

    @Override
    public void registerRelationTypeJoin(RelationTypeJoin typeJoin) {
        this.registerOrcsTypeJoin(typeJoin, this.relationTypeJoins);
    }

    @Override
    public ArtifactTypeJoin getArtifactTypeJoin(Long id) {
        ArtifactTypeJoin typeJoin = this.artifactTypeJoins.get(id);
        if (typeJoin == null) {
            throw new OseeTypeDoesNotExist("Artifact type join [%s] is not available.", id);
        }
        return typeJoin;
    }

    @Override
    public AttributeTypeJoin getAttributeTypeJoin(Long id) {
        AttributeTypeJoin typeJoin = this.attributeTypeJoins.get(id);
        if (typeJoin == null) {
            throw new OseeTypeDoesNotExist("Attribute type join [%s] is not available.", id);
        }
        return typeJoin;
    }

    @Override
    public RelationTypeJoin getRelationTypeJoin(Long id) {
        RelationTypeJoin typeJoin = this.relationTypeJoins.get(id);
        if (typeJoin == null) {
            throw new OseeTypeDoesNotExist("Relation type join [%s] is not available.", id);
        }
        return typeJoin;
    }

    @Override
    public Collection<ArtifactTypeJoin> getArtifactTypeJoins() {
        return this.artifactTypeJoins.values();
    }

    @Override
    public Collection<AttributeTypeJoin> getAttributeTypeJoins() {
        return this.attributeTypeJoins.values();
    }

    @Override
    public Collection<RelationTypeJoin> getRelationTypeJoins() {
        return this.relationTypeJoins.values();
    }

    private <T extends NamedId> void registerOrcsTypeJoin(T orcsTypeJoin, Map<Long, T> orcsTypeJoins) {
        NamedId existingType = (NamedId)orcsTypeJoins.putIfAbsent(orcsTypeJoin.getId(), orcsTypeJoin);
        if (existingType != null) {
            throw new OseeArgumentException("The join type %s with the same id as %s has already been registered.", new Object[]{existingType, orcsTypeJoin});
        }
    }

    @Override
    public Iterable<AttributeTypeGeneric<?>> getTaggedAttrs() {
        HashSet attrTypeIds = new HashSet();
        for (Map.Entry<Long, AttributeTypeGeneric<?>> entry : this.attributeTypes.entrySet()) {
            AttributeTypeGeneric<?> attrType = entry.getValue();
            if (!attrType.isTaggable()) continue;
            attrTypeIds.add(attrType);
        }
        return attrTypeIds;
    }

    @Override
    public Collection<ArtifactTypeToken> getArtifactTypes() {
        return Collections.unmodifiableCollection(this.artifactTypes.values());
    }

    @Override
    public Collection<RelationTypeToken> getRelationTypes() {
        return Collections.unmodifiableCollection(this.relationTypes.values());
    }

    @Override
    public Collection<AttributeTypeGeneric<?>> getAttributeTypes() {
        return Collections.unmodifiableCollection(this.attributeTypes.values());
    }

    @Override
    public List<ArtifactTypeToken> getConcreteArtifactTypes() {
        ArrayList<ArtifactTypeToken> concreteArtifactTypes = new ArrayList<ArtifactTypeToken>();
        for (ArtifactTypeToken artifactType : this.getArtifactTypes()) {
            if (artifactType.isAbstract()) continue;
            concreteArtifactTypes.add(artifactType);
        }
        return concreteArtifactTypes;
    }

    @Override
    public Set<ArtifactTypeToken> getValidArtifactTypes(AttributeTypeToken attributeType) {
        HashSet<ArtifactTypeToken> artifactTypes = new HashSet<ArtifactTypeToken>();
        for (ArtifactTypeToken artifactType : this.getArtifactTypes()) {
            if (!artifactType.isValidAttributeType(attributeType)) continue;
            artifactTypes.add(artifactType);
        }
        return artifactTypes;
    }

    @Override
    public List<RelationTypeToken> getValidRelationTypes(ArtifactTypeToken artifactType) {
        Collection<RelationTypeToken> relationTypes = this.getRelationTypes();
        ArrayList<RelationTypeToken> validRelationTypes = new ArrayList<RelationTypeToken>();
        for (RelationTypeToken relationType : relationTypes) {
            boolean onSideB;
            boolean onSideA = relationType.getRelationSideMax(artifactType, RelationSide.SIDE_A) > 0;
            boolean bl = onSideB = relationType.getRelationSideMax(artifactType, RelationSide.SIDE_B) > 0;
            if (!onSideA && !onSideB) continue;
            validRelationTypes.add(relationType);
        }
        return validRelationTypes;
    }

    @Override
    public boolean attributeTypeExists(String name) {
        for (AttributeTypeGeneric<?> attributeType : this.attributeTypes.values()) {
            if (!attributeType.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<AttributeTypeToken> getSingletonAttributeTypes() {
        HashSet<AttributeTypeToken> attributeTypeTokens = new HashSet<AttributeTypeToken>();
        for (ArtifactTypeToken artifactType : this.getArtifactTypes()) {
            artifactType.getSingletonAttributeTypes(attributeTypeTokens);
        }
        return attributeTypeTokens;
    }
}

