/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder;

import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.operations.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.ReqIFSynchronizationArtifactBuilder;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.util.EnumSupplierMap;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.SpecType;

public class SpecTypeConverter {
    private static EnumSupplierMap<IdentifierType, SpecType> specTypeSupplierMap;
    private static Map<IdentifierType, String> descriptionMap;

    static {
        Map.Entry[] entryArray = new Map.Entry[3];
        entryArray[0] = Map.entry(IdentifierType.SPECIFICATION_TYPE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecificationType());
        entryArray[1] = Map.entry(IdentifierType.SPEC_OBJECT_TYPE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecObjectType());
        entryArray[2] = Map.entry(IdentifierType.SPEC_RELATION_TYPE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecRelationType());
        specTypeSupplierMap = EnumSupplierMap.ofEntries(IdentifierType.class, (Map.Entry[])entryArray);
        descriptionMap = Map.ofEntries(Map.entry(IdentifierType.SPECIFICATION_TYPE, " Specification Type"), Map.entry(IdentifierType.SPEC_OBJECT_TYPE, " Spec Object Type"), Map.entry(IdentifierType.SPEC_RELATION_TYPE, " Spec Relation Type"));
    }

    private SpecTypeConverter() {
    }

    static void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isInGroup(IdentifierTypeGroup.TYPE)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierTypeGroup.TYPE);
        ArtifactTypeToken nativeArtifactTypeToken = (ArtifactTypeToken)groveThing.getNativeThing();
        SpecType reqifSpecificationType = (SpecType)specTypeSupplierMap.get((Enum)groveThing.getIdentifier().getType());
        String description = new StringBuilder(512).append("OSEE ").append(nativeArtifactTypeToken.getName()).append(descriptionMap.get(groveThing.getIdentifier().getType())).toString();
        reqifSpecificationType.setDesc(description);
        reqifSpecificationType.setIdentifier(groveThing.getIdentifier().toString());
        reqifSpecificationType.setLastChange(ReqIFSynchronizationArtifactBuilder.lastChangeEpoch);
        reqifSpecificationType.setLongName(nativeArtifactTypeToken.getName());
        groveThing.setForeignThing(reqifSpecificationType);
    }
}

