/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdombuilder;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.ForeignThingFamily;
import org.eclipse.osee.define.operations.synchronization.RelationshipTerminal;
import org.eclipse.osee.define.operations.synchronization.SynchronizationArtifact;
import org.eclipse.osee.define.operations.synchronization.SynchronizationArtifactBuilder;
import org.eclipse.osee.define.operations.synchronization.forest.Forest;
import org.eclipse.osee.define.operations.synchronization.forest.Grove;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.StreamEntry;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeDefinition;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeValue;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Document;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentObject;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Factory;
import org.eclipse.osee.define.operations.synchronization.publishingdombuilder.AttributeDefinitionConverter;
import org.eclipse.osee.define.operations.synchronization.publishingdombuilder.AttributeValueConverter;
import org.eclipse.osee.define.operations.synchronization.publishingdombuilder.NullConverter;
import org.eclipse.osee.define.operations.synchronization.publishingdombuilder.SpecElementWithAttributesConverter;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.DoubleHashMap;
import org.eclipse.osee.framework.jdk.core.util.DoubleMap;
import org.eclipse.osee.framework.jdk.core.util.EnumConsumerMap;

public class PublishingDomBuilder
implements SynchronizationArtifactBuilder {
    private EnumConsumerMap<IdentifierType, GroveThing> converterMap;
    private DocumentMap documentMap;
    private Function<DocumentMap, InputStream> serializer;
    private SynchronizationArtifact synchronizationArtifact;

    public PublishingDomBuilder(Function<DocumentMap, InputStream> serializer) {
        this.serializer = Objects.requireNonNull(serializer, "PublishingDomBuilder::new, parameter \"serializer\" cannot be null.");
        this.documentMap = null;
        this.converterMap = null;
        this.synchronizationArtifact = null;
    }

    @Override
    public boolean build() {
        Forest forest = this.synchronizationArtifact.getForest();
        Grove specObjectGrove = forest.getGrove(IdentifierType.SPEC_OBJECT);
        forest.streamGroves(StreamEntry.create(IdentifierType.SPECIFICATION)).map(GroveThing::getForeignThing).filter(Optional::isPresent).map(optionalDocument -> (Document)optionalDocument.get()).forEach(document -> this.documentMap.appendDocumentToDocumentMap(this.documentMap.getIdentifier(), (Document)document));
        forest.streamGroves(StreamEntry.create(IdentifierType.SPECIFICATION)).map(GroveThing::getIdentifier).flatMap(identifier -> specObjectGrove.streamIdentifiersDeep((Identifier)identifier)).filter(identifier -> identifier.getType().equals(IdentifierType.SPEC_OBJECT)).map(specObjectGrove::getByUniquePrimaryKey).filter(Optional::isPresent).map(Optional::get).forEach(specObjectGroveThing -> {
            GroveThing parentGroveThing = specObjectGroveThing.getParent(-1).get();
            Identifier parentGroveThingIdentifier = parentGroveThing.getIdentifier();
            specObjectGroveThing.getForeignThing().ifPresent(foreignThing -> {
                DocumentObject documentObject = (DocumentObject)foreignThing;
                if (parentGroveThingIdentifier.isType(IdentifierType.SPECIFICATION)) {
                    this.documentMap.appendDocumentObjectToDocument(parentGroveThingIdentifier, documentObject);
                } else {
                    this.documentMap.appendDocumentObjectToDocumentObject(parentGroveThingIdentifier, documentObject);
                }
            });
        });
        DoubleHashMap attributeDefinitionByParentIdentifierAndNativeIdentifierMap = new DoubleHashMap();
        forest.streamGroves(IdentifierType.ATTRIBUTE_DEFINITION).forEach(arg_0 -> PublishingDomBuilder.lambda$12((DoubleMap)attributeDefinitionByParentIdentifierAndNativeIdentifierMap, arg_0));
        forest.streamGroves(StreamEntry.create(IdentifierType.ATTRIBUTE_VALUE)).filter(attributeValueGroveThing -> attributeValueGroveThing.getParent(-1).get().getIdentifier().isType(IdentifierType.SPEC_OBJECT)).forEach(arg_0 -> this.lambda$14((DoubleMap)attributeDefinitionByParentIdentifierAndNativeIdentifierMap, arg_0));
        this.documentMap.setHierarchyLevels();
        return true;
    }

    @Override
    public void close() {
        this.converterMap = null;
        this.documentMap = null;
        this.serializer = null;
        this.synchronizationArtifact = null;
    }

    @Override
    public void deserialize(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<String> getAttributeDefinition(GroveThing attributeValueGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<String> getAttributeDefinitions(GroveThing specificationTypeGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Consumer<GroveThing>> getConverter(IdentifierType identifierType) {
        return this.converterMap.getFunction((Enum)identifierType);
    }

    @Override
    public Optional<String> getDatatypeDefinition(GroveThing attributeDefinitionGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<String> getEnumValues(GroveThing datatypeDefinitionGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<ForeignThingFamily> getForeignThings(IdentifierType identifierType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<String> getSpecificationType(GroveThing specificationGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<ForeignThingFamily> getSpecObject(GroveThing specRelationGroveThing, RelationshipTerminal relationshipTerminal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<String> getSpecObjectType(GroveThing specObjectGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<String> getSpecRelationType(GroveThing specRelationGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(SynchronizationArtifact synchronizationArtifact) {
        this.synchronizationArtifact = Objects.requireNonNull(synchronizationArtifact, "PublishingDomBuilder::initialize, the parameter \"synchronizationArtifact\" cannot be null.");
        Forest forest = synchronizationArtifact.getForest();
        Identifier documentMapIdentifier = forest.getIdentifier();
        this.documentMap = Factory.createDocumentMap(documentMapIdentifier);
        AttributeDefinitionConverter attributeDefinitionConverter = new AttributeDefinitionConverter(this.documentMap);
        AttributeValueConverter attributeValueConverter = new AttributeValueConverter(this.documentMap);
        SpecElementWithAttributesConverter specElementWithAttributesConverter = new SpecElementWithAttributesConverter(this.documentMap);
        this.converterMap = new EnumConsumerMap(IdentifierType.class);
        this.converterMap.put((Enum)IdentifierType.ATTRIBUTE_DEFINITION, attributeDefinitionConverter::convert);
        this.converterMap.put((Enum)IdentifierType.ATTRIBUTE_VALUE, attributeValueConverter::convert);
        this.converterMap.put((Enum)IdentifierType.DATA_TYPE_DEFINITION, NullConverter::convert);
        this.converterMap.put((Enum)IdentifierType.ENUM_VALUE, NullConverter::convert);
        this.converterMap.put((Enum)IdentifierType.HEADER, NullConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPECIFICATION, specElementWithAttributesConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPECIFICATION_TYPE, NullConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPECTER_SPEC_OBJECT, specElementWithAttributesConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPEC_OBJECT, specElementWithAttributesConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPEC_OBJECT_TYPE, NullConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPEC_RELATION_TYPE, NullConverter::convert);
        this.converterMap.put((Enum)IdentifierType.SPEC_RELATION, specElementWithAttributesConverter::convert);
    }

    @Override
    public boolean isEnumerated(GroveThing attributeValueGroveThing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream serialize() {
        return this.serializer.apply(this.documentMap);
    }

    private static /* synthetic */ void lambda$12(DoubleMap doubleMap, GroveThing attributeDefinitionGroveThing) {
        GroveThing parentGroveThing = attributeDefinitionGroveThing.getParent(-1).get();
        Identifier parentGroveThingIdentifier = parentGroveThing.getIdentifier();
        AttributeTypeGeneric nativeAttributeTypeGeneric = (AttributeTypeGeneric)attributeDefinitionGroveThing.getNativeThing();
        Long nativeIdentifier = nativeAttributeTypeGeneric.getId();
        doubleMap.put((Object)parentGroveThingIdentifier, (Object)nativeIdentifier, (Object)attributeDefinitionGroveThing);
    }

    private /* synthetic */ void lambda$14(DoubleMap doubleMap, GroveThing attributeValueGroveThing) {
        AttributeValue attributeValue = (AttributeValue)attributeValueGroveThing.getForeignThing().get();
        GroveThing commonObjectGroveThing = attributeValueGroveThing.getParent(-1).get();
        Identifier parentIdentifier = commonObjectGroveThing.getIdentifier();
        GroveThing attributeDefinitionGroveThing = attributeValueGroveThing.getLinkScalar(IdentifierType.ATTRIBUTE_DEFINITION).get();
        AttributeTypeGeneric nativeAttributeDefinition = (AttributeTypeGeneric)attributeDefinitionGroveThing.getNativeThing();
        AttributeDefinition attributeDefinition = (AttributeDefinition)attributeDefinitionGroveThing.getForeignThing().get();
        if (CoreAttributeTypes.PrimaryAttribute.getId().equals(nativeAttributeDefinition.getId())) {
            long nativePrimaryAttributeTypeIdentifier = Long.parseLong(attributeValue.getValue(), 10);
            GroveThing attributeDefinitionGroveThingParent = attributeDefinitionGroveThing.getParent(-1).get();
            Identifier attributeDefinitionGroveThingParentIdentifier = attributeDefinitionGroveThingParent.getIdentifier();
            GroveThing referencedAttributeDefinition = (GroveThing)doubleMap.get((Object)attributeDefinitionGroveThingParentIdentifier, (Object)nativePrimaryAttributeTypeIdentifier).get();
            Identifier referencedAttributeDefinitionIdentifier = referencedAttributeDefinition.getIdentifier();
            attributeValue.setValue(referencedAttributeDefinitionIdentifier.toString());
        }
        this.documentMap.appendAttributeDefinition(parentIdentifier, attributeDefinition);
        this.documentMap.appendAttributeValue(parentIdentifier, attributeDefinition.getIdentifier(), attributeValue);
    }
}

