/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdombuilder;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osee.define.operations.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataType;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeValueImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.EnumFunctionMap;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class AttributeValueConverter {
    private static final EnumFunctionMap<NativeDataType, Object, String> attributeValueConverterMap = EnumFunctionMap.ofEntries(NativeDataType.class, (Map.Entry[])new Map.Entry[]{Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, value -> ((Id)value).getIdString()), Map.entry(NativeDataType.BRANCH_IDENTIFIER, value -> ((Id)value).getIdString()), Map.entry(NativeDataType.BOOLEAN, value -> ((Boolean)value).toString()), Map.entry(NativeDataType.DATE, value -> ((Date)value).toString()), Map.entry(NativeDataType.DOUBLE, value -> ((Double)value).toString()), Map.entry(NativeDataType.ENUMERATED, value -> {
        List enumValueGroveThingList = (List)value;
        String attributeValue = enumValueGroveThingList.stream().map(GroveThing::getForeignThing).filter(Optional::isPresent).map(optionalEnumValue -> (String)optionalEnumValue.get()).collect(Collectors.joining(","));
        return attributeValue;
    }), Map.entry(NativeDataType.INTEGER, value -> ((Integer)value).toString()), Map.entry(NativeDataType.LONG, value -> ((Long)value).toString()), Map.entry(NativeDataType.STRING, value -> (String)value), Map.entry(NativeDataType.STRING_WORD_ML, value -> (String)value), Map.entry(NativeDataType.URI, value -> (String)value)});
    private final DocumentMap documentMap;

    public AttributeValueConverter(DocumentMap documentMap) {
        this.documentMap = documentMap;
    }

    void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isType(IdentifierType.ATTRIBUTE_VALUE)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierType.ATTRIBUTE_VALUE);
        try {
            Object nativeAttributeValue = groveThing.getNativeThing();
            GroveThing attributeDefinitionGroveThing = groveThing.getLinkScalar(IdentifierType.ATTRIBUTE_DEFINITION).get();
            GroveThing datatypeDefinitionGroveThing = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
            NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinitionGroveThing.getNativeThing()).getNativeDataType();
            Identifier identifier = groveThing.getIdentifier();
            String valueString = attributeValueConverterMap.containsKey((Enum)nativeDataType) ? (String)attributeValueConverterMap.apply((Enum)nativeDataType, nativeAttributeValue) : nativeDataType.toString();
            AttributeValueImpl attributeValue = this.documentMap.createAttributeValue(identifier, valueString);
            groveThing.setForeignThing(attributeValue);
        }
        catch (Exception e) {
            Message message = new Message();
            message.blank().title((CharSequence)"Failed to convert attribute value.").indentInc().segment((CharSequence)"Identifier", (Object)groveThing.getIdentifier()).toMessage((ToMessage)groveThing);
            throw new RuntimeException(message.toString(), e);
        }
    }
}

