/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest.morphology;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.Store;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.StoreType;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;
import org.eclipse.osee.framework.jdk.core.util.RankHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;

class StoreRankN
implements Store {
    private final RankMap<GroveThing> primaryMap;
    private final StoreType storeType;
    private final Map<Object, GroveThing> uniquePrimaryKeyMap;
    private final Predicate<Object> uniqueKeyValidator;

    public StoreRankN(StoreType storeType, int rank, Predicate<Object>[] keyValidators) {
        assert (Objects.nonNull((Object)storeType) && (storeType.equals((Object)StoreType.NATIVE) || storeType.equals((Object)StoreType.PRIMARY)) && rank >= 1 && ParameterArray.validateNonNullAndSize((Object[])keyValidators, (int)rank, (int)rank));
        this.storeType = Objects.requireNonNull(storeType);
        this.primaryMap = new RankHashMap(null, rank, 1024, 0.75f, (Predicate[])keyValidators);
        if (StoreType.PRIMARY.equals((Object)storeType) && rank > 1) {
            this.uniquePrimaryKeyMap = new HashMap<Object, GroveThing>(1024, 0.75f);
            this.uniqueKeyValidator = keyValidators[rank - 1];
        } else {
            this.uniquePrimaryKeyMap = null;
            this.uniqueKeyValidator = null;
        }
    }

    @Override
    public void add(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing));
        this.storeType.getKeys(groveThing).ifPresent(keys -> {
            this.primaryMap.associate((Object)groveThing, keys);
            if (Objects.nonNull(this.uniquePrimaryKeyMap)) {
                this.uniquePrimaryKeyMap.put(keys[((Object[])keys).length - 1], groveThing);
            }
        });
    }

    @Override
    public boolean contains(Object ... keys) {
        return this.primaryMap.containsKeys(keys);
    }

    @Override
    public Optional<GroveThing> get(Object ... keys) {
        return this.primaryMap.get(keys);
    }

    @Override
    public Optional<GroveThing> getByUniqueKey(Object uniqueKey) {
        if (Objects.isNull(this.uniquePrimaryKeyMap)) {
            return this.primaryMap.get(new Object[]{uniqueKey});
        }
        assert (Objects.nonNull(uniqueKey) && (Objects.isNull(this.uniqueKeyValidator) || this.uniqueKeyValidator.test(uniqueKey))) : "StoreRankN::getByUniqueKey, key failed validation.";
        return Optional.ofNullable(this.uniquePrimaryKeyMap.get(uniqueKey));
    }

    @Override
    public StoreType getType() {
        return this.storeType;
    }

    @Override
    public int rank() {
        return this.primaryMap.rank();
    }

    @Override
    public int size() {
        return this.primaryMap.size();
    }

    @Override
    public Stream<GroveThing> stream(Object ... keys) {
        return this.primaryMap.stream(keys);
    }

    @Override
    public Stream<Object> streamKeysAtAndBelow(Object ... keys) {
        return this.primaryMap.streamKeysAtAndBelow(keys);
    }

    @Override
    public Stream<Object> streamKeysAt(Object ... keys) {
        return this.primaryMap.streamKeysAt(keys);
    }

    @Override
    public Stream<Object[]> streamKeySets(Object ... keys) {
        return this.primaryMap.stream(keys).map(value -> this.storeType == StoreType.PRIMARY ? value.getPrimaryKeys() : value.getNativeKeys()).filter(Optional::isPresent).map(Optional::get);
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.indent(indent).title((CharSequence)this.getClass().getSimpleName()).indentInc().segment((CharSequence)"Rank", (Object)this.rank()).segment((CharSequence)"Store Type", (Object)this.storeType).segment((CharSequence)"Current Size", (Object)this.size()).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

