/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.datarights;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.api.publishing.datarights.DataRightsOperations;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightAnchors;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightClassificationMap;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightEntry;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightEntryList;
import org.eclipse.osee.define.util.Validation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.publishing.DataRight;
import org.eclipse.osee.framework.core.publishing.DataRightAnchor;
import org.eclipse.osee.framework.core.publishing.DataRightResult;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class DataRightsOperationsImpl
implements DataRightsOperations {
    private static DataRightsOperationsImpl dataRightsOperationsImpl = null;
    private DataRightClassificationMap dataRightClassificationMap;
    private final QueryFactory queryFactory;

    public static synchronized DataRightsOperationsImpl create(OrcsApi orcsApi) {
        return Objects.isNull(dataRightsOperationsImpl) ? (dataRightsOperationsImpl = new DataRightsOperationsImpl(Objects.requireNonNull(Objects.requireNonNull(orcsApi).getQueryFactory()))) : dataRightsOperationsImpl;
    }

    private DataRightsOperationsImpl(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
        this.dataRightClassificationMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCache() {
        DataRightsOperationsImpl dataRightsOperationsImpl = DataRightsOperationsImpl.dataRightsOperationsImpl;
        synchronized (dataRightsOperationsImpl) {
            this.dataRightClassificationMap = null;
        }
    }

    private DataRightResult findSequences(DataRightEntryList dataRightEntryList) {
        DataRightClassificationMap dataRightClassificationMap = this.getDataRightsClassificationMap();
        DataRightAnchors dataRightAnchors = new DataRightAnchors();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataRightAnchors dataRightAnchorsAutoClose = dataRightAnchors;){
            DataRightEntry previousArtifact = null;
            DataRightAnchor previousDataRightAnchor = null;
            DataRightAnchor currentDataRightAnchor = null;
            for (DataRightEntry currentArtifact : dataRightEntryList) {
                DataRight dataRight = dataRightClassificationMap.get(currentArtifact.getClassification());
                boolean newFooter = this.isNewFooter(currentArtifact, previousArtifact);
                currentDataRightAnchor = dataRightAnchors.add(currentArtifact.getId(), dataRight, newFooter);
                if (Objects.nonNull(previousArtifact) && Objects.nonNull(previousDataRightAnchor)) {
                    boolean isContinuousForPrevious = this.isContinuousForPrevious(currentArtifact, previousArtifact);
                    previousDataRightAnchor.setIsContinuous(Boolean.valueOf(isContinuousForPrevious));
                }
                previousArtifact = currentArtifact;
                previousDataRightAnchor = currentDataRightAnchor;
            }
            if (Objects.nonNull(currentDataRightAnchor)) {
                currentDataRightAnchor.setIsContinuous(Boolean.valueOf(false));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        DataRightResult dataRightAnchorsResult = new DataRightResult(dataRightAnchors.stream());
        return dataRightAnchorsResult;
    }

    public DataRightResult getDataRights(BranchId branchIdentifier, List<ArtifactId> artifactIdentifiers) {
        return this.getDataRights(branchIdentifier, "", artifactIdentifiers);
    }

    public DataRightResult getDataRights(BranchId branchIdentifier, String overrideClassification, List<ArtifactId> artifactIdentifiers) {
        Message message = null;
        message = Validation.verifyStreamableParameter(artifactIdentifiers, Collection::stream, "artifactIdentifiers", message, "empty", List::isEmpty, "null, sentinel, or < 0", artifact -> Objects.isNull(artifact) || ArtifactId.SENTINEL.equals(artifact) || artifact.getId() < 0L);
        message = Validation.verifyParameter(branchIdentifier, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        if (Objects.nonNull(message = Validation.verifyParameter(overrideClassification, "overrideClassification", message))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "getDataRights", message));
        }
        Map<ArtifactId, ArtifactReadable> artifactMap = this.loadArtifactMap(branchIdentifier, artifactIdentifiers);
        DataRightEntryList dataRightEntryList = this.populateRequest(artifactIdentifiers, artifactMap, overrideClassification);
        DataRightResult dataRightAnchorsResult = this.findSequences(dataRightEntryList);
        return dataRightAnchorsResult;
    }

    public DataRightResult getDataRights(List<ArtifactId> artifactIdentifiers, Map<ArtifactId, ArtifactReadable> artifactMap, String overrideClassification) {
        Message message = null;
        message = Validation.verifyParameter(artifactIdentifiers, "artifacts", message);
        message = Validation.verifyParameter(overrideClassification, "overrideClassification", message);
        for (ArtifactId artifactIdentifier : artifactIdentifiers) {
            message = Validation.verifyParameter(artifactIdentifier, "artifactIdentifier", message, "artifactIdentifier on list is invalid", p -> Objects.isNull(p) || ArtifactId.SENTINEL.equals(p) || p.getId() < 0L);
        }
        if (Objects.nonNull(message)) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "getDataRights", message));
        }
        DataRightEntryList dataRightEntryList = this.populateRequest(artifactIdentifiers, artifactMap, overrideClassification);
        DataRightResult dataRightAnchorsResult = this.findSequences(dataRightEntryList);
        return dataRightAnchorsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRightClassificationMap getDataRightsClassificationMap() {
        DataRightClassificationMap dataRightClassificationMap;
        DataRightsOperationsImpl dataRightsOperationsImpl = DataRightsOperationsImpl.dataRightsOperationsImpl;
        synchronized (dataRightsOperationsImpl) {
            if (Objects.isNull(this.dataRightClassificationMap)) {
                this.dataRightClassificationMap = DataRightClassificationMap.create(this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON));
            }
            dataRightClassificationMap = this.dataRightClassificationMap;
        }
        return dataRightClassificationMap;
    }

    private boolean isContinuousForPrevious(DataRightEntry current, DataRightEntry previous) {
        return current.getClassification().equals(previous.getClassification()) && current.getOrientation().equals((Object)previous.getOrientation());
    }

    private boolean isNewFooter(DataRightEntry current, DataRightEntry previous) {
        return Objects.isNull(previous) || !current.getClassification().equals(previous.getClassification());
    }

    private Map<ArtifactId, ArtifactReadable> loadArtifactMap(BranchId branchIdentifier, List<ArtifactId> artifactIdentifiers) {
        try {
            return this.queryFactory.fromBranch(branchIdentifier).andIds(artifactIdentifiers).asArtifactMap();
        }
        catch (Exception e) {
            throw new OseeCoreException("DataRightsOperationsImpl::loadArtifactMap, failed to obtain artifacts from the database.", (Throwable)e);
        }
    }

    private DataRightEntryList populateRequest(List<ArtifactId> artifactIdentifiers, Map<ArtifactId, ArtifactReadable> artifactMap, String overrideClassification) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataRightEntryList dataRightEntryList = new DataRightEntryList(overrideClassification);){
            for (ArtifactId artifactId : artifactIdentifiers) {
                ArtifactReadable artifactReadable = artifactMap.getOrDefault(artifactId, ArtifactReadable.SENTINEL);
                dataRightEntryList.add(artifactId, artifactReadable);
            }
            return dataRightEntryList;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

