/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.ArtifactUrlServer;
import org.eclipse.osee.define.api.AttributeAlphabeticalComparator;
import org.eclipse.osee.define.api.OseeHierarchyComparator;
import org.eclipse.osee.define.api.publishing.datarights.DataRightsOperations;
import org.eclipse.osee.define.operations.publishing.ChangedArtifactsTracker;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.operations.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightsOperationsImpl;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.DataRightContentBuilder;
import org.eclipse.osee.framework.core.publishing.EnumRendererMap;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.OutliningOptions;
import org.eclipse.osee.framework.core.publishing.ProcessedArtifactTracker;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordMLProducer;
import org.eclipse.osee.framework.core.publishing.WordRenderUtil;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.core.server.publishing.WordRenderArtifactWrapperServerImpl;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class WordTemplateProcessorServer {
    protected static final String APPLICABILITY = "Applicability";
    protected static final String ARTIFACT = "Artifact";
    protected static final Object ARTIFACT_ID = "Artifact Id";
    protected static final String ARTIFACT_TYPE = "Artifact Type";
    protected static final String FONT = "Times New Roman";
    protected final ActivityLog activityLog;
    protected final Map<ApplicabilityId, Boolean> applicabilityMap = new HashMap<ApplicabilityId, Boolean>();
    protected Map<ApplicabilityId, ApplicabilityToken> applicabilityTokens;
    protected final Map<ArtifactReadable, CharSequence> artParagraphNumbers = new HashMap<ArtifactReadable, CharSequence>();
    protected final AtsApi atsApi;
    protected BranchId branchId;
    protected DataRightsOperations dataRightsOperations;
    private String elementType;
    protected final Set<ArtifactId> emptyFolders = new HashSet<ArtifactId>();
    protected final List<ArtifactTypeToken> excludeArtifactTypes = new LinkedList<ArtifactTypeToken>();
    private Boolean excludeFolders;
    protected final Set<ArtifactReadable> headerArtifacts = new HashSet<ArtifactReadable>();
    protected final Set<String> headerGuids = new HashSet<String>();
    protected AttributeTypeToken headingAttributeType;
    protected final OseeHierarchyComparator hierarchyComparator;
    protected HashMap<String, ArtifactReadable> hyperlinkedIds = new HashMap();
    protected final Log logger;
    private Integer maximumOutlineDepth;
    protected final OrcsApi orcsApi;
    protected final Map<ArtifactTypeToken, List<ArtifactReadable>> oseeLinkedArtifactMap = new HashMap<ArtifactTypeToken, List<ArtifactReadable>>();
    protected String outlineNumber;
    protected String overrideClassification;
    protected final String permanentLinkUrl;
    protected ProcessedArtifactTracker processedArtifactTracker;
    protected final PublishingErrorLog publishingErrorLog;
    protected PublishingTemplate publishingTemplate;
    protected final PublishingUtils publishingUtils;
    protected EnumRendererMap renderer;
    protected final OrcsTokenService tokenService;
    protected ArtifactId viewId;
    protected ChangedArtifactsTracker changedArtifactsTracker;

    public WordTemplateProcessorServer(OrcsApi orcsApi, AtsApi atsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.publishingErrorLog = new PublishingErrorLog();
        this.publishingUtils = new PublishingUtils(this.orcsApi);
        this.activityLog = orcsApi.getActivityLog();
        this.branchId = null;
        this.changedArtifactsTracker = new ChangedArtifactsTracker(this.atsApi, this.publishingUtils, this.publishingErrorLog);
        this.dataRightsOperations = DataRightsOperationsImpl.create(this.orcsApi);
        this.elementType = null;
        this.excludeFolders = null;
        this.headingAttributeType = null;
        this.hierarchyComparator = new OseeHierarchyComparator(this.activityLog);
        this.logger = atsApi.getLogger();
        this.maximumOutlineDepth = null;
        this.outlineNumber = null;
        this.overrideClassification = null;
        this.permanentLinkUrl = new ArtifactUrlServer(this.orcsApi).getSelectedPermanentLinkUrl();
        this.processedArtifactTracker = new ProcessedArtifactTracker();
        this.publishingTemplate = null;
        this.renderer = null;
        this.tokenService = orcsApi.tokenService();
        this.viewId = null;
    }

    protected List<ArtifactReadable> addContextToArtifactList(List<ArtifactReadable> changedArtifacts) {
        LinkedList<ArtifactReadable> artifactsWithContext = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable artifact : changedArtifacts) {
            if (!artifactsWithContext.contains(artifact)) {
                artifactsWithContext.add(artifact);
            }
            List ancestors = artifact.getAncestors();
            for (ArtifactReadable ancestor : ancestors) {
                if (artifactsWithContext.contains(ancestor) || !ancestor.notEqual((Id)CoreArtifactTokens.DefaultHierarchyRoot)) break;
                artifactsWithContext.add(ancestor);
            }
            List siblings = artifact.getParent().getChildren();
            for (ArtifactReadable sibling : siblings) {
                if (artifactsWithContext.contains(sibling) || sibling.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) continue;
                artifactsWithContext.add(sibling);
            }
        }
        return artifactsWithContext;
    }

    protected void addLinkNotInPublishErrors() {
        this.hyperlinkedIds.entrySet().stream().filter(arg_0 -> ((ProcessedArtifactTracker)this.processedArtifactTracker).isNotBookmarked(arg_0)).forEach(hyperlinkEntry -> {
            String linkReference = (String)hyperlinkEntry.getKey();
            ArtifactReadable artifactWithLink = (ArtifactReadable)hyperlinkEntry.getValue();
            String title = this.processedArtifactTracker.containsByLinkReference(linkReference) ? (this.processedArtifactTracker.isPublished(linkReference) ? "Artifact contains a link to an unbookmarked artifact." : "Artifact contains a link to a processed artifact that was excluded from the publish.") : (WordCoreUtil.isLinkReferenceAnArtifactId((CharSequence)linkReference) ? this.publishingUtils.getArtifactReadableByIdentifier(new ArtifactSpecification(this.branchId, ArtifactId.SENTINEL, ArtifactId.valueOf((String)linkReference))) : this.publishingUtils.getArtifactReadableByGuid(new BranchSpecification(this.branchId), linkReference)).map(artifactReadable -> "Artifact contains a link to an artifact that is not contained in the document.").orElse("Artifact contains a link to an unknown artifact. ");
            this.publishingErrorLog.error(artifactWithLink, new Message().title((CharSequence)title).segment((CharSequence)"Artifact With Link", (Object)artifactWithLink.getIdString()).segment((CharSequence)"Link Reference", (Object)linkReference).toString());
        });
    }

    protected void applyContentToTemplate(List<ArtifactReadable> artifacts, CharSequence templateContent, WordMLProducer wordMl) {
        WordRenderUtil.setupPublishingTemplate((PublishingTemplate)this.publishingTemplate, (ArtifactReadable)artifacts.get(0), (WordMLProducer)wordMl, (String)this.outlineNumber, null, (int)this.maximumOutlineDepth);
        WordCoreUtil.processPublishingTemplate((CharSequence)templateContent, segment -> {
            wordMl.addWordMl(segment);
            this.processArtifactSet(artifacts, wordMl);
            this.addLinkNotInPublishErrors();
            this.publishingErrorLog.publishErrorLog(wordMl);
        }, tail -> {
            CharSequence cleanFooterText = WordCoreUtil.cleanupFooter((CharSequence)tail);
            wordMl.addWordMl(cleanFooterText);
        });
    }

    public void applyTemplate(List<ArtifactId> publishArtifactIds, Writer writer) {
        if (Objects.isNull(publishArtifactIds) || publishArtifactIds.isEmpty()) {
            return;
        }
        String templateContent = Objects.nonNull(this.publishingTemplate) ? this.publishingTemplate.getTemplateContent().getTemplateString() : "";
        List<ArtifactReadable> publishArtifacts = this.getSelectedArtifacts(publishArtifactIds);
        WordMLProducer wordMl = new WordMLProducer((Appendable)writer);
        this.applyContentToTemplate(publishArtifacts, templateContent, wordMl);
    }

    protected boolean checkIncluded(ArtifactReadable artifact) {
        boolean excludeFolder;
        boolean validWordTemplateContent = !artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.WholeWordContent) && !artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.NativeContent);
        boolean bl = excludeFolder = this.excludeFolders != false && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder});
        if (!excludeFolder && this.checkIsArtifactApplicable(artifact)) {
            if (validWordTemplateContent) {
                return true;
            }
            this.publishingErrorLog.error(artifact, "Only artifacts of type Word Template Content are supported in this case");
            return false;
        }
        return false;
    }

    protected boolean checkIsArtifactApplicable(ArtifactReadable artifact) {
        boolean isApplicable = this.viewId.equals(ArtifactId.SENTINEL);
        if (isApplicable) {
            return isApplicable;
        }
        ApplicabilityId applicability = artifact.getApplicability();
        if (this.applicabilityMap.containsKey(applicability)) {
            isApplicable = this.applicabilityMap.get(applicability);
        } else {
            List validViews = this.orcsApi.getQueryFactory().applicabilityQuery().getBranchViewsForApplicability(this.branchId, applicability);
            if (validViews.contains(this.viewId)) {
                isApplicable = true;
            }
            this.applicabilityMap.put(applicability, isApplicable);
        }
        return isApplicable;
    }

    public WordTemplateProcessorServer configure(PublishingTemplate publishingTemplate, EnumRendererMap publishingOptions) {
        OutliningOptions outliningOptions;
        this.publishingTemplate = publishingTemplate;
        this.renderer = publishingOptions;
        this.elementType = this.publishingTemplate.getRendererOptions().getElementType();
        if (!ARTIFACT.equals(this.elementType)) {
            throw new OseeCoreException(new Message().title((CharSequence)"MSWordTemplatePublisher::applyTemplate, publishing is only implement for ARTIFACT element types.").indentInc().segment((CharSequence)"Publishing Template", (Object)this.publishingTemplate.getName()).segment((CharSequence)"Element Type", (Object)this.elementType).toString(), new Object[0]);
        }
        this.excludeFolders = this.renderer.isRendererOptionSetAndTrue(RendererOption.EXCLUDE_FOLDERS);
        OutliningOptions[] outliningOptionsArray = this.publishingTemplate.getRendererOptions().getOutliningOptions();
        OutliningOptions outliningOptions2 = outliningOptions = Objects.nonNull(outliningOptionsArray) && outliningOptionsArray.length >= 1 ? outliningOptionsArray[0] : null;
        if (Objects.isNull(outliningOptions)) {
            throw new OseeCoreException(new Message().title((CharSequence)"WordTemplateProcessorServer::applyTemplate, publishing outlining options must be provided in the template publishing options.").indentInc().segment((CharSequence)"Publishing Template", (Object)this.publishingTemplate.getName()).toString(), new Object[0]);
        }
        this.headingAttributeType = this.tokenService.getAttributeType(outliningOptions.getHeadingAttributeType());
        this.maximumOutlineDepth = this.renderer.isRendererOptionSet(RendererOption.MAX_OUTLINE_DEPTH) ? (Integer)this.renderer.getRendererOptionValue(RendererOption.MAX_OUTLINE_DEPTH) : Integer.valueOf(9);
        this.outlineNumber = outliningOptions.getOutlineNumber();
        String overrideDataRights = (String)this.renderer.getRendererOptionValue(RendererOption.OVERRIDE_DATA_RIGHTS);
        this.overrideClassification = DataRightsClassification.isValid((String)overrideDataRights) ? overrideDataRights : "invalid";
        this.branchId = (BranchId)this.renderer.getRendererOptionValue(RendererOption.BRANCH);
        this.viewId = (ArtifactId)this.renderer.getRendererOptionValue(RendererOption.VIEW);
        return this;
    }

    protected Map<ApplicabilityId, ApplicabilityToken> getApplicabilityTokens() {
        if (this.applicabilityTokens == null) {
            this.applicabilityTokens = new HashMap<ApplicabilityId, ApplicabilityToken>();
            HashMap tokens = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.branchId);
            for (Map.Entry entry : tokens.entrySet()) {
                this.applicabilityTokens.put(ApplicabilityId.valueOf((Long)((Long)entry.getKey())), (ApplicabilityToken)entry.getValue());
            }
        }
        return this.applicabilityTokens;
    }

    protected String getArtifactFooter(ArtifactReadable artifact) {
        return "";
    }

    protected CharSequence getAttributeValueAsString(AttributeTypeToken token, ArtifactReadable artifact) {
        return artifact.getAttributeValuesAsString(token);
    }

    protected List<AttributeTypeToken> getOrderedAttributeTypes(Collection<AttributeTypeToken> attributeTypes) {
        ArrayList<AttributeTypeToken> orderedAttributeTypes = new ArrayList<AttributeTypeToken>(attributeTypes.size());
        AttributeTypeToken contentType = null;
        for (AttributeTypeToken attributeType : attributeTypes) {
            if (attributeType.matches(new Id[]{CoreAttributeTypes.WholeWordContent, CoreAttributeTypes.WordTemplateContent, CoreAttributeTypes.PlainTextContent})) {
                contentType = attributeType;
                continue;
            }
            orderedAttributeTypes.add(attributeType);
        }
        Collections.sort(orderedAttributeTypes);
        if (contentType != null) {
            orderedAttributeTypes.add(contentType);
        }
        return orderedAttributeTypes;
    }

    protected List<ArtifactReadable> getSelectedArtifacts(List<ArtifactId> artifactIds) {
        List artifacts = this.orcsApi.getQueryFactory().fromBranch(this.branchId).andIds(artifactIds).getResults().getList();
        artifacts.sort(this.hierarchyComparator);
        return artifacts;
    }

    protected Map<ArtifactReadable, List<ArtifactReadable>> getSortedArtifactsInHeaderMap(List<ArtifactReadable> artifacts) {
        HashMap<ArtifactReadable, List<ArtifactReadable>> headerMap = new HashMap<ArtifactReadable, List<ArtifactReadable>>();
        ArtifactReadable lastHeader = null;
        LinkedList<ArtifactReadable> artList = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable art : artifacts) {
            if (this.headerArtifacts.contains(art)) {
                if (lastHeader == null) {
                    lastHeader = art;
                    artList = new LinkedList();
                    continue;
                }
                headerMap.put(lastHeader, artList);
                lastHeader = art;
                artList = new LinkedList();
                continue;
            }
            artList.add(art);
        }
        headerMap.put(lastHeader, artList);
        return headerMap;
    }

    protected String[] getSplitWordMlBookmark(ArtifactReadable artifact) {
        String wordMlBookmark = this.getWordMlBookmark(artifact).toString();
        return wordMlBookmark.split("(?<=>)", 2);
    }

    protected CharSequence getWordMlBookmark(ArtifactReadable artifact) {
        CharSequence bookmark = WordCoreUtil.getWordMlBookmark((Long)artifact.getId());
        bookmark = WordCoreUtilServer.reassignBookMarkID(bookmark);
        String guid = artifact.getGuid();
        this.processedArtifactTracker.setBookmarked(guid);
        if (this.hyperlinkedIds.containsKey(guid)) {
            this.hyperlinkedIds.remove(guid);
        }
        return bookmark;
    }

    protected boolean populateEmptyHeaders(List<ArtifactReadable> artifacts) {
        boolean hasIncludedChildren = false;
        boolean includeParent = false;
        List children = null;
        for (ArtifactReadable artifact : artifacts) {
            children = artifact.getChildren();
            if (!children.isEmpty()) {
                hasIncludedChildren = this.populateEmptyHeaders(children);
                if (!hasIncludedChildren && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                    this.emptyFolders.add((ArtifactId)artifact);
                }
            } else if (children.isEmpty() && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                this.emptyFolders.add((ArtifactId)artifact);
            }
            if (!this.excludeArtifactTypes.contains(artifact.getArtifactType()) && !artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                includeParent = true;
            }
            if (!hasIncludedChildren) continue;
            includeParent = true;
        }
        return includeParent;
    }

    protected void populateOseeLinkedArtifacts(ArtifactTypeToken ... typeTokens) {
        List linkedArts = this.orcsApi.getQueryFactory().fromBranch(this.branchId).andGuids(this.hyperlinkedIds.keySet()).getResults().getList();
        for (ArtifactReadable artifact : linkedArts) {
            if (!artifact.isOfType((ArtifactTypeId[])typeTokens)) continue;
            ArtifactTypeToken artifactType = artifact.getArtifactType();
            if (this.oseeLinkedArtifactMap.containsKey(artifactType)) {
                this.oseeLinkedArtifactMap.get(artifactType).add(artifact);
            } else {
                LinkedList<ArtifactReadable> artList = new LinkedList<ArtifactReadable>();
                artList.add(artifact);
                this.oseeLinkedArtifactMap.put(artifactType, artList);
            }
            this.hyperlinkedIds.remove(artifact.getGuid());
        }
    }

    protected void processArtifact(ArtifactReadable artifact, WordMLProducer wordMl, DataRightContentBuilder dataRightContentBuilder) {
        boolean recurse;
        if (this.processedArtifactTracker.isOk((ArtifactId)artifact)) {
            return;
        }
        this.processedArtifactTracker.add(artifact);
        boolean startedSection = false;
        if (this.checkIncluded(artifact)) {
            startedSection |= this.renderArtifact(artifact, wordMl, dataRightContentBuilder);
        }
        if (recurse = this.publishingTemplate.getRendererOptions().getOutliningOptions()[0].isRecurseChildren()) {
            List children = new LinkedList();
            try {
                children = artifact.getChildren();
            }
            catch (OseeCoreException oseeCoreException) {
                this.publishingErrorLog.error(artifact, "There is an error when finding children for this artifact. Possible Cause: Empty Relation Order Attribute");
            }
            for (ArtifactReadable childArtifact : children) {
                if (childArtifact != null) {
                    this.processArtifact(childArtifact, wordMl, dataRightContentBuilder);
                    continue;
                }
                this.publishingErrorLog.error(artifact, "Artifact has an empty child relation");
            }
        }
        if (startedSection) {
            wordMl.endOutlineSubSection();
        }
        this.processedArtifactTracker.setOk((ArtifactId)artifact);
    }

    protected void processArtifactSet(List<ArtifactReadable> artifacts, WordMLProducer wordMl) {
        artifacts.forEach(artifact -> this.processArtifact((ArtifactReadable)artifact, wordMl, null));
    }

    protected void processAttribute(ArtifactReadable artifact, WordMLProducer wordMl, AttributeOptions attributeOptions, AttributeTypeToken attributeType, boolean allAttrs, PresentationType presentationType, String footer) {
        if (CoreAttributeTypes.WordOleData.equals((Object)attributeType) || CoreAttributeTypes.RelationOrder.equals((Object)attributeType) || !artifact.isAttributeTypeValid((AttributeTypeId)attributeType) || artifact.getAttributeValues(attributeType).isEmpty()) {
            return;
        }
        this.processedArtifactTracker.incrementAttributeCount((ArtifactId)artifact);
        if (attributeType.equals(CoreAttributeTypes.WordTemplateContent)) {
            this.renderWordTemplateContent(artifact, presentationType, wordMl, attributeOptions.getFormat(), attributeOptions.getLabel(), footer);
            return;
        }
        WordRenderUtil.renderAttribute((AttributeTypeToken)attributeType, null, (ArtifactReadable)artifact, (WordMLProducer)wordMl, (String)attributeOptions.getLabel(), (String)attributeOptions.getFormat());
    }

    protected void trackDocumentLinks(ArtifactReadable artifact, String data, Set<String> unknownIds) {
        if (!unknownIds.isEmpty()) {
            this.publishingErrorLog.error(artifact, String.format("Artifact contains the following unknown GUIDs: %s (Delete or fix OSEE Link from Artifact)", unknownIds));
        }
        Pattern bookmarkHyperlinkPattern = Pattern.compile("(^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/><aml:annotation[^<>]+Word.Bookmark.End\\\"/>)|(<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>)");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        while (match.find()) {
            String hyperlinkIdentifier;
            boolean bookmarkMatch = Objects.nonNull(match.group(1));
            boolean hyperlinkMatch = Objects.nonNull(match.group(3));
            if (bookmarkMatch) {
                String bookmarkIdentifier = match.group(2);
                this.processedArtifactTracker.setBookmarked(bookmarkIdentifier);
            }
            if (!hyperlinkMatch || this.hyperlinkedIds.containsKey(hyperlinkIdentifier = match.group(4))) continue;
            this.hyperlinkedIds.put(hyperlinkIdentifier, artifact);
        }
    }

    private boolean processOutlining(ArtifactReadable artifact, WordMLProducer wordMl) {
        boolean outlining = this.publishingTemplate.getRendererOptions().getOutliningOptions()[0].isOutlining();
        Boolean publishInline = (Boolean)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PublishInline, (Object)false);
        if (outlining && !publishInline.booleanValue()) {
            this.setArtifactOutlining(artifact, wordMl);
            return true;
        }
        return false;
    }

    protected String removeUnusedBookmark(CharSequence input) {
        String data = input.toString();
        Pattern bookmarkHyperlinkPattern = Pattern.compile("^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/><aml:annotation[^<>]+Word.Bookmark.End\\\"/>");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        String id = "";
        while (match.find()) {
            String foundMatch = match.group(0);
            if (!Strings.isValid((String)foundMatch) || this.hyperlinkedIds.containsKey(id = match.group(1))) continue;
            data = data.substring(match.end(0));
        }
        return data;
    }

    protected boolean renderArtifact(ArtifactReadable artifact, WordMLProducer wordMl, DataRightContentBuilder dataRightContentBuilder) {
        boolean startedSection = this.processOutlining(artifact, wordMl);
        String footer = "";
        WordCoreUtil.pageType orientation = WordRenderUtil.getPageOrientation((PublishingArtifact)new WordRenderArtifactWrapperServerImpl(artifact));
        String finalFooter = footer = Objects.nonNull(dataRightContentBuilder) ? dataRightContentBuilder.getContent((ArtifactId)artifact, orientation) : "";
        if (Objects.isNull(this.applicabilityTokens)) {
            this.applicabilityTokens = WordCoreUtilServer.getApplicabilityTokens(this.orcsApi, this.branchId);
        }
        WordRenderUtil.processMetadataOptions((MetadataOptions[])this.publishingTemplate.getRendererOptions().getMetadataOptions(), this.applicabilityTokens, (ArtifactReadable)new WordRenderArtifactWrapperServerImpl(artifact), (WordMLProducer)wordMl);
        WordRenderUtil.processAttributes(Arrays.asList(this.publishingTemplate.getRendererOptions().getAttributeOptions()), (lAttributeOptions, lAttributeType, lAllAttributes) -> this.processAttribute(artifact, wordMl, lAttributeOptions, lAttributeType, lAllAttributes, PresentationType.PREVIEW, finalFooter), attributeName -> this.tokenService.getAttributeType(attributeName), () -> this.getOrderedAttributeTypes(artifact.getValidAttributeTypes()), (ArtifactReadable)artifact, (AttributeTypeToken)this.headingAttributeType, (boolean)this.renderer.isRendererOptionSetAndTrue(RendererOption.ALL_ATTRIBUTES), (boolean)this.publishingTemplate.getRendererOptions().getOutliningOptions()[0].isOutlining());
        return startedSection;
    }

    protected void renderWordTemplateContent(ArtifactReadable artifact, PresentationType presentationType, WordMLProducer wordMl, String format, String label, String footer) {
        assert (Objects.nonNull(footer)) : "MSWordTemplatePublisher::renderWordTemplateContent, an artifact's footer must never be null.";
        HashSet<String> unknownGuids = new HashSet<String>();
        String wordMlContentDataAndFooter = WordRenderUtil.renderWordAttribute((ArtifactReadable)artifact, (ArtifactId)this.viewId, (WordMLProducer)wordMl, (RendererMap)this.renderer, (PresentationType)presentationType, (String)label, (String)footer, (String)this.permanentLinkUrl, (boolean)this.changedArtifactsTracker.isChangedArtifact((ArtifactId)artifact), (TransactionToken)(artifact.isHistorical() ? this.orcsApi.getTransactionFactory().getTx(artifact.getTransaction()) : TransactionToken.SENTINEL), unknownGuids, wordTemplateContentData -> new WordTemplateContentRendererHandler(this.orcsApi, this.logger).renderWordML((WordTemplateContentData)wordTemplateContentData), exception -> this.publishingErrorLog.error(artifact, exception.getMessage()));
        this.trackDocumentLinks(artifact, wordMlContentDataAndFooter, unknownGuids);
    }

    protected void setArtifactOutlining(ArtifactReadable artifact, WordMLProducer wordMl) {
        CharSequence headingText = artifact.getSoleAttributeAsString(this.headingAttributeType, "");
        if (this.changedArtifactsTracker.isChangedArtifact((ArtifactId)artifact)) {
            headingText = WordCoreUtil.appendInlineChangeTagToHeadingText((CharSequence)headingText);
        }
        CharSequence paragraphNumber = null;
        paragraphNumber = wordMl.startOutlineSubSection((CharSequence)FONT, headingText, null);
        if (paragraphNumber == null) {
            paragraphNumber = wordMl.startOutlineSubSection();
        }
        if (this.renderer.isRendererOptionSetAndTrue(RendererOption.UPDATE_PARAGRAPH_NUMBERS)) {
            this.artParagraphNumbers.put(artifact, paragraphNumber);
        }
    }

    protected void sortQueryListByAttributeAlphabetical(List<ArtifactReadable> artifacts, AttributeTypeToken attributeToken) {
        try {
            artifacts.sort((Comparator<ArtifactReadable>)new AttributeAlphabeticalComparator(this.activityLog, attributeToken));
        }
        catch (Exception exception) {
            String errorMessage = String.format("There was an error when sorting the list on %s by alphabetical order", attributeToken.getName());
            this.publishingErrorLog.error(errorMessage);
        }
    }

    protected void sortQueryListByHierarchy(List<ArtifactReadable> artifacts) {
        artifacts.sort((Comparator<ArtifactReadable>)this.hierarchyComparator);
        for (Map.Entry entry : this.hierarchyComparator.errors.entrySet()) {
            ArtifactReadable art = (ArtifactReadable)entry.getKey();
            String description = (String)entry.getValue();
            this.publishingErrorLog.error(art, description);
        }
    }

    protected void startOutlineSubSectionAndBookmark(WordMLProducer wordMl, ArtifactReadable artifact) {
        this.processedArtifactTracker.add(artifact);
        String[] splitBookmark = this.getSplitWordMlBookmark(artifact);
        wordMl.addWordMl((CharSequence)splitBookmark[0]);
        wordMl.startOutlineSubSection((CharSequence)FONT, (CharSequence)artifact.getName(), null);
        wordMl.addWordMl((CharSequence)splitBookmark[1]);
        this.processedArtifactTracker.setOk((ArtifactId)artifact);
    }

    protected void updateParagraphNumbers() {
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branchId, "Update paragraph number on artifact");
        int count = 0;
        for (Map.Entry<ArtifactReadable, CharSequence> art : this.artParagraphNumbers.entrySet()) {
            if (art.getKey().isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.ParagraphNumber)) {
                transaction.setSoleAttributeValue((ArtifactId)art.getKey(), (AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)art.getValue());
            }
            if (count++ <= 500) continue;
            transaction.commit();
            count = 0;
        }
        transaction.commit();
        this.artParagraphNumbers.clear();
    }
}

