/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.GUID;

@XmlRootElement(name="DispoAnnotationData")
public class DispoAnnotationData {
    private String guid = GUID.create();
    private int index;
    private String developerNotes;
    private String customerNotes;
    private String locationRefs = "";
    private boolean isConnected;
    private List<String> idsOfCoveredDiscrepancies = new ArrayList<String>();
    private String resolution;
    private String lastResolution;
    private boolean isResolutionValid;
    private String resolutionType;
    private boolean isDefault;
    private boolean isAnalyze;
    private boolean needsModify;
    private String resolutionMethodType;
    private boolean isPairAnnotation = false;
    private String possiblePairs;
    private String satisfiedPairs;
    private Collection<Integer> pairedWith;
    private int row;
    private boolean isRowCovered;

    public String getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.locationRefs;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDeveloperNotes() {
        return this.developerNotes;
    }

    public String getCustomerNotes() {
        return this.customerNotes;
    }

    public String getLocationRefs() {
        return this.locationRefs;
    }

    public List<String> getIdsOfCoveredDiscrepancies() {
        return this.idsOfCoveredDiscrepancies;
    }

    public boolean getIsConnected() {
        return this.isConnected;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getLastResolution() {
        return this.lastResolution;
    }

    public boolean getIsResolutionValid() {
        return this.isResolutionValid;
    }

    public String getResolutionType() {
        return this.resolutionType;
    }

    public boolean getIsDefault() {
        this.isDefault = this.resolutionType.equals("Test_Script") || this.resolutionType.equals("Exception_Handling");
        return this.isDefault;
    }

    public boolean getIsAnalyze() {
        this.isAnalyze = this.resolutionType.contains("Analysis");
        return this.isAnalyze;
    }

    public boolean getNeedsModify() {
        this.needsModify = this.resolutionType.contains("Modify_");
        return this.needsModify;
    }

    public String getResolutionMethodType() {
        return this.resolutionMethodType;
    }

    public String getPossiblePairs() {
        return this.possiblePairs;
    }

    public String getSatisfiedPairs() {
        return this.satisfiedPairs;
    }

    public boolean getIsPairAnnotation() {
        this.isPairAnnotation = this.locationRefs.contains(").");
        return this.isPairAnnotation;
    }

    public Collection<Integer> getPairedWith() {
        return this.pairedWith;
    }

    public int getRow() {
        return this.row;
    }

    public boolean getIsRowCovered() {
        return this.isRowCovered;
    }

    public void setLocationRefs(String locationRefs) {
        this.locationRefs = locationRefs;
    }

    public void setDeveloperNotes(String developerNotes) {
        this.developerNotes = developerNotes;
    }

    public void setCustomerNotes(String customerNotes) {
        this.customerNotes = customerNotes;
    }

    public void setId(String id) {
        this.guid = id;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setIdsOfCoveredDiscrepancies(List<String> idsOfCoveredDiscrepancies) {
        this.idsOfCoveredDiscrepancies = idsOfCoveredDiscrepancies;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public void setLastResolution(String lastResolution) {
        this.lastResolution = lastResolution;
    }

    public void setIsResolutionValid(boolean isResolutionValid) {
        this.isResolutionValid = isResolutionValid;
    }

    public void setResolutionType(String resolutionType) {
        this.resolutionType = resolutionType;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setIsAnalyze(boolean isAnalyzed) {
        this.isAnalyze = isAnalyzed;
    }

    public void setNeedsModify(boolean isAnalyzed) {
        this.needsModify = this.needsModify;
    }

    public void setResolutionMethodType(String resolutionMethodType) {
        this.resolutionMethodType = resolutionMethodType;
    }

    @JsonIgnore
    public boolean isValid() {
        return (this.isConnected || this.isDefault) && this.isResolutionValid && this.isResolutionTypeValid();
    }

    private boolean isResolutionTypeValid() {
        return this.resolutionType != null && !this.resolutionType.isEmpty() && !this.resolutionType.equalsIgnoreCase("None") && !this.resolutionType.equalsIgnoreCase("null");
    }

    public void disconnect() {
        this.isConnected = false;
        this.idsOfCoveredDiscrepancies = new ArrayList<String>();
    }

    public void setPossiblePairs(String possiblePairs) {
        this.possiblePairs = possiblePairs;
    }

    public void setSatisfiedPairs(String satisfiedPairs) {
        this.satisfiedPairs = satisfiedPairs;
    }

    public void setIsPairAnnotation(boolean isPairAnnotation) {
        this.isPairAnnotation = isPairAnnotation;
    }

    public void setPairedWith(Collection<Integer> pairedWith) {
        this.pairedWith = pairedWith;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setIsRowCovered(boolean isRowCovered) {
        this.isRowCovered = isRowCovered;
    }
}

