/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.Stack;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;
import org.eclipse.osee.orcs.core.internal.applicability.TagNotPlacedCorrectlyException;

public class BatFileProcessor {
    private final BlockApplicabilityOps orcsApplicability;
    private final FileTypeApplicabilityData fileTypeApplicabilityData;
    private final Stack<ApplicabilityBlock> applicBlocks = new Stack();
    private final boolean isConfig;
    private final boolean commentNonApplicableBlocks;
    private final XResultData results = new XResultData();
    private final String charsetString = "UTF8";
    private boolean tagProcessed = false;

    public BatFileProcessor(BlockApplicabilityOps orcsApplicability, FileTypeApplicabilityData fileTypeApplicabilityData, boolean isConfig, boolean commentNonApplicableBlocks) {
        this.orcsApplicability = orcsApplicability;
        this.fileTypeApplicabilityData = fileTypeApplicabilityData;
        this.isConfig = isConfig;
        this.commentNonApplicableBlocks = commentNonApplicableBlocks;
        if (!OseeProperties.isInTest()) {
            this.results.setLogToSysErr(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processFile(File inFile, File outFile) throws Exception {
        if (!inFile.exists()) return this.tagProcessed;
        CharBuffer fileContent = this.applyApplicabilityContent(inFile);
        if (!this.tagProcessed) return this.tagProcessed;
        this.results.logf("Applicability was applied to %s\n", new Object[]{inFile.getName()});
        if (fileContent == null) return this.tagProcessed;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(outFile);
            try {
                block18: {
                    OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                    try {
                        try (BufferedWriter writer = new BufferedWriter(streamWriter);){
                            writer.write(fileContent.array());
                        }
                        if (streamWriter == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (streamWriter == null) throw throwable;
                        streamWriter.close();
                        throw throwable;
                    }
                    streamWriter.close();
                }
                if (outputStream == null) return this.tagProcessed;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return this.tagProcessed;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private CharBuffer applyApplicabilityContent(File inFile) throws Exception {
        this.results.logf("BatFileProcessor::applyApplicabilityContent => Started for file %s\n", new Object[]{inFile.getPath()});
        CharBuffer fileContent = Lib.fileToCharBuffer((File)inFile, (String)"UTF8");
        String toReturn = fileContent.toString();
        Matcher matcher = this.fileTypeApplicabilityData.getCommentedTagPattern().matcher(toReturn);
        int matcherIndex = 0;
        while (matcherIndex < toReturn.length() && matcher.find(matcherIndex)) {
            String applicabilityExpression;
            ApplicabilityBlock.ApplicabilityType applicabilityType;
            String beginFeature = matcher.group(1);
            String endFeature = matcher.group(6);
            String beginConfig = matcher.group(11);
            String endConfig = matcher.group(17);
            String beginConfigGrp = matcher.group(22);
            String endConfigGrp = matcher.group(28);
            String featureElse = matcher.group(33);
            String configureElse = matcher.group(38);
            String configureGroupElse = matcher.group(43);
            if (beginFeature != null) {
                applicabilityType = ApplicabilityBlock.ApplicabilityType.Feature;
                applicabilityExpression = matcher.group(2);
                matcherIndex = this.startApplicabilityBlock(applicabilityType, matcher, beginFeature, applicabilityExpression);
                continue;
            }
            if (beginConfig != null) {
                applicabilityExpression = matcher.group(12);
                applicabilityType = ApplicabilityBlock.ApplicabilityType.Configuration;
                if (beginConfig.contains("Not")) {
                    applicabilityType = ApplicabilityBlock.ApplicabilityType.NotConfiguration;
                }
                matcherIndex = this.startApplicabilityBlock(applicabilityType, matcher, beginConfig, applicabilityExpression);
                continue;
            }
            if (beginConfigGrp != null) {
                applicabilityExpression = matcher.group(23);
                applicabilityType = ApplicabilityBlock.ApplicabilityType.ConfigurationGroup;
                if (beginConfigGrp.contains("Not")) {
                    applicabilityType = ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup;
                }
                matcherIndex = this.startApplicabilityBlock(applicabilityType, matcher, beginConfigGrp, applicabilityExpression);
                continue;
            }
            if (featureElse != null) {
                this.checkForMismatchTags(inFile, endFeature, endConfig, endConfigGrp, featureElse, configureElse, configureGroupElse);
                matcherIndex = matcher.end();
                continue;
            }
            if (configureElse != null) {
                this.checkForMismatchTags(inFile, endFeature, endConfig, endConfigGrp, featureElse, configureElse, configureGroupElse);
                matcherIndex = matcher.end();
                continue;
            }
            if (configureGroupElse != null) {
                this.checkForMismatchTags(inFile, endFeature, endConfig, endConfigGrp, featureElse, configureElse, configureGroupElse);
                matcherIndex = matcher.end();
                continue;
            }
            if (endFeature != null || endConfig != null || endConfigGrp != null) {
                this.checkForMismatchTags(inFile, endFeature, endConfig, endConfigGrp, featureElse, configureElse, configureGroupElse);
                ApplicabilityBlock applicBlock = this.finishApplicabilityBlock(toReturn, matcher, inFile);
                String toReplace = toReturn.substring(applicBlock.getStartInsertIndex(), applicBlock.getEndInsertIndex());
                toReturn = toReturn.replace(toReplace, applicBlock.getInsideText());
                matcherIndex = applicBlock.getStartInsertIndex() + applicBlock.getInsideText().length();
                matcher = this.fileTypeApplicabilityData.getCommentedTagPattern().matcher(toReturn);
                this.tagProcessed = true;
                continue;
            }
            OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("BatFileProcessor::applyApplicabilityContent => Did not find a start or end feature tag for: " + inFile.getPath()));
            throw new TagNotPlacedCorrectlyException("Tag was not placed correctly in file: " + inFile.getPath());
        }
        if (!this.applicBlocks.isEmpty()) {
            throw new TagNotPlacedCorrectlyException("Tag was not placed correctly in file: " + inFile.getPath());
        }
        OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("BatFileProcessor::applyApplicabilityContent => Completed for file: " + inFile.getPath() + "and tagProcessed = " + this.tagProcessed));
        return CharBuffer.wrap(toReturn.toCharArray());
    }

    private int startApplicabilityBlock(ApplicabilityBlock.ApplicabilityType applicabilityType, Matcher matcher, String beginTag, String applicabilityExpression) {
        ApplicabilityBlock applicStart = new ApplicabilityBlock(applicabilityType);
        applicStart.setApplicabilityExpression(applicabilityExpression);
        applicStart.setStartInsertIndex(matcher.start());
        applicStart.setStartTextIndex(matcher.end());
        applicStart.setBeginTag(beginTag);
        this.applicBlocks.add(applicStart);
        return matcher.end();
    }

    private void checkForMismatchTags(File inFile, String endFeature, String endConfig, String endConfigGrp, String featureElse, String configureElse, String configureGroupElse) throws TagNotPlacedCorrectlyException {
        if (this.applicBlocks.isEmpty()) {
            if (featureElse != null) {
                OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("BatFileProcessor::applyApplicabilityContent => Else Feature tag was not placed correctly in file: " + inFile.getPath()));
                throw new TagNotPlacedCorrectlyException("Else Feature tag was not placed correctly in file: " + inFile.getPath());
            }
            if (configureElse != null) {
                OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("BatFileProcessor::applyApplicabilityContent => Else Configure tag was not placed correctly in file: " + inFile.getPath()));
                throw new TagNotPlacedCorrectlyException("Else Configure tag was not placed correctly in file: " + inFile.getPath());
            }
            if (configureGroupElse != null) {
                OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("BatFileProcessor::applyApplicabilityContent => Else Configure Group tag was not placed correctly in file: " + inFile.getPath()));
                throw new TagNotPlacedCorrectlyException("Else Configure Group tag was not placed correctly in file: " + inFile.getPath());
            }
            OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("BatFileProcessor::applyApplicabilityContent => Applicability tag was not placed correctly in file: " + inFile.getPath()));
            throw new TagNotPlacedCorrectlyException("Applicability tag was not placed correctly in file: " + inFile.getPath());
        }
        if (endFeature != null || featureElse != null) {
            if (this.applicBlocks.peek().getType() != ApplicabilityBlock.ApplicabilityType.Feature) {
                throw new TagNotPlacedCorrectlyException("Feature or Feature Else  tag was not placed correctly in file: " + inFile.getPath());
            }
        } else if (endConfig != null || configureElse != null) {
            if (this.applicBlocks.peek().getBeginTag().contains("Not")) {
                if (this.applicBlocks.peek().getType() != ApplicabilityBlock.ApplicabilityType.NotConfiguration) {
                    throw new TagNotPlacedCorrectlyException("Config Not or Config Else tag was not placed correctly in file: " + inFile.getPath());
                }
            } else if (this.applicBlocks.peek().getType() != ApplicabilityBlock.ApplicabilityType.Configuration) {
                throw new TagNotPlacedCorrectlyException("Config or Config Else tag was not placed correctly in file: " + inFile.getPath());
            }
        } else if (endConfigGrp != null || configureGroupElse != null) {
            if (this.applicBlocks.peek().getBeginTag().contains("Not")) {
                if (this.applicBlocks.peek().getType() != ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup) {
                    throw new TagNotPlacedCorrectlyException("Config Group Not or Config Group Else tag was not placed correctly in file: " + inFile.getPath());
                }
            } else if (this.applicBlocks.peek().getType() != ApplicabilityBlock.ApplicabilityType.ConfigurationGroup) {
                throw new TagNotPlacedCorrectlyException("Config Group or Config Group Else tag was not placed correctly in file: " + inFile.getPath());
            }
        }
    }

    private ApplicabilityBlock finishApplicabilityBlock(String toReturn, Matcher matcher, File inFile) throws IOException {
        String fileName;
        ApplicabilityBlock applicBlock = this.applicBlocks.pop();
        applicBlock.setEndTextIndex(matcher.start());
        applicBlock.setEndInsertIndex(matcher.end());
        String insideText = toReturn.subSequence(applicBlock.getStartTextIndex(), applicBlock.getEndTextIndex()).toString();
        applicBlock.setInsideText(insideText);
        String replacementText = this.orcsApplicability.evaluateApplicabilityExpression(applicBlock);
        if (!replacementText.isEmpty()) {
            if (!this.fileTypeApplicabilityData.getCommentPrefixRegex().isEmpty() && !this.fileTypeApplicabilityData.getCommentSuffixRegex().isEmpty()) {
                replacementText = replacementText.replaceAll(String.valueOf(System.getProperty("line.separator")) + "[ \\t]*" + this.fileTypeApplicabilityData.getCommentPrefixRegex() + "[ \\t]*" + this.fileTypeApplicabilityData.getCommentSuffixRegex() + "[ \\t]*" + System.getProperty("line.separator"), "");
            }
            if (!this.fileTypeApplicabilityData.getCommentPrefixRegex().isEmpty()) {
                replacementText = replacementText.replaceAll("[ \\t]*" + this.fileTypeApplicabilityData.getCommentPrefixRegex() + "[ \\t]*" + System.getProperty("line.separator"), System.getProperty("line.separator"));
                replacementText = replacementText.replaceAll("[ \\t]*" + this.fileTypeApplicabilityData.getCommentPrefixRegex() + "[ \\t]*" + '$', "");
            }
            if (!this.fileTypeApplicabilityData.getCommentSuffixRegex().isEmpty()) {
                replacementText = replacementText.replaceAll(String.valueOf(System.getProperty("line.separator")) + "[ \\t]*" + this.fileTypeApplicabilityData.getCommentSuffixRegex() + "[ \\t]*", System.getProperty("line.separator"));
                replacementText = replacementText.replaceAll("^[ \\t]*" + this.fileTypeApplicabilityData.getCommentSuffixRegex() + "[ \\t]*", "");
            }
        }
        if (!this.isConfig && this.commentNonApplicableBlocks) {
            String fullText = toReturn.subSequence(applicBlock.getStartInsertIndex(), applicBlock.getEndInsertIndex()).toString();
            fullText = this.getCommentedString(fullText, this.fileTypeApplicabilityData.getCommentPrefix(), this.fileTypeApplicabilityData.getCommentSuffix());
            String commentedReplacementText = this.getCommentedString(replacementText, this.fileTypeApplicabilityData.getCommentPrefix(), this.fileTypeApplicabilityData.getCommentSuffix());
            replacementText = fullText.replace(commentedReplacementText, replacementText);
        }
        if ((fileName = inFile.getName()).equals(".fileApplicability") && !replacementText.isEmpty() && replacementText.contains("!")) {
            replacementText = replacementText.replaceAll("\\!(.*)", "");
        }
        applicBlock.setInsideText(replacementText);
        return applicBlock;
    }

    private String getCommentedString(String text, String commentPrefix, String commentSuffix) throws IOException {
        Pattern whitespacePattern = Pattern.compile("\\s*");
        StringBuilder strB = new StringBuilder();
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            String line;
            String newLine = this.getNewLineFromFile(text);
            while ((line = reader.readLine()) != null) {
                if (!line.isEmpty()) {
                    boolean noSuffix;
                    boolean noPrefix;
                    boolean bl = commentPrefix.isEmpty() ? true : (noPrefix = !line.contains(commentPrefix));
                    boolean bl2 = commentSuffix.isEmpty() ? true : (noSuffix = !line.contains(commentSuffix));
                    if (noPrefix && noSuffix) {
                        Matcher match = whitespacePattern.matcher(line);
                        if (match.find()) {
                            strB.append(match.group());
                        }
                        strB.append(commentPrefix);
                        strB.append(line.substring(match.end()));
                        strB.append(commentSuffix);
                    } else {
                        strB.append(line);
                    }
                }
                strB.append(newLine);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return strB.toString();
    }

    private String getNewLineFromFile(String text) {
        Matcher matcher = Pattern.compile("\\r\\n|[\\n\\r]").matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return System.lineSeparator();
    }
}

