/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class SetupPublishing {
    private static final boolean matchPreviewTemplatesByName = true;
    private static Boolean newValues = false;
    private static Boolean noTags = false;
    private static final String previewTemplatesNotMatchByNameSuffix = " (NOT MATCHED BY NAME)";
    private static Supplier<List<PublishingTemplate>> publishingTemplatesSupplier = new Supplier<List<PublishingTemplate>>(){

        @Override
        public List<PublishingTemplate> get() {
            return List.of(new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordEditTemplate", "templates/WordEditTemplate.json", "templates/Word Edit Template.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "SPECIALIZED_EDIT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_TIS, "SPECIALIZED_EDIT"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordMergeTemplate", "templates/WordMergeTemplate.json", "templates/PREVIEW_ALL.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD, "MERGE_EDIT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD, "MERGE"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "MERGE"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "MERGE_EDIT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "DIFF THREE_WAY_MERGE"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_VALUE.getKey()), null, "templates/PREVIEW_ALL.xml", new PublishingTemplateMatchCriterionListBuilder().appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "DIFF")).appendIfMatchByNames(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW", RendererOption.PREVIEW_ALL_VALUE.getKey())).appendIfNotMatchByNames(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW")).appendIfMatchByNames(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD_EDIT, "PREVIEW_SERVER", RendererOption.PREVIEW_ALL_VALUE.getKey())).appendIfNotMatchByNames(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD_EDIT, "PREVIEW_SERVER")).toList()), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey()), "templates/PREVIEW_ALL_NO_ATTRIBUTES.json", "templates/PREVIEW_ALL_NO_ATTRIBUTES.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_ALL_NO_ATTRIBUTES"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "DIFF_NO_ATTRIBUTES"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey()), "templates/PREVIEW_ALL_RECURSE.json", "templates/PREVIEW_ALL_RECURSE.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_WITH_RECURSE"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey()), "templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.json", "templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_WITH_RECURSE_NO_ATTRIBUTES"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD_EDIT, "PREVIEW_SERVER PREVIEW_WITH_RECURSE_NO_ATTRIBUTES"))));
        }
    };
    private static String RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT = "org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer";
    private static String RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD_EDIT = "org.eclipse.osee.framework.ui.skynet.render.MSWordRestRenderer";
    private static String RENDERER_IDENTIFIER_TIS = "org.eclipse.osee.framework.ui.skynet.render.TisRenderer";
    private static String RENDERER_IDENTIFIER_WORD = "org.eclipse.osee.framework.ui.skynet.word";

    private static void createDataRights(TransactionBuilder tx) {
        ArtifactToken dataRightsArt = tx.createArtifact((ArtifactId)CoreArtifactTokens.DocumentTemplates, CoreArtifactTokens.DataRightsFooters);
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Unspecified.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Default.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"GovernmentPurposeRights.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"RestrictedRights.xml", SetupPublishing.class));
    }

    private static void createWordTemplates(TransactionBuilder tx) {
        publishingTemplatesSupplier.get().forEach(publishingTemplate -> publishingTemplate.createPublishingTemplate(tx));
    }

    private static String previewTemplateName(String templateBaseName) {
        return templateBaseName;
    }

    public static void setup(TransactionBuilder tx) {
        Objects.requireNonNull(tx, "SetupPublishing::setup, the parameter \"tx\" cannot be null.");
        SetupPublishing.createWordTemplates(tx);
        SetupPublishing.createDataRights(tx);
    }

    public static void setupConfiguration(OrcsApi orcsApi) {
        try {
            JdbcClient jdbcClient = orcsApi.getJdbcService().getClient();
            OseeInfo.setValue((JdbcClient)jdbcClient, (String)"osee.publish.no.tags", (String)noTags.toString());
            OseeInfo.setValue((JdbcClient)jdbcClient, (String)"osee.publish.new.values", (String)newValues.toString());
        }
        catch (Exception exception) {}
    }

    private SetupPublishing() {
    }

    private static class PublishingTemplate {
        private final List<PublishingTemplateMatchCriterion> matchCriteria;
        private final String name;
        private final ArtifactToken parentArtifactToken;
        private final String rendererOptionsFileName;
        private final String templateContentFileName;

        public PublishingTemplate(ArtifactToken parentArtifactToken, String name, String rendererOptionsFileName, String templateContentFileName, List<PublishingTemplateMatchCriterion> matchCriteria) {
            this.parentArtifactToken = Objects.requireNonNull(parentArtifactToken, "SetupPublishing.PublishingTemplate::new, paramter \"parentArtifactToken\" cannot be null.");
            this.name = Objects.requireNonNull(name, "SetupPublishing.PublishingTemplate::new, parameter \"name\" cannnot be null.");
            this.rendererOptionsFileName = rendererOptionsFileName;
            this.templateContentFileName = templateContentFileName;
            this.matchCriteria = matchCriteria;
        }

        public void createPublishingTemplate(TransactionBuilder tx) {
            Objects.requireNonNull(tx, "SetupPublishing::createPublishingTemplate, parameter \"tx\" cannot be null.");
            ArtifactToken publishingTemplateArtifact = tx.createArtifact((ArtifactId)this.parentArtifactToken, CoreArtifactTypes.RendererTemplateWholeWord, this.name);
            if (Objects.nonNull(this.rendererOptionsFileName)) {
                tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)OseeInf.getResourceContents((String)this.rendererOptionsFileName, SetupPublishing.class));
            }
            if (Objects.nonNull(this.templateContentFileName)) {
                tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)this.templateContentFileName, SetupPublishing.class));
            }
            if (Objects.nonNull(this.matchCriteria)) {
                this.matchCriteria.forEach(matchCriterion -> matchCriterion.setTemplateMatchCriteria(tx, (ArtifactId)publishingTemplateArtifact));
            }
        }
    }

    private static class PublishingTemplateMatchCriterion {
        private final String option;
        private final String presentationType;
        private final String rendererIdentifier;

        public PublishingTemplateMatchCriterion(String rendererIdentifier, String presentationType) {
            this(rendererIdentifier, presentationType, null);
        }

        public PublishingTemplateMatchCriterion(String rendererIdentifier, String presentationType, String option) {
            Objects.requireNonNull(rendererIdentifier, "SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"rendererIdentifier\" cannot be null.");
            if (rendererIdentifier.isBlank()) {
                throw new IllegalArgumentException("SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"rendererIdentifier\" cannot be blank.");
            }
            Objects.requireNonNull(presentationType, "SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"presentationType\" cannot be null.");
            if (presentationType.isBlank()) {
                throw new IllegalArgumentException("SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"presentationType\" cannot be blank.");
            }
            if (Objects.nonNull(option) && option.isBlank()) {
                throw new IllegalArgumentException("SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"option\" cannot be blank.");
            }
            this.rendererIdentifier = rendererIdentifier;
            this.presentationType = presentationType;
            this.option = option;
        }

        public void setTemplateMatchCriteria(TransactionBuilder tx, ArtifactId templateArtifact) {
            StringBuilder matchCriteria = new StringBuilder(this.rendererIdentifier.length() + this.presentationType.length() + (Objects.nonNull(this.option) ? this.option.length() : 0) + 8).append(this.rendererIdentifier).append(" ").append(this.presentationType);
            if (Objects.nonNull(this.option)) {
                matchCriteria.append(" ").append(this.option);
            }
            tx.createAttribute(templateArtifact, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)matchCriteria.toString());
        }
    }

    private static class PublishingTemplateMatchCriterionListBuilder {
        private final LinkedList<PublishingTemplateMatchCriterion> list = new LinkedList();

        PublishingTemplateMatchCriterionListBuilder() {
        }

        PublishingTemplateMatchCriterionListBuilder appendAlways(PublishingTemplateMatchCriterion publishingTemplateMatchCriterion) {
            this.list.add(Objects.requireNonNull(publishingTemplateMatchCriterion));
            return this;
        }

        PublishingTemplateMatchCriterionListBuilder appendIfMatchByNames(PublishingTemplateMatchCriterion publishingTemplateMatchCriterion) {
            this.list.add(publishingTemplateMatchCriterion);
            return this;
        }

        PublishingTemplateMatchCriterionListBuilder appendIfNotMatchByNames(PublishingTemplateMatchCriterion publishingTemplateMatchCriterion) {
            return this;
        }

        List<PublishingTemplateMatchCriterion> toList() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

