/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceMessageToken
extends PLGenericDBObject {
    public static final InterfaceMessageToken SENTINEL = new InterfaceMessageToken();
    private String InterfaceMessageNumber;
    private String InterfaceMessagePeriodicity;
    private String InterfaceMessageRate;
    private Boolean InterfaceMessageWriteAccess;
    private String InterfaceMessageType;
    private Boolean interfaceMessageExclude;
    private String interfaceMessageIoMode;
    private String interfaceMessageModeCode;
    private String interfaceMessageRateVer;
    private String interfaceMessagePriority;
    private String interfaceMessageProtocol;
    private String interfaceMessageRptWordCount;
    private String interfaceMessageRptCmdWord;
    private Boolean interfaceMessageRunBeforeProc;
    private String interfaceMessageVer;
    private String Description;
    private List<InterfaceSubMessageToken> subMessages = new LinkedList<InterfaceSubMessageToken>();
    private List<InterfaceNode> publisherNodes = new LinkedList<InterfaceNode>();
    private List<InterfaceNode> subscriberNodes = new LinkedList<InterfaceNode>();
    private ApplicabilityToken applicability;
    private ArtifactReadable artifactReadable;

    public InterfaceMessageToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceMessageToken(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setInterfaceMessageNumber((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber, (Object)""));
        this.setInterfaceMessagePeriodicity(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessagePeriodicity, ""));
        this.setInterfaceMessageRate(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, ""));
        this.setInterfaceMessageType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, ""));
        this.setInterfaceMessageWriteAccess((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess, (Object)false));
        this.setInterfaceMessageExclude((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageExclude, (Object)false));
        this.setInterfaceMessageIoMode(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageIoMode, ""));
        this.setInterfaceMessageModeCode(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageModeCode, ""));
        this.setInterfaceMessageRateVer(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRateVer, ""));
        this.setInterfaceMessagePriority(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessagePriority, ""));
        this.setInterfaceMessageProtocol(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageProtocol, ""));
        this.setInterfaceMessageRptWordCount(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRptWordCount, ""));
        this.setInterfaceMessageRptCmdWord(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRptCmdWord, ""));
        this.setInterfaceMessageRunBeforeProc((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRunBeforeProc, (Object)false));
        this.setInterfaceMessageVer(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageVer, ""));
        this.setSubMessages(art.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceSubMessageToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.artifactReadable = art;
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceMessageToken(Long id, String name) {
        super(id, name);
        this.setInterfaceMessageNumber("");
        this.setInterfaceMessagePeriodicity("");
        this.setInterfaceMessageRate("");
        this.setInterfaceMessageWriteAccess(false);
        this.setInterfaceMessageType("");
        this.setInterfaceMessageExclude(false);
        this.setInterfaceMessageIoMode("");
        this.setInterfaceMessageModeCode("");
        this.setInterfaceMessageRateVer("");
        this.setInterfaceMessagePriority("");
        this.setInterfaceMessageProtocol("");
        this.setInterfaceMessageRptWordCount("");
        this.setInterfaceMessageRptCmdWord("");
        this.setInterfaceMessageRunBeforeProc(false);
        this.setInterfaceMessageVer("");
    }

    public InterfaceMessageToken() {
    }

    public String getInterfaceMessageNumber() {
        return this.InterfaceMessageNumber;
    }

    public void setInterfaceMessageNumber(String interfaceMessageNumber) {
        this.InterfaceMessageNumber = interfaceMessageNumber;
    }

    public String getInterfaceMessagePeriodicity() {
        return this.InterfaceMessagePeriodicity;
    }

    public void setInterfaceMessagePeriodicity(String interfaceMessagePeriodicity) {
        this.InterfaceMessagePeriodicity = interfaceMessagePeriodicity;
    }

    public String getInterfaceMessageRate() {
        return this.InterfaceMessageRate;
    }

    public void setInterfaceMessageRate(String interfaceMessageRate) {
        this.InterfaceMessageRate = interfaceMessageRate;
    }

    public Boolean getInterfaceMessageWriteAccess() {
        return this.InterfaceMessageWriteAccess;
    }

    public void setInterfaceMessageWriteAccess(Boolean interfaceMessageWriteAccess) {
        this.InterfaceMessageWriteAccess = interfaceMessageWriteAccess;
    }

    public String getInterfaceMessageType() {
        return this.InterfaceMessageType;
    }

    public void setInterfaceMessageType(String interfaceMessageType) {
        this.InterfaceMessageType = interfaceMessageType;
    }

    public Collection<InterfaceSubMessageToken> getSubMessages() {
        return this.subMessages;
    }

    public void setSubMessages(List<InterfaceSubMessageToken> subMessages) {
        this.subMessages = subMessages;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public List<InterfaceNode> getPublisherNodes() {
        return this.publisherNodes;
    }

    public void setPublisherNodes(List<InterfaceNode> publisherNodes) {
        this.publisherNodes = publisherNodes;
    }

    public List<InterfaceNode> getSubscriberNodes() {
        return this.subscriberNodes;
    }

    public void setSubscriberNodes(List<InterfaceNode> subscriberNodes) {
        this.subscriberNodes = subscriberNodes;
    }

    public Boolean getInterfaceMessageExclude() {
        return this.interfaceMessageExclude;
    }

    public void setInterfaceMessageExclude(Boolean interfaceMessageExclude) {
        this.interfaceMessageExclude = interfaceMessageExclude;
    }

    public String getInterfaceMessageIoMode() {
        return this.interfaceMessageIoMode;
    }

    public void setInterfaceMessageIoMode(String interfaceMessageIoMode) {
        this.interfaceMessageIoMode = interfaceMessageIoMode;
    }

    public String getInterfaceMessageModeCode() {
        return this.interfaceMessageModeCode;
    }

    public void setInterfaceMessageModeCode(String interfaceMessageModeCode) {
        this.interfaceMessageModeCode = interfaceMessageModeCode;
    }

    public String getInterfaceMessageRateVer() {
        return this.interfaceMessageRateVer;
    }

    public void setInterfaceMessageRateVer(String interfaceMessageRateVer) {
        this.interfaceMessageRateVer = interfaceMessageRateVer;
    }

    public String getInterfaceMessagePriority() {
        return this.interfaceMessagePriority;
    }

    public void setInterfaceMessagePriority(String interfaceMessagePriority) {
        this.interfaceMessagePriority = interfaceMessagePriority;
    }

    public String getInterfaceMessageProtocol() {
        return this.interfaceMessageProtocol;
    }

    public void setInterfaceMessageProtocol(String interfaceMessageProtocol) {
        this.interfaceMessageProtocol = interfaceMessageProtocol;
    }

    public String getInterfaceMessageRptWordCount() {
        return this.interfaceMessageRptWordCount;
    }

    public void setInterfaceMessageRptWordCount(String interfaceMessageRptWordCount) {
        this.interfaceMessageRptWordCount = interfaceMessageRptWordCount;
    }

    public String getInterfaceMessageRptCmdWord() {
        return this.interfaceMessageRptCmdWord;
    }

    public void setInterfaceMessageRptCmdWord(String interfaceMessageRptCmdWord) {
        this.interfaceMessageRptCmdWord = interfaceMessageRptCmdWord;
    }

    public Boolean getInterfaceMessageRunBeforeProc() {
        return this.interfaceMessageRunBeforeProc;
    }

    public void setInterfaceMessageRunBeforeProc(Boolean interfaceMessageRunBeforeProc) {
        this.interfaceMessageRunBeforeProc = interfaceMessageRunBeforeProc;
    }

    public String getInterfaceMessageVer() {
        return this.interfaceMessageVer;
    }

    public void setInterfaceMessageVer(String interfaceMessageVer) {
        this.interfaceMessageVer = interfaceMessageVer;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }
}

