/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.datarights;

import java.util.Objects;
import org.eclipse.osee.define.operations.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightConfiguration;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;

class DataRightEntry {
    private final ArtifactId artifactId;
    private final String classification;
    private final WordCoreUtil.pageType orientation;

    public DataRightEntry(ArtifactId artifactId, ArtifactReadable artifactReadable, String overrideClassification) {
        this.artifactId = Objects.requireNonNull(artifactId, "DataRightEntry::new, the parameter \"artifactId\" cannot be null.");
        Objects.requireNonNull(artifactReadable, "DataRightEntry::new, the parameter \"artifactReadable\" cannot be null.");
        if (!ArtifactReadable.SENTINEL.equals(artifactReadable) && !artifactId.getId().equals(artifactReadable.getId())) {
            throw new OseeCoreException(new Message().title((CharSequence)"DataRightEntry::new, the parameters \"artifactId\" and \"artifactReadable\" specifiy different artifacts.").indentInc().segment((CharSequence)"artifactId", (Object)artifactId).segment((CharSequence)"artifactReadable", (Object)artifactReadable, Id::getId).toString(), new Object[0]);
        }
        this.classification = DataRightsClassification.isValid((String)overrideClassification) ? overrideClassification : this.extractClassification(artifactReadable);
        this.orientation = DataRightsClassification.isValid((String)overrideClassification) ? DataRightConfiguration.defaultPageOrientation : WordCoreUtilServer.getPageOrientation(artifactReadable);
    }

    private String extractClassification(ArtifactReadable artifactReadable) {
        if (artifactReadable.isInvalid()) {
            return "Unspecified";
        }
        try {
            return artifactReadable.getSoleAttributeAsString((AttributeTypeToken)DataRightConfiguration.classificationAttribute, "Unspecified");
        }
        catch (Exception exception) {
            return "Unspecified";
        }
    }

    public ArtifactId getId() {
        return this.artifactId;
    }

    public String getClassification() {
        return this.classification;
    }

    public WordCoreUtil.pageType getOrientation() {
        return this.orientation;
    }
}

