/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.ArtifactUrlServer;
import org.eclipse.osee.define.api.AttributeAlphabeticalComparator;
import org.eclipse.osee.define.api.OseeHierarchyComparator;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.publishing.PublishingOptions;
import org.eclipse.osee.define.api.publishing.TemplatePublishingData;
import org.eclipse.osee.define.api.publishing.datarights.DataRightsOperations;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.RendererOptions;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.operations.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightsOperationsImpl;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.DataRightContentBuilder;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.OutliningOptions;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingTemplateInsertTokenType;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordMLProducer;
import org.eclipse.osee.framework.core.publishing.WordRenderUtil;
import org.eclipse.osee.framework.core.server.publishing.WordRenderArtifactWrapperServerImpl;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlEncoderDecoder;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class WordTemplateProcessorServer {
    protected static final String APPLICABILITY = "Applicability";
    protected static final String ARTIFACT = "Artifact";
    protected static final Object ARTIFACT_ID = "Artifact Id";
    protected static final String ARTIFACT_TYPE = "Artifact Type";
    protected static final String CHANGE_TAG = "[*] ";
    protected static final String FONT = "Times New Roman";
    private static final String LABEL_EMPTY = "<w:r><w:t> </w:t></w:r>";
    private static final String LABEL_END = "</w:t></w:r>";
    private static final String LABEL_START = "<w:r><w:t>";
    protected final ActivityLog activityLog;
    protected final Map<ApplicabilityId, Boolean> applicabilityMap = new HashMap<ApplicabilityId, Boolean>();
    protected HashMap<ApplicabilityId, ApplicabilityToken> applicabilityTokens;
    protected final Map<ArtifactReadable, CharSequence> artParagraphNumbers = new HashMap<ArtifactReadable, CharSequence>();
    protected final AtsApi atsApi;
    protected Set<String> bookmarkedIds = new HashSet<String>();
    protected List<ArtifactId> changedArtifacts = new LinkedList<ArtifactId>();
    protected DataRightsOperations dataRightsOperations;
    protected final Set<ArtifactId> emptyFolders = new HashSet<ArtifactId>();
    protected final List<ArtifactTypeToken> excludeArtifactTypes = new LinkedList<ArtifactTypeToken>();
    protected final List<ArtifactReadable> headerArtifacts = new LinkedList<ArtifactReadable>();
    protected final Set<String> headerGuids = new HashSet<String>();
    protected AttributeTypeToken headingAttributeType;
    protected final OseeHierarchyComparator hierarchyComparator;
    protected HashMap<String, ArtifactReadable> hyperlinkedIds = new HashMap();
    protected final Log logger;
    protected final OrcsApi orcsApi;
    protected final Map<ArtifactTypeToken, List<ArtifactReadable>> oseeLinkedArtifactMap = new HashMap<ArtifactTypeToken, List<ArtifactReadable>>();
    protected String outlineNumber = "";
    protected final Set<ArtifactReadable> processedArtifacts = new HashSet<ArtifactReadable>();
    protected final PublishingErrorLog publishingErrorLog;
    protected final PublishingOptions publishingOptions;
    protected PublishingTemplate publishingTemplate;
    protected final PublishingUtils publishingUtils;
    protected TemplatePublishingData templatePublishingData;
    protected final OrcsTokenService tokenService;
    protected final Map<ArtifactId, String> wordContentMap = new HashMap<ArtifactId, String>();
    protected final Writer writer;

    public WordTemplateProcessorServer(PublishingOptions publishingOptions, PublishingTemplate publishingTemplate, Writer writer, OrcsApi orcsApi, AtsApi atsApi) {
        this.publishingOptions = publishingOptions;
        this.publishingTemplate = publishingTemplate;
        this.writer = writer;
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.activityLog = orcsApi.getActivityLog();
        this.dataRightsOperations = DataRightsOperationsImpl.create(this.orcsApi);
        this.hierarchyComparator = new OseeHierarchyComparator(this.activityLog);
        this.logger = atsApi.getLogger();
        this.tokenService = orcsApi.tokenService();
        this.publishingErrorLog = new PublishingErrorLog();
        this.publishingUtils = new PublishingUtils(this.orcsApi);
    }

    protected List<ArtifactReadable> addContextToArtifactList(List<ArtifactReadable> changedArtifacts) {
        LinkedList<ArtifactReadable> artifactsWithContext = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable artifact : changedArtifacts) {
            if (!artifactsWithContext.contains(artifact)) {
                artifactsWithContext.add(artifact);
            }
            List ancestors = artifact.getAncestors();
            for (ArtifactReadable ancestor : ancestors) {
                if (artifactsWithContext.contains(ancestor) || !ancestor.notEqual((Id)CoreArtifactTokens.DefaultHierarchyRoot)) break;
                artifactsWithContext.add(ancestor);
            }
            List siblings = artifact.getParent().getChildren();
            for (ArtifactReadable sibling : siblings) {
                if (artifactsWithContext.contains(sibling) || sibling.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) continue;
                artifactsWithContext.add(sibling);
            }
        }
        return artifactsWithContext;
    }

    protected void addLinkNotInPublishErrors(WordMLProducer wordMl) {
        if (!this.hyperlinkedIds.isEmpty()) {
            for (Map.Entry<String, ArtifactReadable> link : this.hyperlinkedIds.entrySet()) {
                String description;
                String idString = link.getKey();
                if (this.bookmarkedIds.contains(idString)) continue;
                ArtifactReadable artWithLink = link.getValue();
                try {
                    ArtifactReadable linkedArt = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andGuid(idString).getArtifact();
                    description = String.format("Artifact is linking to the following Artifact Id that is not contained in this document: %s (Guid: %s)", linkedArt.getId(), idString);
                }
                catch (Exception exception) {
                    description = String.format("Artifact contains the following unknown GUID: %s (Delete or fix OSEE Link from Artifact)", idString);
                }
                this.publishingErrorLog.error(artWithLink, description);
            }
        }
    }

    protected void applyContentToTemplate(List<ArtifactReadable> artifacts, CharSequence templateContent) {
        WordMLProducer wordMl = new WordMLProducer((Appendable)this.writer);
        templateContent = this.setUpTemplateContent(wordMl, artifacts.get(0), templateContent, this.publishingOptions.msWordHeadingDepth);
        WordCoreUtil.processPublishingTemplate((CharSequence)templateContent, segment -> {
            wordMl.addWordMl(segment);
            this.processArtifactSet(artifacts, wordMl);
            this.addLinkNotInPublishErrors(wordMl);
            this.publishingErrorLog.publishErrorLog(wordMl);
        }, tail -> {
            CharSequence cleanFooterText = WordCoreUtil.cleanupFooter((CharSequence)tail);
            wordMl.addWordMl(cleanFooterText);
        });
    }

    protected boolean checkIncluded(ArtifactReadable artifact) {
        boolean excludeFolder;
        boolean validWordTemplateContent = !artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.WholeWordContent) && !artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.NativeContent);
        boolean bl = excludeFolder = this.publishingOptions.excludeFolders && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder});
        if (!excludeFolder && this.checkIsArtifactApplicable(artifact)) {
            if (validWordTemplateContent) {
                return true;
            }
            this.publishingErrorLog.error(artifact, "Only artifacts of type Word Template Content are supported in this case");
            return false;
        }
        return false;
    }

    protected boolean checkIsArtifactApplicable(ArtifactReadable artifact) {
        boolean isApplicable = this.publishingOptions.view.equals(ArtifactId.SENTINEL);
        if (isApplicable) {
            return isApplicable;
        }
        ApplicabilityId applicability = artifact.getApplicability();
        if (this.applicabilityMap.containsKey(applicability)) {
            isApplicable = this.applicabilityMap.get(applicability);
        } else {
            List validViews = this.orcsApi.getQueryFactory().applicabilityQuery().getBranchViewsForApplicability(this.publishingOptions.branch, applicability);
            if (validViews.contains(this.publishingOptions.view)) {
                isApplicable = true;
            }
            this.applicabilityMap.put(applicability, isApplicable);
        }
        return isApplicable;
    }

    protected List<ArtifactReadable> filterArtifactsNotRecursivelyRelated(List<ArtifactReadable> artifacts) {
        LinkedList<ArtifactReadable> artifactUnderHeaders = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable artifact : artifacts) {
            List ancestors = artifact.getAncestors();
            for (ArtifactReadable headFolder : this.headerArtifacts) {
                if (!ancestors.contains(headFolder)) continue;
                artifactUnderHeaders.add(artifact);
            }
        }
        return artifactUnderHeaders;
    }

    private String generateAttributeLabel(String label, boolean allAttributes, AttributeTypeToken attributeTypeToken) {
        if (Objects.nonNull(label) && !label.isBlank()) {
            return label;
        }
        if (!allAttributes || attributeTypeToken.matches(new Id[]{CoreAttributeTypes.PlainTextContent})) {
            return LABEL_EMPTY;
        }
        CharSequence attributeTypeTokenName = XmlEncoderDecoder.textToXml((CharSequence)attributeTypeToken.getName());
        return new StringBuilder(LABEL_START.length() + attributeTypeTokenName.length() + 2 + LABEL_END.length()).append(LABEL_START).append(attributeTypeTokenName).append(": ").append(LABEL_END).toString();
    }

    protected Map<ApplicabilityId, ApplicabilityToken> getApplicabilityTokens() {
        if (this.applicabilityTokens == null) {
            this.applicabilityTokens = new HashMap();
            HashMap tokens = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.publishingOptions.branch);
            for (Map.Entry entry : tokens.entrySet()) {
                this.applicabilityTokens.put(ApplicabilityId.valueOf((Long)((Long)entry.getKey())), (ApplicabilityToken)entry.getValue());
            }
        }
        return this.applicabilityTokens;
    }

    protected String getArtifactFooter(ArtifactReadable artifact) {
        return "";
    }

    protected String getAttributeValueAsString(AttributeTypeToken token, ArtifactReadable artifact) {
        return artifact.getAttributeValuesAsString(token);
    }

    protected List<AttributeTypeToken> getOrderedAttributeTypes(Collection<AttributeTypeToken> attributeTypes) {
        ArrayList<AttributeTypeToken> orderedAttributeTypes = new ArrayList<AttributeTypeToken>(attributeTypes.size());
        AttributeTypeToken contentType = null;
        for (AttributeTypeToken attributeType : attributeTypes) {
            if (attributeType.matches(new Id[]{CoreAttributeTypes.WholeWordContent, CoreAttributeTypes.WordTemplateContent, CoreAttributeTypes.PlainTextContent})) {
                contentType = attributeType;
                continue;
            }
            orderedAttributeTypes.add(attributeType);
        }
        Collections.sort(orderedAttributeTypes);
        if (contentType != null) {
            orderedAttributeTypes.add(contentType);
        }
        return orderedAttributeTypes;
    }

    private String getParagraphNumber(ArtifactReadable artifactReadable, CharSequence templateContent) {
        String startParagraphNumber = "1";
        if (Objects.isNull(artifactReadable) || Objects.isNull(templateContent) || templateContent.length() == 0 || !PublishingTemplateInsertTokenType.ARTIFACT.equals((Object)WordCoreUtil.getInsertHereTokenType((CharSequence)templateContent))) {
            return startParagraphNumber;
        }
        String artifactParagraphNumber = (String)artifactReadable.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)"");
        if (Strings.isValid((String)artifactParagraphNumber)) {
            startParagraphNumber = artifactParagraphNumber;
        }
        return startParagraphNumber;
    }

    protected List<ArtifactReadable> getSelectedArtifacts(List<ArtifactId> artifactIds) {
        List artifacts = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andIds(artifactIds).getResults().getList();
        artifacts.sort(this.hierarchyComparator);
        return artifacts;
    }

    protected Map<ArtifactReadable, List<ArtifactReadable>> getSortedArtifactsInHeaderMap(List<ArtifactReadable> artifacts) {
        HashMap<ArtifactReadable, List<ArtifactReadable>> headerMap = new HashMap<ArtifactReadable, List<ArtifactReadable>>();
        ArtifactReadable lastHeader = null;
        LinkedList<ArtifactReadable> artList = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable art : artifacts) {
            if (this.headerArtifacts.contains(art)) {
                if (lastHeader == null) {
                    lastHeader = art;
                    artList = new LinkedList();
                    continue;
                }
                headerMap.put(lastHeader, artList);
                lastHeader = art;
                artList = new LinkedList();
                continue;
            }
            artList.add(art);
        }
        headerMap.put(lastHeader, artList);
        return headerMap;
    }

    protected String[] getSplitWordMlBookmark(ArtifactReadable artifact) {
        String wordMlBookmark = this.getWordMlBookmark(artifact).toString();
        return wordMlBookmark.split("(?<=>)", 2);
    }

    protected CharSequence getWordMlBookmark(ArtifactReadable artifact) {
        CharSequence bookmark = WordCoreUtil.getWordMlBookmark((Long)artifact.getId());
        bookmark = WordCoreUtilServer.reassignBookMarkID(bookmark);
        String guid = artifact.getGuid();
        this.bookmarkedIds.add(guid);
        if (this.hyperlinkedIds.containsKey(guid)) {
            this.hyperlinkedIds.remove(guid);
        }
        return bookmark;
    }

    private String getWordTemplateContentData(ArtifactReadable artifact, PresentationType presentationType, String footer) {
        WordTemplateContentData wtcData = new WordTemplateContentData();
        wtcData.setArtId((ArtifactId)artifact);
        wtcData.setBranch((BranchId)artifact.getBranch());
        wtcData.setFooter(footer);
        wtcData.setIsEdit(presentationType == PresentationType.SPECIALIZED_EDIT);
        wtcData.setLinkType(this.publishingOptions.linkType);
        wtcData.setTxId((TransactionToken)(artifact.isHistorical() ? this.orcsApi.getTransactionFactory().getTx(artifact.getTransaction()) : TransactionToken.SENTINEL));
        wtcData.setPresentationType(presentationType);
        wtcData.setViewId(this.publishingOptions.view);
        wtcData.setPermanentLinkUrl(new ArtifactUrlServer(this.orcsApi).getSelectedPermanentLinkUrl());
        wtcData.setArtIsChanged(this.changedArtifacts.contains(artifact));
        assert (wtcData.isValid()) : new Message().title((CharSequence)"MSWordTemplatePublisher::getWordTemplateContentData, created.").indentInc().segment((CharSequence)"WordTemplateContentData", (Object)wtcData);
        Pair<String, Set<String>> content = null;
        try {
            content = new WordTemplateContentRendererHandler(this.orcsApi, this.logger).renderWordML(wtcData);
        }
        catch (Exception ex) {
            this.publishingErrorLog.error(artifact, ex.toString());
        }
        if (Objects.isNull(content)) {
            return null;
        }
        String data = (String)content.getFirst();
        Set unknownGuids = (Set)content.getSecond();
        this.processLinkErrors(artifact, data, unknownGuids);
        return data;
    }

    protected void populateArtifactWordContent(AttributeTypeToken attributeType, ArtifactReadable artifact, PresentationType presentationType, WordMLProducer wordMl) {
        String footer = this.getArtifactFooter(artifact);
        assert (Objects.nonNull(footer)) : "MSWordTemplatePublisher::populateArtifactWordContent, an artifact's footer must never be null.";
        String data = this.getWordTemplateContentData(artifact, presentationType, footer);
        this.wordContentMap.put((ArtifactId)artifact, data);
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
            this.headerGuids.add(artifact.getGuid());
        }
    }

    protected boolean populateEmptyHeaders(List<ArtifactReadable> artifacts) {
        boolean hasIncludedChildren = false;
        boolean includeParent = false;
        List children = null;
        for (ArtifactReadable artifact : artifacts) {
            children = artifact.getChildren();
            if (!children.isEmpty()) {
                hasIncludedChildren = this.populateEmptyHeaders(children);
                if (!hasIncludedChildren && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                    this.emptyFolders.add((ArtifactId)artifact);
                }
            } else if (children.isEmpty() && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                this.emptyFolders.add((ArtifactId)artifact);
            }
            if (!this.excludeArtifactTypes.contains(artifact.getArtifactType()) && !artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                includeParent = true;
            }
            if (!hasIncludedChildren) continue;
            includeParent = true;
        }
        return includeParent;
    }

    protected void populateOseeLinkedArtifacts(ArtifactTypeToken ... typeTokens) {
        List linkedArts = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andGuids(this.hyperlinkedIds.keySet()).getResults().getList();
        for (ArtifactReadable artifact : linkedArts) {
            if (!artifact.isOfType((ArtifactTypeId[])typeTokens)) continue;
            ArtifactTypeToken artifactType = artifact.getArtifactType();
            if (this.oseeLinkedArtifactMap.containsKey(artifactType)) {
                this.oseeLinkedArtifactMap.get(artifactType).add(artifact);
            } else {
                LinkedList<ArtifactReadable> artList = new LinkedList<ArtifactReadable>();
                artList.add(artifact);
                this.oseeLinkedArtifactMap.put(artifactType, artList);
            }
            this.hyperlinkedIds.remove(artifact.getGuid());
        }
    }

    protected void processArtifact(ArtifactReadable artifact, WordMLProducer wordMl, DataRightContentBuilder dataRightContentBuilder) {
        if (!this.processedArtifacts.contains(artifact)) {
            boolean startedSection = false;
            if (this.checkIncluded(artifact)) {
                startedSection |= this.renderArtifact(artifact, wordMl, dataRightContentBuilder);
            }
            if (this.templatePublishingData.getOutliningOptions().isRecurseChildren()) {
                List children = new LinkedList();
                try {
                    children = artifact.getChildren();
                }
                catch (OseeCoreException oseeCoreException) {
                    this.publishingErrorLog.error(artifact, "There is an error when finding children for this artifact. Possible Cause: Empty Relation Order Attribute");
                }
                for (ArtifactReadable childArtifact : children) {
                    if (childArtifact != null) {
                        this.processArtifact(childArtifact, wordMl, dataRightContentBuilder);
                        continue;
                    }
                    this.publishingErrorLog.error(artifact, "Artifact has an empty child relation");
                }
            }
            if (startedSection) {
                wordMl.endOutlineSubSection();
            }
            this.processedArtifacts.add(artifact);
        }
    }

    protected void processArtifactSet(List<ArtifactReadable> artifacts, WordMLProducer wordMl) {
        artifacts.forEach(artifact -> this.processArtifact((ArtifactReadable)artifact, wordMl, null));
    }

    protected void processAttribute(ArtifactReadable artifact, WordMLProducer wordMl, AttributeOptions attributeOptions, AttributeTypeToken attributeType, boolean allAttrs, PresentationType presentationType, String footer) {
        if (attributeType.equals(CoreAttributeTypes.WordOleData) || attributeType.equals(CoreAttributeTypes.RelationOrder)) {
            return;
        }
        if (attributeType.equals(CoreAttributeTypes.WordTemplateContent)) {
            this.renderWordTemplateContent(artifact, presentationType, wordMl, attributeOptions.getFormat(), attributeOptions.getLabel(), footer);
            return;
        }
        if (artifact.isAttributeTypeValid((AttributeTypeId)attributeType)) {
            String attrValues = artifact.getAttributeValuesAsString(attributeType);
            if (attrValues.isEmpty()) {
                return;
            }
            String label = this.generateAttributeLabel(attributeOptions.getLabel(), "*".equals(attributeOptions.getAttributeName()), attributeType);
            this.renderSpecifiedAttribute(attributeType, attrValues, wordMl, attributeOptions.getFormat(), label);
        }
    }

    protected void processAttributes(ArtifactReadable artifact, WordMLProducer wordMl, String footer) {
        boolean outlining = this.templatePublishingData.getOutliningOptions().isOutlining();
        for (AttributeOptions attributeOptions : this.templatePublishingData.getAttributeElements()) {
            String attributeName = attributeOptions.getAttributeName();
            if (this.publishingOptions.allAttributes || attributeName.equals("*")) {
                for (AttributeTypeToken attributeTypeToken : this.getOrderedAttributeTypes(artifact.getValidAttributeTypes())) {
                    if (outlining && !attributeTypeToken.notEqual((Id)this.headingAttributeType)) continue;
                    this.processAttribute(artifact, wordMl, attributeOptions, attributeTypeToken, true, PresentationType.PREVIEW, footer);
                }
                continue;
            }
            AttributeTypeGeneric attributeTypeGeneric = this.tokenService.getAttributeType(attributeName);
            if (!artifact.isAttributeTypeValid((AttributeTypeId)attributeTypeGeneric)) continue;
            this.processAttribute(artifact, wordMl, attributeOptions, (AttributeTypeToken)attributeTypeGeneric, false, PresentationType.PREVIEW, footer);
        }
    }

    protected void processLinkErrors(ArtifactReadable artifact, String data, Set<String> unknownIds) {
        Pattern bookmarkHyperlinkPattern = Pattern.compile("(^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/><aml:annotation[^<>]+Word.Bookmark.End\\\"/>)|(<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>)");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        String id = "";
        if (!unknownIds.isEmpty()) {
            String description = String.format("Artifact contains the following unknown GUIDs: %s (Delete or fix OSEE Link from Artifact)", unknownIds);
            this.publishingErrorLog.error(artifact, description);
        }
        while (match.find()) {
            String bookmarkMatch = match.group(1);
            String hyperlinkMatch = match.group(3);
            if (bookmarkMatch != null) {
                id = match.group(2);
                if (this.bookmarkedIds.contains(id)) continue;
                this.bookmarkedIds.add(id);
                continue;
            }
            if (hyperlinkMatch == null || this.hyperlinkedIds.containsKey(id = match.group(4))) continue;
            this.hyperlinkedIds.put(id, artifact);
        }
    }

    protected void processMetadata(ArtifactReadable artifact, WordMLProducer wordMl) {
        this.templatePublishingData.getMetadataElements().stream().forEach(metadataElement -> this.renderMetadata(artifact, wordMl, (MetadataOptions)metadataElement));
    }

    private boolean processOutlining(ArtifactReadable artifact, WordMLProducer wordMl) {
        boolean outlining = this.templatePublishingData.getOutliningOptions().isOutlining();
        Boolean publishInline = (Boolean)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PublishInline, (Object)false);
        if (outlining && !publishInline.booleanValue()) {
            this.setArtifactOutlining(artifact, wordMl);
            return true;
        }
        return false;
    }

    public void publish(List<ArtifactId> publishArtifactIds) {
        if (Objects.isNull(publishArtifactIds) || publishArtifactIds.isEmpty()) {
            return;
        }
        String templateContent = Objects.nonNull(this.publishingTemplate) ? this.publishingTemplate.getTemplateContent().getTemplateString() : "";
        this.setUpOptions();
        if (!ARTIFACT.equals(this.templatePublishingData.getElementType())) {
            return;
        }
        List<ArtifactReadable> publishArtifacts = this.getSelectedArtifacts(publishArtifactIds);
        this.applyContentToTemplate(publishArtifacts, templateContent);
    }

    protected String removeUnusedBookmark(CharSequence input) {
        String data = input.toString();
        Pattern bookmarkHyperlinkPattern = Pattern.compile("^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/><aml:annotation[^<>]+Word.Bookmark.End\\\"/>");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        String id = "";
        while (match.find()) {
            String foundMatch = match.group(0);
            if (!Strings.isValid((String)foundMatch) || this.hyperlinkedIds.containsKey(id = match.group(1))) continue;
            data = data.substring(match.end(0));
        }
        return data;
    }

    protected boolean renderArtifact(ArtifactReadable artifact, WordMLProducer wordMl, DataRightContentBuilder dataRightContentBuilder) {
        boolean startedSection = this.processOutlining(artifact, wordMl);
        String footer = "";
        WordCoreUtil.pageType orientation = WordRenderUtil.getPageOrientation((PublishingArtifact)new WordRenderArtifactWrapperServerImpl(artifact));
        footer = Objects.nonNull(dataRightContentBuilder) ? dataRightContentBuilder.getContent((ArtifactId)artifact, orientation) : "";
        this.processMetadata(artifact, wordMl);
        this.processAttributes(artifact, wordMl, footer);
        return startedSection;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void renderMetadata(ArtifactReadable artifact, WordMLProducer wordMl, MetadataOptions element) {
        wordMl.startParagraph();
        String name = element.getType();
        String format = element.getFormat();
        String label = element.getLabel();
        String value = "";
        if (name.equals(APPLICABILITY)) {
            ApplicabilityToken applicToken = this.getApplicabilityTokens().get(artifact.getApplicability());
            if (!applicToken.isValid()) {
                wordMl.endParagraph();
                return;
            }
            value = applicToken.getName();
        } else if (name.equals(ARTIFACT_TYPE)) {
            value = artifact.getArtifactType().getName();
        } else if (name.equals(ARTIFACT_ID)) {
            value = artifact.getIdString();
        }
        if (!format.isEmpty() || !label.isEmpty()) {
            if (label.contains(">x<")) {
                wordMl.addWordMl((CharSequence)label.replace(">x<", ">" + XmlEncoderDecoder.textToXml((CharSequence)(String.valueOf(name) + ": ")).toString() + "<"));
            }
            if (format.contains(">x<")) {
                wordMl.addWordMl((CharSequence)format.replace(">x<", ">" + XmlEncoderDecoder.textToXml((CharSequence)value).toString() + "<"));
            }
        } else {
            wordMl.addTextInsideParagraph((CharSequence)(String.valueOf(name) + ": " + value));
        }
        wordMl.endParagraph();
    }

    private void renderSpecifiedAttribute(AttributeTypeToken attributeType, String attrValues, WordMLProducer WordMLProducer2, String format, String label) {
        WordMLProducer2.startParagraph();
        WordMLProducer2.addWordMl((CharSequence)label);
        if (format.contains(">x<")) {
            WordMLProducer2.addWordMl((CharSequence)format.replace(">x<", ">" + XmlEncoderDecoder.textToXml((CharSequence)attrValues).toString() + "<"));
        } else {
            WordMLProducer2.addTextInsideParagraph((CharSequence)attrValues);
        }
        WordMLProducer2.endParagraph();
    }

    protected void renderWordTemplateContent(ArtifactReadable artifact, PresentationType presentationType, WordMLProducer wordMl, String format, String label, String footer) {
        String dataAndFooter;
        assert (Objects.nonNull(footer)) : "MSWordTemplatePublisher::renderWordTemplateContent, an artifact's footer must never be null.";
        if (label.length() > 0) {
            wordMl.addParagraph((CharSequence)label);
        }
        if (Objects.nonNull(dataAndFooter = this.getWordTemplateContentData(artifact, presentationType, footer))) {
            wordMl.addWordMl((CharSequence)dataAndFooter);
            if (WordCoreUtil.containsLists((CharSequence)dataAndFooter)) {
                wordMl.resetListValue();
            }
            return;
        }
        if (!footer.isBlank()) {
            wordMl.addWordMl((CharSequence)footer);
        }
    }

    protected void setArtifactOutlining(ArtifactReadable artifact, WordMLProducer wordMl) {
        AttributeTypeToken attrToken = AttributeTypeToken.valueOf((String)this.headingAttributeType.getIdString());
        String headingText = artifact.getSoleAttributeAsString(attrToken, "");
        if (this.changedArtifacts.contains(artifact)) {
            headingText = CHANGE_TAG.concat(headingText);
        }
        CharSequence paragraphNumber = null;
        paragraphNumber = wordMl.startOutlineSubSection((CharSequence)FONT, (CharSequence)headingText, null);
        if (paragraphNumber == null) {
            paragraphNumber = wordMl.startOutlineSubSection();
        }
        if (this.publishingOptions.updateParagraphNumbers) {
            this.artParagraphNumbers.put(artifact, paragraphNumber);
        }
    }

    private void setUpOptions() {
        this.templatePublishingData = TemplatePublishingData.create((RendererOptions)this.publishingTemplate.getRendererOptions(), (PublishingOptions)this.publishingOptions);
        if (!ARTIFACT.equals(this.templatePublishingData.getElementType())) {
            return;
        }
        OutliningOptions outliningOptions = this.templatePublishingData.getOutliningOptions();
        this.outlineNumber = outliningOptions.getOutlineNumber();
        this.headingAttributeType = this.tokenService.getAttributeType(outliningOptions.getHeadingAttributeType());
    }

    protected CharSequence setUpTemplateContent(WordMLProducer wordMl, ArtifactReadable artifact, CharSequence templateContent) {
        return this.setUpTemplateContent(wordMl, artifact, templateContent, 9);
    }

    protected CharSequence setUpTemplateContent(WordMLProducer wordMl, ArtifactReadable artifact, CharSequence templateContent, int maxOutline) {
        CharSequence cleanTemplateContent = WordCoreUtil.cleanupPageNumberTypeStart1((CharSequence)templateContent);
        if (this.outlineNumber.equals("")) {
            this.outlineNumber = this.getParagraphNumber(artifact, cleanTemplateContent);
        }
        cleanTemplateContent = WordCoreUtil.initializePublishingTemplateOutliningNumbers((String)this.outlineNumber, (CharSequence)cleanTemplateContent, null);
        wordMl.setNextParagraphNumberTo(this.outlineNumber);
        if (maxOutline != 9) {
            wordMl.setMaxOutlineLevel(maxOutline);
        }
        return cleanTemplateContent;
    }

    protected void sortQueryListByAttributeAlphabetical(List<ArtifactReadable> artifacts, AttributeTypeToken attributeToken) {
        try {
            artifacts.sort((Comparator<ArtifactReadable>)new AttributeAlphabeticalComparator(this.activityLog, attributeToken));
        }
        catch (Exception exception) {
            String errorMessage = String.format("There was an error when sorting the list on %s by alphabetical order", attributeToken.getName());
            this.publishingErrorLog.error(errorMessage);
        }
    }

    protected void sortQueryListByHierarchy(List<ArtifactReadable> artifacts) {
        artifacts.sort((Comparator<ArtifactReadable>)this.hierarchyComparator);
        for (Map.Entry entry : this.hierarchyComparator.errors.entrySet()) {
            ArtifactReadable art = (ArtifactReadable)entry.getKey();
            String description = (String)entry.getValue();
            this.publishingErrorLog.error(art, description);
        }
    }

    protected void startOutlineSubSectionAndBookmark(WordMLProducer wordMl, ArtifactReadable artifact) {
        String[] splitBookmark = this.getSplitWordMlBookmark(artifact);
        wordMl.addWordMl((CharSequence)splitBookmark[0]);
        wordMl.startOutlineSubSection((CharSequence)FONT, (CharSequence)artifact.getName(), null);
        wordMl.addWordMl((CharSequence)splitBookmark[1]);
    }

    protected void updateParagraphNumbers() {
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.publishingOptions.branch, "Update paragraph number on artifact");
        int count = 0;
        for (Map.Entry<ArtifactReadable, CharSequence> art : this.artParagraphNumbers.entrySet()) {
            if (art.getKey().isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.ParagraphNumber)) {
                transaction.setSoleAttributeValue((ArtifactId)art.getKey(), (AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)art.getValue());
            }
            if (count++ <= 500) continue;
            transaction.commit();
            count = 0;
        }
        transaction.commit();
        this.artParagraphNumbers.clear();
    }
}

