/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.rest.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class DispoResolutionValidator {
    private static final String REGEX_1 = "\\(.*\\)?";
    private static final String REGEX_2 = "TRAX|MPD|TPCR|RPCR";
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(Map<String, Object> properties) {
        this.logger.trace("Starting ResolutionValidator...", new Object[0]);
    }

    public void stop() {
        this.logger.trace("Stopping ResolutionValidator...", new Object[0]);
    }

    public void validate(DispoAnnotationData annotation) {
        annotation.setIsResolutionValid(this.isValid(annotation));
        annotation.setIsAnalyze(this.isAnalyze(annotation));
    }

    private boolean isAnalyze(DispoAnnotationData annotation) {
        String type = annotation.getResolutionType();
        boolean toReturn = false;
        if (type.equals("Modify_Code") || type.equals("Modify_Test") || type.equals("Modify_Reqt")) {
            toReturn = true;
        }
        return toReturn;
    }

    private boolean isValid(DispoAnnotationData annotation) {
        String pcr = annotation.getResolution().toUpperCase().trim();
        String type = annotation.getResolutionType().toUpperCase().trim();
        if (!type.startsWith("DEACTIVATED_") && !Strings.isValid((String)pcr)) {
            return false;
        }
        if (this.isValidType(type)) {
            return this.isValidWorkItem(pcr);
        }
        return true;
    }

    private boolean isValidWorkItem(String pcr) {
        boolean isValid = false;
        AtsApiService atsApiService = new AtsApiService();
        try {
            Conditions.assertNotNull((Object)atsApiService.get(), (String)"AtsApi can't be null.", (Object[])new Object[0]);
            Collection workItemsByLegacyPcrId = atsApiService.get().getQueryService().getWorkItemsByLegacyPcrId(this.filterPcr(pcr));
            if (workItemsByLegacyPcrId != null && !workItemsByLegacyPcrId.isEmpty()) {
                isValid = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error validating DispoAnnotationData [%s]", new Object[]{ex.getMessage()});
        }
        return isValid;
    }

    private boolean isValidType(String type) {
        return types.CODE.name().equals(type) || types.REQUIREMENT.name().equals(type) || types.TEST.name().equals(type);
    }

    private String filterPcr(String pcr) {
        String pcrNum = pcr;
        pcrNum = pcrNum.replaceAll(REGEX_2, "");
        pcrNum = pcrNum.replaceAll(REGEX_1, "");
        return pcrNum.trim();
    }

    static enum types {
        CODE,
        TEST,
        REQUIREMENT;

    }
}

