/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class FollowRelationSqlHandler
extends SqlHandler<CriteriaRelationTypeFollow> {
    private final FollowRelationSqlHandler previousFollow;
    private String sourceArtTable;
    private CriteriaRelationTypeFollow criteria;
    private String relAlias;
    private String toArtField;
    private String relTxsAlias;

    public FollowRelationSqlHandler(String sourceArtTable) {
        this.sourceArtTable = sourceArtTable;
        this.previousFollow = null;
    }

    public FollowRelationSqlHandler(FollowRelationSqlHandler previousFollow) {
        this.previousFollow = previousFollow;
    }

    @Override
    public void setData(CriteriaRelationTypeFollow criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.sourceArtTable != null) {
            writer.addTable(this.sourceArtTable);
        }
        this.relAlias = writer.addTable(this.criteria.getType());
        this.relTxsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.RELATION);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        String sourceArtColumn;
        String fromArtField;
        boolean includeDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)writer.getOptions());
        RelationTypeSide typeSide = (RelationTypeSide)this.criteria.getType();
        if (typeSide.getSide().isSideA()) {
            fromArtField = "b_art_id";
            this.toArtField = "a_art_id";
        } else {
            fromArtField = "a_art_id";
            this.toArtField = "b_art_id";
        }
        if (this.previousFollow == null) {
            sourceArtColumn = "art_id";
        } else {
            this.sourceArtTable = this.previousFollow.relAlias;
            sourceArtColumn = this.previousFollow.toArtField;
        }
        writer.writeEqualsAnd(this.sourceArtTable, sourceArtColumn, this.relAlias, fromArtField);
        if (typeSide.getRelationType().isValid()) {
            if (((RelationTypeSide)this.criteria.getType()).isNewRelationTable()) {
                writer.writeEqualsParameterAnd(this.relAlias, "rel_type", typeSide.getRelationType());
            } else {
                writer.writeEqualsParameterAnd(this.relAlias, "rel_link_type_id", typeSide.getRelationType());
            }
        }
        writer.writeEqualsAnd(this.relAlias, this.relTxsAlias, "gamma_id");
        writer.writeTxBranchFilter(this.relTxsAlias, includeDeletedRelations);
        if (this.criteria.isTerminalFollow()) {
            writer.writeAnd();
            writer.writeEquals(this.relAlias, this.toArtField, writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE), "art_id");
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.FOLLOW_RELATION_TYPES.ordinal();
    }

    public RelationSide getRelationSide() {
        return ((RelationTypeSide)this.criteria.getType()).getSide();
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        if (((RelationTypeSide)this.criteria.getType()).isNewRelationTable()) {
            writer.write(", rel_type as top_rel_type, rel_order as top_rel_order");
        }
    }
}

