/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeTypeNotExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class AttributeTypeNotExistsSqlHandler
extends SqlHandler<CriteriaAttributeTypeNotExists> {
    private CriteriaAttributeTypeNotExists criteria;
    private String jIdAlias;
    private AbstractJoinQuery joinQuery;
    private String artAlias;
    private String txsAlias;

    @Override
    public void setData(CriteriaAttributeTypeNotExists criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.criteria.getTypes().size() > 1) {
            this.jIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        this.txsAlias = writer.getMainTableAlias(OseeDb.TXS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        Collection types = this.criteria.getTypes();
        writer.write("NOT EXISTS (SELECT 1 FROM ");
        String attAlias = writer.writeTable(OseeDb.ATTRIBUTE_TABLE);
        writer.write(", ");
        String txsNotAlias = writer.writeTable(OseeDb.TXS_TABLE);
        writer.write(" WHERE ");
        writer.writeEqualsAnd(attAlias, this.artAlias, "art_id");
        if (types.size() > 1) {
            HashSet<AttributeTypeId> typeIds = new HashSet<AttributeTypeId>();
            for (AttributeTypeId type : types) {
                typeIds.add(type);
            }
            this.joinQuery = writer.writeJoin(typeIds);
            writer.writeEquals(attAlias, "attr_type_id", this.jIdAlias, "id");
            writer.writeAnd();
            writer.writeEqualsParameter(this.jIdAlias, "query_id", this.joinQuery.getQueryId());
        } else {
            writer.writeEqualsParameter(attAlias, "attr_type_id", types.iterator().next());
        }
        if (this.criteria.getValue() != null) {
            writer.write(" AND value = ?");
            writer.addParameter(this.criteria.getValue());
        }
        writer.writeAnd();
        writer.writeEqualsAnd(attAlias, txsNotAlias, "gamma_id");
        writer.writeTxBranchFilter(txsNotAlias);
        writer.write(")");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_TYPE_NOT_EXISTS.ordinal();
    }
}

