/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.osee.account.admin.AccessDetails;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountAdmin;
import org.eclipse.osee.account.admin.AccountConfiguration;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.AccountLoginException;
import org.eclipse.osee.account.admin.AccountLoginRequest;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.admin.AccountSession;
import org.eclipse.osee.account.admin.CreateAccountRequest;
import org.eclipse.osee.account.admin.ds.AccountStorage;
import org.eclipse.osee.account.admin.internal.validator.Validator;
import org.eclipse.osee.account.admin.internal.validator.Validators;
import org.eclipse.osee.account.rest.model.AccountUtil;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.authentication.admin.AuthenticatedUser;
import org.eclipse.osee.authentication.admin.AuthenticationAdmin;
import org.eclipse.osee.authentication.admin.AuthenticationRequest;
import org.eclipse.osee.authentication.admin.AuthenticationRequestBuilder;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AccountAdminImpl
implements AccountAdmin {
    private Log logger;
    private AccountStorage storage;
    private AuthenticationAdmin authenticationAdmin;
    private Validator validator;
    private volatile AccountConfiguration config;

    public void setConfig(AccountConfiguration config) {
        this.config = config;
    }

    @Override
    public AccountConfiguration getConfig() {
        return this.config;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setAccountStorage(AccountStorage storage) {
        this.storage = storage;
    }

    public void setAuthenticationAdmin(AuthenticationAdmin authenticationAdmin) {
        this.authenticationAdmin = authenticationAdmin;
    }

    public void start(Map<String, Object> props) {
        this.logger.trace("Starting OrcsAccountAdminImpl...", new Object[0]);
        this.validator = Validators.newAccountValidator(this.logger, this.storage);
        this.update(props);
    }

    public void stop() {
        this.logger.trace("Stopping OrcsAccountAdminImpl...", new Object[0]);
    }

    public void update(Map<String, Object> props) {
        this.validator.configure(props);
        this.setConfig(AccountConfiguration.newConfig(props));
    }

    private AccountStorage getStorage() {
        return this.storage;
    }

    protected Validator getValidator() {
        return this.validator;
    }

    @Override
    public ResultSet<Account> getAllAccounts() {
        return this.getStorage().getAllAccounts();
    }

    @Override
    public ResultSet<Account> getAccountById(ArtifactId accountId) {
        return this.getStorage().getAccountById(accountId);
    }

    @Override
    public AccountPreferences getAccountPreferencesById(ArtifactId accountId) {
        return this.getStorage().getAccountPreferencesById(accountId);
    }

    @Override
    public ArtifactId createAccount(CreateAccountRequest request) {
        Conditions.checkNotNull((Object)request, (String)"create account request");
        Validator validator = this.getValidator();
        validator.validate(AccountField.EMAIL, request.getEmail());
        validator.validate(AccountField.USERNAME, request.getUserName());
        validator.validate(AccountField.DISPLAY_NAME, request.getDisplayName());
        return this.getStorage().createAccount(request);
    }

    @Override
    public boolean setActive(ArtifactId accountId, boolean active) {
        boolean modified = false;
        Account account = (Account)this.getAccountById(accountId).getOneOrDefault((Object)Account.SENTINEL);
        if (account.isValid() && account.isActive() != active) {
            this.getStorage().setActive(accountId, active);
            modified = true;
        }
        return modified;
    }

    @Override
    public void deleteAccount(ArtifactId accountId) {
        this.getStorage().deleteAccount(accountId);
    }

    @Override
    public boolean setAccountPreferences(ArtifactId accountId, Map<String, String> preferences) {
        boolean modified = false;
        Conditions.checkNotNull(preferences, (String)"preferences");
        AccountPreferences prefs = this.getAccountPreferencesById(accountId);
        Map<String, String> original = prefs.asMap();
        if (Compare.isDifferent(original, preferences)) {
            this.getStorage().setAccountPreferences(accountId, preferences);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean setAccountPreference(ArtifactId accountId, String key, String value) {
        boolean modified = false;
        Conditions.checkNotNull((Object)key, (String)"account preference key");
        Conditions.checkNotNull((Object)value, (String)"account preference value", (String)"Use delete account preference instead", (Object[])new Object[0]);
        AccountPreferences prefs = this.getAccountPreferencesById(accountId);
        Map<String, String> original = prefs.asMap();
        HashMap<String, String> newPrefs = new HashMap<String, String>(original);
        newPrefs.put(key, value);
        if (Compare.isDifferent(original, newPrefs)) {
            this.getStorage().setAccountPreferences(accountId, newPrefs);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean setAccountWebPreference(ArtifactId accountId, String key, String itemId, String newValue) {
        Conditions.checkNotNull((Object)key, (String)"account preference key");
        Conditions.checkNotNull((Object)newValue, (String)"account preference value", (String)"Use delete account preference instead", (Object[])new Object[0]);
        AccountWebPreferences allPreferences = this.getStorage().getAccountWebPreferencesById(accountId);
        String newPreferences = AccountUtil.updateSinglePreference((AccountWebPreferences)allPreferences, (String)key, (String)itemId, (String)newValue);
        boolean modified = false;
        if (Strings.isValid((String)newPreferences) && !newPreferences.equalsIgnoreCase(allPreferences.toString())) {
            this.getStorage().setAccountWebPreferences(accountId, newPreferences);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean deleteAccountPreference(ArtifactId accountId, String key) {
        boolean modified = false;
        Conditions.checkNotNull((Object)key, (String)"account preference key");
        AccountPreferences prefs = this.getAccountPreferencesById(accountId);
        Map<String, String> original = prefs.asMap();
        HashMap<String, String> newPrefs = new HashMap<String, String>(original);
        newPrefs.remove(key);
        if (Compare.isDifferent(original, newPrefs)) {
            this.getStorage().setAccountPreferences(accountId, newPrefs);
            modified = true;
        }
        return modified;
    }

    private String notAvailableWhenNullorEmpty(String value) {
        return Strings.isValid((String)value) ? value : "N/A";
    }

    @Override
    public AccountSession login(AccountLoginRequest request) {
        String email = this.authenticate(request);
        ResultSet<Account> result = this.getAccountByEmail(email);
        Account account = (Account)result.getAtMostOneOrDefault((Object)Account.SENTINEL);
        if (account.isInvalid()) {
            throw new AccountLoginException("Login Error - Unable to find account for username[%s] using authentication scheme[%s]", request.getUserName(), request.getScheme());
        }
        String sessionToken = UUID.randomUUID().toString();
        AccessDetails details = request.getDetails();
        String remoteAddress = this.notAvailableWhenNullorEmpty(details.getRemoteAddress());
        String accessDetails = this.notAvailableWhenNullorEmpty(details.getAccessDetails());
        return this.storage.createAccountSession(sessionToken, account, remoteAddress, accessDetails);
    }

    @Override
    public ResultSet<AccountSession> getAccountSessionBySessionToken(String sessionToken) {
        Conditions.checkNotNull((Object)sessionToken, (String)"account session token");
        return this.storage.getAccountSessionBySessionToken(sessionToken);
    }

    private String authenticate(AccountLoginRequest login) {
        AuthenticationRequest request = AuthenticationRequestBuilder.newBuilder().scheme(login.getScheme()).userName(login.getUserName()).password(login.getPassword()).build();
        AuthenticatedUser authenticate = this.authenticationAdmin.authenticate(request);
        return authenticate.getEmailAddress();
    }

    @Override
    public boolean logout(String sessionToken) {
        boolean modified = false;
        ResultSet<AccountSession> result = this.getAccountSessionBySessionToken(sessionToken);
        AccountSession account = (AccountSession)result.getOneOrDefault((Object)AccountSession.SENTINEL);
        if (!account.equals(AccountSession.SENTINEL)) {
            this.storage.deleteAccountSessionBySessionToken(sessionToken);
            modified = true;
        }
        return modified;
    }

    @Override
    public ResultSet<Account> getAccountByEmail(String email) {
        Conditions.checkNotNull((Object)email, (String)"email");
        return this.getStorage().getAccountByEmail(email);
    }

    @Override
    public ResultSet<AccountSession> getAccountSessionById(ArtifactId accountId) {
        return this.getStorage().getAccountSessionById(accountId);
    }

    @Override
    public ResultSet<Account> getAccountByName(String name) {
        Conditions.checkNotNull((Object)name, (String)"name");
        return this.getStorage().getAccountByName(name);
    }
}

