/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.program.operations;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.ProgramVersions;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;

public class AtsProgramOperations {
    private final AtsApi atsApi;

    public AtsProgramOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public List<ProgramVersions> getProgramVersionsList(ArtifactTypeToken programArtifactType, boolean onlyActive) {
        Collection programsArts = this.atsApi.getQueryService().getArtifacts((BranchId)this.atsApi.getAtsBranch(), true, new ArtifactTypeToken[]{programArtifactType});
        LinkedList<ProgramVersions> progVers = new LinkedList<ProgramVersions>();
        for (ArtifactToken program : programsArts) {
            boolean active = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)program, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
            if (onlyActive && !active) continue;
            ProgramVersions progVersions = this.getProgramVersions(program, onlyActive);
            progVers.add(progVersions);
        }
        return progVers;
    }

    public ArtifactToken getProgramFromVersion(ArtifactId version) {
        ArtifactToken teamDef = this.atsApi.getRelationResolver().getRelatedOrSentinel(version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition);
        if (teamDef.isValid()) {
            ArtifactId program = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDef, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
            String name = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue(program, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)"");
            return ArtifactToken.valueOf((ArtifactId)program, (String)name);
        }
        return null;
    }

    public ProgramVersions getProgramVersions(ArtifactToken program, boolean onlyActive) {
        TeamDefinition teamDef;
        ArtifactId teamDefId = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)program, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (Object)ArtifactId.SENTINEL);
        ProgramVersions progVersions = new ProgramVersions();
        progVersions.setProgram(program);
        if (teamDefId.isValid() && (teamDef = (TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamDefId.getId())) != null) {
            progVersions.setTeam(ArtifactToken.valueOf((long)teamDef.getId(), (String)teamDef.getName(), (BranchToken)this.atsApi.getAtsBranch()));
            for (Long versionId : teamDef.getVersions()) {
                IAtsVersion version = (IAtsVersion)this.atsApi.getConfigService().getConfigurations().getIdToVersion().get(versionId);
                boolean verActive = version.isActive();
                if (onlyActive && !verActive) continue;
                progVersions.addVersion(ArtifactToken.valueOf((long)version.getId(), (String)version.getName(), (BranchToken)this.atsApi.getAtsBranch()));
            }
        }
        return progVersions;
    }
}

