/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class WorkPackageUtility {
    public Pair<IAtsCountry, Boolean> getCountry(AtsApi atsApi, IAtsWorkItem workItem) {
        IAtsCountry country;
        Pair result = new Pair(null, (Object)false);
        Pair<IAtsProgram, Boolean> programResult = this.getProgram(atsApi, workItem);
        if (programResult.getFirst() != null && (country = (IAtsCountry)atsApi.getRelationResolver().getRelatedOrNull((IAtsObject)programResult.getFirst(), AtsRelationTypes.CountryToProgram_Country, IAtsCountry.class)) != null) {
            result.setFirst((Object)country);
            result.setSecond((Object)((Boolean)programResult.getSecond()));
        }
        return result;
    }

    public Pair<IAtsProgram, Boolean> getProgram(AtsApi atsApi, IAtsWorkItem workItem) {
        IAtsProgram program;
        Pair result = new Pair(null, (Object)false);
        Pair<IAtsInsertion, Boolean> insertionResult = this.getInsertion(atsApi, workItem);
        if (insertionResult.getFirst() != null && (program = (IAtsProgram)atsApi.getRelationResolver().getRelatedOrNull((IAtsObject)insertionResult.getFirst(), AtsRelationTypes.ProgramToInsertion_Program, IAtsProgram.class)) != null) {
            result.setFirst((Object)program);
            result.setSecond((Object)((Boolean)insertionResult.getSecond()));
        }
        return result;
    }

    public Pair<IAtsInsertion, Boolean> getInsertion(AtsApi atsApi, IAtsWorkItem workItem) {
        IAtsInsertion insertion;
        Pair result = new Pair(null, (Object)false);
        Pair<IAtsInsertionActivity, Boolean> insertionActivityResult = this.getInsertionActivity(atsApi, workItem);
        if (insertionActivityResult.getFirst() != null && (insertion = (IAtsInsertion)atsApi.getRelationResolver().getRelatedOrNull((IAtsObject)insertionActivityResult.getFirst(), AtsRelationTypes.InsertionToInsertionActivity_Insertion, IAtsInsertion.class)) != null) {
            result.setFirst((Object)insertion);
            result.setSecond((Object)((Boolean)insertionActivityResult.getSecond()));
        }
        return result;
    }

    public Pair<IAtsInsertionActivity, Boolean> getInsertionActivity(AtsApi atsApi, IAtsWorkItem workItem) {
        ArtifactToken activityArt;
        Pair result = new Pair(null, (Object)false);
        Pair<ArtifactId, Boolean> workPackageResult = this.getWorkPackageArtifact(atsApi, workItem);
        if (workPackageResult.getFirst() != null && (activityArt = atsApi.getRelationResolver().getRelatedOrNull((ArtifactId)workPackageResult.getFirst(), AtsRelationTypes.InsertionActivityToWorkPackage_InsertionActivity)) != null) {
            IAtsInsertionActivity activity = atsApi.getProgramService().getInsertionActivityById((ArtifactId)activityArt);
            result.setFirst((Object)activity);
            result.setSecond((Object)((Boolean)workPackageResult.getSecond()));
        }
        return result;
    }

    public Pair<ArtifactId, Boolean> getWorkPackageArtifact(AtsApi atsApi, IAtsWorkItem workItem) {
        IAtsTeamWorkflow teamWf;
        Pair<ArtifactId, Boolean> teamResult;
        Pair result = new Pair(null, (Object)false);
        ArtifactId workPackageId = (ArtifactId)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)ArtifactId.SENTINEL);
        if (workPackageId.isValid()) {
            result.setFirst((Object)workPackageId);
        }
        if (result.getFirst() == null && !workItem.isTeamWorkflow() && (teamResult = this.getWorkPackageArtifact(atsApi, (IAtsWorkItem)(teamWf = workItem.getParentTeamWorkflow()))).getFirst() != null) {
            result.setSecond((Object)true);
            result.setFirst((Object)((ArtifactId)teamResult.getFirst()));
        }
        return result;
    }
}

