/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.InputBufferThread;

public class MinicomConnection {
    private static final int MAX_RESPONSE_TIME = 100000;
    private static final int ITERATION_TIME = 2000;
    private InputBufferThread inputBuffer;
    private PrintWriter commandLine;

    public MinicomConnection() {
        this.setupConnection();
        this.waitForWelcomeScreen();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 20) {
            System.out.println("i = " + i + ", Making Connection...");
            MinicomConnection connection = new MinicomConnection();
            System.out.println("Connection made");
            System.out.println("Restarting...");
            connection.resetPizzaBox();
            ++i;
        }
        System.out.println("Done with main");
    }

    private void setupConnection() {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            String[] minicomExe = new String[]{"/usr/bin/minicom"};
            pb.command(minicomExe);
            Process minicomProc = pb.start();
            PipedWriter pw = new PipedWriter();
            this.commandLine = new PrintWriter(pw);
            PipedReader pr = new PipedReader(pw);
            PrintWriter outputFromTheMinicom = new PrintWriter(System.out);
            this.inputBuffer = (InputBufferThread)Lib.handleMinicomProcess(minicomProc, outputFromTheMinicom, pr)[1];
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public PrintWriter getCommandLine() {
        return this.commandLine;
    }

    private void waitForWelcomeScreen() {
        this.waitFor("Press CTRL-A Z for help on special keys");
    }

    public void waitForReset() {
        this.waitFor("Decompression complete");
    }

    public synchronized void waitFor(String matcher) {
        try {
            int elapsedTime = 0;
            while (elapsedTime <= 100000) {
                if (this.inputBuffer.contains(matcher) >= 0) break;
                System.out.println("Input buffer did not contain " + matcher + " after " + elapsedTime + " milisecs");
                this.wait(2000L);
                elapsedTime += 2000;
            }
            if (elapsedTime > 100000) {
                throw new InterruptedException("Waiting for '" + matcher + "' took longer then " + 100000 + " miliseconds.");
            }
            this.wait(4000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void disconnect() {
        System.out.println("Disconnecting...");
        this.inputBuffer.stopOnNextRun(true);
        this.commandLine.close();
        System.out.println("Disconnect Finished");
    }

    public void resetPizzaBox() {
        System.out.println("Issuing rset Command");
        this.commandLine.println("rset");
        System.out.println("Waiting for reset");
        this.waitForReset();
        System.out.println("Reset Finished");
        System.out.println("Issuing CTRL-A Q command");
        this.commandLine.println("\u0001q");
        System.out.println("hitting enter on 'you sure you want to quit'");
        this.commandLine.println();
        this.disconnect();
        System.out.println("Done with resetPizzaBox");
    }
}

