/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public final class Compare {
    private Compare() {
    }

    public static boolean isDifferent(Object original, Object other) {
        boolean result = true;
        if (original == null && other == null) {
            result = false;
        } else if (original != null && other != null) {
            result = original instanceof Map && other instanceof Map ? Compare.isDifferent((Map)original, (Map)other) : (original instanceof Collection && other instanceof Collection ? Compare.isDifferent((Collection)original, (Collection)other) : (original instanceof Object[] && other instanceof Object[] ? Compare.isDifferent(Arrays.asList((Object[])original), Arrays.asList((Object[])other)) : (original instanceof Dictionary && other instanceof Dictionary ? Compare.isDifferent(Compare.toMap((Dictionary)original), Compare.toMap((Dictionary)other)) : !original.equals(other))));
        }
        return result;
    }

    private static boolean isDifferent(Collection<Object> original, Collection<Object> other) {
        return original.size() != other.size() || !Collections.setComplement(original, other).isEmpty() || !Collections.setComplement(other, original).isEmpty();
    }

    private static boolean isDifferent(Map<Object, Object> original, Map<Object, Object> other) {
        Set<Object> set2;
        Set<Object> set1;
        boolean result = true;
        if (original.size() == other.size() && !Compare.isDifferent(set1 = original.keySet(), set2 = other.keySet())) {
            result = false;
            for (Object key : set1) {
                Object value2;
                Object value1 = original.get(key);
                if (!Compare.isDifferent(value1, value2 = other.get(key))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static Map<Object, Object> toMap(Dictionary<Object, Object> source) {
        HashMap<Object, Object> sink = new HashMap<Object, Object>(source.size());
        Enumeration<Object> keys = source.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            sink.put(key, source.get(key));
        }
        return sink;
    }
}

