/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class IdDeserializer<T extends Id>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final Function<Long, T> creator;

    public IdDeserializer(Class<T> object, Function<Long, T> creator) {
        super(object);
        this.creator = creator;
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Long id;
        JsonNode readTree = (JsonNode)jp.getCodec().readTree(jp);
        if (readTree instanceof TextNode || readTree instanceof IntNode || readTree instanceof LongNode) {
            String value = readTree.asText();
            id = value.equals("") ? -1L : Long.valueOf(value);
        } else {
            Objects.requireNonNull(readTree);
            id = readTree.get("id").asLong();
        }
        return (T)((Id)this.creator.apply(id));
    }
}

