/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.MutableDouble;

public class AddingDoubleMap<K> {
    private final HashMap<K, MutableDouble> addingMap;

    public AddingDoubleMap(int initialCapacity) {
        this.addingMap = new HashMap(initialCapacity);
    }

    public AddingDoubleMap() {
        this.addingMap = new HashMap();
    }

    public double get(K key) {
        for (Map.Entry<K, MutableDouble> entry : this.getCounts()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue().getValue();
        }
        return 0.0;
    }

    public boolean contains(K key) {
        for (Map.Entry<K, MutableDouble> entry : this.getCounts()) {
            if (!entry.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public void put(K key, double byAmmount) {
        MutableDouble count = this.addingMap.get(key);
        if (count == null) {
            this.addingMap.put(key, new MutableDouble(byAmmount));
        } else {
            count.getValueAndInc(byAmmount);
        }
    }

    public void put(Collection<K> keys, double byAmmount) {
        for (K key : keys) {
            this.put(key, byAmmount);
        }
    }

    public Set<Map.Entry<K, MutableDouble>> getCounts() {
        return this.addingMap.entrySet();
    }
}

