/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.change;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.osee.framework.jdk.core.text.change.CharacterChanger;

public class CharChange
implements CharacterChanger {
    private final int srcStartIndex;
    private final int srcEndIndex;
    private final char newChar;
    private CharacterChanger next;

    public CharChange(int srcStartIndex, int srcEndIndex, char newChar) {
        this.srcStartIndex = srcStartIndex;
        this.srcEndIndex = srcEndIndex;
        this.newChar = newChar;
    }

    @Override
    public int getStartIndex() {
        return this.srcStartIndex;
    }

    @Override
    public int getEndIndex() {
        return this.srcEndIndex;
    }

    @Override
    public int applyChange(char[] dest, int destPos) {
        dest[destPos] = this.newChar;
        return destPos + 1;
    }

    @Override
    public void applyChange(Writer writer) throws IOException {
        writer.write(this.newChar);
    }

    @Override
    public CharacterChanger next() {
        return this.next;
    }

    @Override
    public void setNext(CharacterChanger next) {
        this.next = next;
    }

    @Override
    public int getLengthDelta() {
        return 1 - this.srcEndIndex + this.srcStartIndex;
    }
}

