/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.data;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class CreateBranchData {
    private final BranchId MERGE_DESTINATION_BRANCH_ID = BranchId.SENTINEL;
    private final Long MERGE_ADDRESSING_QUERY_ID;
    private String branchName;
    private final BranchId branch;
    private BranchType branchType;
    private String creationComment;
    private TransactionToken fromTransaction;
    private TransactionId savedTransaction;
    private ArtifactId associatedArtifact;
    private List<BranchCategoryToken> categories;
    private Long mergeAddressingQueryId = this.MERGE_ADDRESSING_QUERY_ID = Id.SENTINEL;
    private BranchId mergeDestinationBranchId = this.MERGE_DESTINATION_BRANCH_ID;
    private boolean txCopyBranchType = false;
    private BranchId parentBranch;
    private boolean inheritAccess = false;

    public CreateBranchData() {
        this(BranchId.create());
    }

    public CreateBranchData(BranchId branch) {
        this.branch = branch;
    }

    public CreateBranchData(BranchToken branch) {
        this.branch = branch;
        this.branchName = branch.getName();
    }

    public ArtifactId getAssociatedArtifact() {
        return this.associatedArtifact;
    }

    public String getName() {
        return this.branchName;
    }

    public void setName(String branchName) {
        this.branchName = branchName;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getCreationComment() {
        return this.creationComment;
    }

    public void setCreationComment(String creationComment) {
        this.creationComment = creationComment;
    }

    public TransactionToken getFromTransaction() {
        return this.fromTransaction;
    }

    public void setFromTransaction(TransactionToken fromTransaction) {
        this.fromTransaction = fromTransaction;
    }

    public TransactionId getSavedTransaction() {
        return this.savedTransaction;
    }

    public void setSavedTransaction(TransactionId priorTransaction) {
        this.savedTransaction = priorTransaction;
    }

    public void setAssociatedArtifact(ArtifactId associatedArtifact) {
        this.associatedArtifact = associatedArtifact;
    }

    public Long getMergeAddressingQueryId() {
        return this.mergeAddressingQueryId;
    }

    public void setMergeAddressingQueryId(Long mergeAddressingQueryId) {
        this.mergeAddressingQueryId = mergeAddressingQueryId;
    }

    public BranchId getMergeDestinationBranchId() {
        return this.mergeDestinationBranchId;
    }

    public void setMergeDestinationBranchId(BranchId destinationBranchId) {
        this.mergeDestinationBranchId = destinationBranchId;
    }

    public int hashCode() {
        return this.branch.hashCode();
    }

    public boolean equals(Object obj) {
        return this.branch.equals(obj);
    }

    public boolean isTxCopyBranchType() {
        return this.txCopyBranchType;
    }

    public void setTxCopyBranchType(boolean value) {
        this.txCopyBranchType = value;
    }

    public boolean isInheritAccess() {
        return this.inheritAccess;
    }

    public void setInheritAccess(boolean value) {
        this.inheritAccess = value;
    }

    public String toString() {
        return "CreateBranchData [branchUuid=" + this.branch + ", branchName=" + this.branchName + ", branchType=" + this.branchType + ", creationComment=" + this.creationComment + ", fromTransaction=" + this.fromTransaction + ", associatedArtifact=" + this.associatedArtifact + ", mergeAddressingQueryId=" + this.mergeAddressingQueryId + ", destinationBranchId=" + this.mergeDestinationBranchId + "]";
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public void setParentBranch(BranchId parentBranch) {
        this.parentBranch = parentBranch;
    }

    public BranchId getParentBranch() {
        return this.parentBranch;
    }

    public List<BranchCategoryToken> getCategories() {
        return this.categories;
    }

    public void setCategories(List<BranchCategoryToken> categories) {
        this.categories = categories;
    }
}

