/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class HttpResponse {
    private static final String ENTRY_SEPARATOR = "\r\n";
    private static final String FIELD_VALUE_SEPARATOR = ": ";
    private static final String STATUS_LINE = "HTTP/1.1 ";
    private static final String SERVER_ENTRY = "Server: SkynetHttpServer";
    private static final String DATE_ENTRY = "Date";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static Map<Integer, String> codes = new HashMap<Integer, String>();
    private final Map<String, String> responseHeaderMap;
    private final PrintStream printStream;
    private final OutputStream outputStream;
    private final Socket socket;

    static {
        codes.put(100, "100 Continue");
        codes.put(101, "101 Switching Protocols");
        codes.put(200, "200 OK");
        codes.put(201, "201 Created");
        codes.put(202, "202 Accepted");
        codes.put(203, "203 Non-Authoritative Information");
        codes.put(204, "204 No Content");
        codes.put(205, "205 Reset Content");
        codes.put(206, "206 Partial Content");
        codes.put(300, "300 Multiple Choices");
        codes.put(301, "301 Moved Permanently");
        codes.put(302, "302 Found");
        codes.put(303, "303 See Other");
        codes.put(304, "304 Not Modified");
        codes.put(305, "305 Use Proxy");
        codes.put(307, "307 Temporary Redirect");
        codes.put(401, "401 Unauthorized");
        codes.put(402, "402 Payment Required");
        codes.put(403, "403 Forbidden");
        codes.put(404, "404 Not Found");
        codes.put(405, "405 Method Not Allowed");
        codes.put(406, "406 Not Acceptable");
        codes.put(407, "407 Proxy Authentication Required");
        codes.put(408, "408 Request Time-out");
        codes.put(409, "409 Conflict");
        codes.put(410, "410 Gone");
        codes.put(411, "411 Length Required");
        codes.put(412, "412 Precondition Failed");
        codes.put(413, "413 Request Entity Too Large");
        codes.put(414, "414 Request-URI Too Large");
        codes.put(415, "415 Unsupported Media Type");
        codes.put(416, "416 Requested range not satisfiable");
        codes.put(417, "417 Expectation Failed");
        codes.put(500, "500 Internal Server Error");
        codes.put(501, "501 Not Implemented");
        codes.put(502, "502 Bad Gateway");
        codes.put(503, "503 Service Unavailable");
        codes.put(504, "504 Gateway Time-out");
        codes.put(505, "505 HTTP Version not supported");
        codes.put(400, "400 Bad Request");
    }

    protected HttpResponse(Socket socket) throws Exception {
        this.socket = socket;
        this.outputStream = socket.getOutputStream();
        this.responseHeaderMap = new LinkedHashMap<String, String>();
        this.printStream = new PrintStream(this.outputStream, true, "UTF-8");
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setContentEncoding(String encoding) {
        this.setReponseHeader(CONTENT_ENCODING, encoding);
    }

    public void setContentType(String contentType) {
        this.setReponseHeader(CONTENT_TYPE, contentType);
    }

    public void setContentDisposition(String disposition) {
        this.setReponseHeader(CONTENT_DISPOSITION, disposition);
    }

    public void setReponseHeader(String field, String value) {
        this.responseHeaderMap.put(field, value);
    }

    public String getResponseHeaderField(String field) {
        String toReturn = this.responseHeaderMap.get(field);
        return Strings.isValid((String)toReturn) ? toReturn : "";
    }

    public Set<String> getResponseHeaderFields() {
        return this.responseHeaderMap.keySet();
    }

    public static String getStatus(int value) {
        return codes.get(value);
    }

    public String getResponseHeader(int errorCode, long responseLength) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(STATUS_LINE);
        buffer.append(HttpResponse.getStatus(errorCode));
        buffer.append(ENTRY_SEPARATOR);
        buffer.append(SERVER_ENTRY);
        buffer.append(ENTRY_SEPARATOR);
        buffer.append(DATE_ENTRY);
        buffer.append(FIELD_VALUE_SEPARATOR);
        buffer.append(new Date().toString());
        buffer.append(ENTRY_SEPARATOR);
        Set<String> fields = this.responseHeaderMap.keySet();
        for (String field : fields) {
            String values = this.responseHeaderMap.get(field);
            buffer.append(field);
            buffer.append(FIELD_VALUE_SEPARATOR);
            buffer.append(values);
            buffer.append(ENTRY_SEPARATOR);
        }
        buffer.append(ENTRY_SEPARATOR);
        return buffer.toString();
    }

    public void sendResponseHeaders(int errorCode, long responseLength) throws IOException {
        this.setReponseHeader(CONTENT_LENGTH, Long.toString(responseLength));
        byte[] header = this.getResponseHeader(errorCode, responseLength).getBytes();
        this.sendInputStream(new ByteArrayInputStream(header));
    }

    public void sendBody(InputStream inputStream) throws IOException {
        this.sendInputStream(inputStream);
    }

    private void sendInputStream(InputStream inputStream) throws IOException {
        byte[] buf = new byte[10000];
        int count = -1;
        while ((count = inputStream.read(buf)) != -1) {
            this.outputStream.write(buf, 0, count);
        }
        inputStream.close();
    }

    public void outputStandardError(int errorCode, String message, Throwable ex) {
        StringWriter sw = new StringWriter();
        if (ex != null) {
            ex.printStackTrace(new PrintWriter(sw));
        }
        this.outputStandardError(errorCode, String.valueOf(message) + sw.toString());
    }

    public void outputStandardError(int errorCode, String reason) {
        String errorStr = HttpResponse.getStatus(errorCode);
        String reasonStr = reason != null ? "Reason: " + reason : "";
        String html = AHTML.simplePage((String)("<h1>Error " + errorStr + "</h1><h2>OSEE was unable to handle the request.</h2>" + reasonStr + "<form><input type=button onClick='window.opener=self;window.close()' value='Close'></form>"));
        OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("HttpServer Request failed. " + reasonStr));
        try {
            this.printStream.println(html);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error sending error string", (Throwable)ex);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    private final class StatusCodes {
        private static final String STATUS_100 = "100 Continue";
        private static final String STATUS_101 = "101 Switching Protocols";
        private static final String STATUS_200 = "200 OK";
        private static final String STATUS_201 = "201 Created";
        private static final String STATUS_202 = "202 Accepted";
        private static final String STATUS_203 = "203 Non-Authoritative Information";
        private static final String STATUS_204 = "204 No Content";
        private static final String STATUS_205 = "205 Reset Content";
        private static final String STATUS_206 = "206 Partial Content";
        private static final String STATUS_300 = "300 Multiple Choices";
        private static final String STATUS_301 = "301 Moved Permanently";
        private static final String STATUS_302 = "302 Found";
        private static final String STATUS_303 = "303 See Other";
        private static final String STATUS_304 = "304 Not Modified";
        private static final String STATUS_305 = "305 Use Proxy";
        private static final String STATUS_307 = "307 Temporary Redirect";
        private static final String STATUS_400 = "400 Bad Request";
        private static final String STATUS_401 = "401 Unauthorized";
        private static final String STATUS_402 = "402 Payment Required";
        private static final String STATUS_403 = "403 Forbidden";
        private static final String STATUS_404 = "404 Not Found";
        private static final String STATUS_405 = "405 Method Not Allowed";
        private static final String STATUS_406 = "406 Not Acceptable";
        private static final String STATUS_407 = "407 Proxy Authentication Required";
        private static final String STATUS_408 = "408 Request Time-out";
        private static final String STATUS_409 = "409 Conflict";
        private static final String STATUS_410 = "410 Gone";
        private static final String STATUS_411 = "411 Length Required";
        private static final String STATUS_412 = "412 Precondition Failed";
        private static final String STATUS_413 = "413 Request Entity Too Large";
        private static final String STATUS_414 = "414 Request-URI Too Large";
        private static final String STATUS_415 = "415 Unsupported Media Type";
        private static final String STATUS_416 = "416 Requested range not satisfiable";
        private static final String STATUS_417 = "417 Expectation Failed";
        private static final String STATUS_500 = "500 Internal Server Error";
        private static final String STATUS_501 = "501 Not Implemented";
        private static final String STATUS_502 = "502 Bad Gateway";
        private static final String STATUS_503 = "503 Service Unavailable";
        private static final String STATUS_504 = "504 Gateway Time-out";
        private static final String STATUS_505 = "505 HTTP Version not supported";

        private StatusCodes() {
        }
    }
}

