/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public final class SynchronizationResourceMappingContext
extends RemoteResourceMappingContext {
    private final ISynchronizationContext context;

    public SynchronizationResourceMappingContext(ISynchronizationContext context) {
        this.context = context;
    }

    public boolean isThreeWay() {
        return this.context.getType() == 3;
    }

    public boolean hasRemoteChange(IResource resource, IProgressMonitor monitor) throws CoreException {
        IDiff diff = this.context.getDiffTree().getDiff(resource);
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            ITwoWayDiff remote = twd.getRemoteChange();
            return remote != null && remote.getKind() != 0;
        }
        return diff != null && diff.getKind() != 0;
    }

    public boolean hasLocalChange(IResource resource, IProgressMonitor monitor) throws CoreException {
        IDiff diff = this.context.getDiffTree().getDiff(resource);
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            ITwoWayDiff local = twd.getLocalChange();
            return local != null && local.getKind() != 0;
        }
        return false;
    }

    public IStorage fetchRemoteContents(IFile file, IProgressMonitor monitor) throws CoreException {
        IDiff diff = this.context.getDiffTree().getDiff((IResource)file);
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            ITwoWayDiff remote = twd.getRemoteChange();
            if (remote instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)remote;
                return rd.getAfterState().getStorage(monitor);
            }
        } else if (diff instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)diff;
            return rd.getAfterState().getStorage(monitor);
        }
        return file;
    }

    public IStorage fetchBaseContents(IFile file, IProgressMonitor monitor) throws CoreException {
        IDiff diff = this.context.getDiffTree().getDiff((IResource)file);
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            ITwoWayDiff remote = twd.getRemoteChange();
            if (remote instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)remote;
                return rd.getBeforeState().getStorage(monitor);
            }
            ITwoWayDiff local = twd.getLocalChange();
            if (local instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)local;
                return rd.getBeforeState().getStorage(monitor);
            }
        }
        return null;
    }

    public IResource[] fetchMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
        IPath[] childPaths;
        HashSet<IResource> result = new HashSet<IResource>();
        IResource[] children = container.members();
        Collections.addAll(result, children);
        IPath[] iPathArray = childPaths = this.context.getDiffTree().getChildren(container.getFullPath());
        int n = childPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IDiff delta = this.context.getDiffTree().getDiff(path);
            Object child = delta == null ? (path.segmentCount() == 1 ? ((IWorkspaceRoot)container).getProject(path.lastSegment()) : container.getFolder((IPath)new Path(path.lastSegment()))) : this.context.getDiffTree().getResource(delta);
            result.add((IResource)child);
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
    }

    public ISynchronizationContext getSynchronizationContext() {
        return this.context;
    }

    public IProject[] getProjects() {
        IResource[] roots;
        HashSet<IProject> projects = new HashSet<IProject>();
        IResource[] iResourceArray = roots = this.context.getScope().getRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            projects.add(resource.getProject());
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }
}

