/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing.templatemanager;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.osee.define.api.publishing.templatemanager.InvalidRendererOptionsException;
import org.eclipse.osee.define.api.publishing.templatemanager.NestedTemplates;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.OutliningOptions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class RendererOptions
implements ToMessage {
    private static Set<String> elementTypes = Set.of("Artifact", "NestedTemplate");
    @JsonProperty(value="AttributeOptions")
    private AttributeOptions[] attributeOptions;
    @JsonProperty(value="ElementType")
    private String elementType;
    @JsonProperty(value="MetadataOptions")
    private MetadataOptions[] metadataOptions;
    @JsonProperty(value="NestedTemplates")
    private NestedTemplates[] nestedTemplates;
    @JsonProperty(value="OutliningOptions")
    private OutliningOptions[] outliningOptions;

    public static RendererOptions create(String jsonRendererOptionsString) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            RendererOptions rendererOptions = (RendererOptions)objectMapper.readValue(jsonRendererOptionsString, RendererOptions.class);
            rendererOptions.defaults();
            return rendererOptions;
        }
        catch (Exception e) {
            throw new InvalidRendererOptionsException(jsonRendererOptionsString, e);
        }
    }

    private static void validateElementType(String elementType) {
        if (!elementTypes.contains(elementType)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"RendererOptions::validateElementType, parameter \"elementType\" has an invalid value.").indentInc().segment((CharSequence)"Specified elementType", (Object)elementType).segmentIndexedArray((CharSequence)"Allowed Values", elementTypes.toArray()).toString());
        }
    }

    public RendererOptions() {
        this.attributeOptions = null;
        this.elementType = null;
        this.metadataOptions = null;
        this.nestedTemplates = null;
        this.outliningOptions = null;
    }

    public RendererOptions(String elementType, OutliningOptions[] outliningOptions, AttributeOptions[] attributeOptions, MetadataOptions[] metadataOptions, NestedTemplates[] nestedTemplates) {
        this.attributeOptions = Objects.requireNonNull(attributeOptions, "RendererOptions::new, parameter \"attributeOptions\" cannot be null.");
        Objects.requireNonNull(elementType, "RendererOptions::new, parameter \"elementType\" cannot be null.");
        RendererOptions.validateElementType(elementType);
        this.elementType = elementType;
        this.metadataOptions = Objects.requireNonNull(metadataOptions, "RendererOptions::new, parameter \"metadataOptions\" cannot be null.");
        this.nestedTemplates = Objects.requireNonNull(nestedTemplates, "RendererOptions::new, parameter \"nestedTemplates\" cannot be null.");
        this.outliningOptions = Objects.requireNonNull(outliningOptions, "RendererOptions::new, parameter \"outliningOptions\" cannot be null.");
    }

    public void defaults() {
        if (Objects.isNull(this.attributeOptions)) {
            this.attributeOptions = new AttributeOptions[0];
        } else {
            Arrays.stream(this.attributeOptions).forEach(AttributeOptions::defaults);
        }
        if (Objects.isNull(this.elementType)) {
            this.elementType = "";
        }
        if (Objects.isNull(this.metadataOptions)) {
            this.metadataOptions = new MetadataOptions[0];
        } else {
            Arrays.stream(this.metadataOptions).forEach(MetadataOptions::defaults);
        }
        if (Objects.isNull(this.nestedTemplates)) {
            this.nestedTemplates = new NestedTemplates[0];
        } else {
            Arrays.stream(this.nestedTemplates).forEach(NestedTemplates::defaults);
        }
        if (Objects.isNull(this.outliningOptions)) {
            this.outliningOptions = new OutliningOptions[0];
        } else {
            Arrays.stream(this.outliningOptions).forEach(OutliningOptions::defaults);
        }
    }

    public AttributeOptions[] getAttributeOptions() {
        if (Objects.isNull(this.attributeOptions)) {
            throw new IllegalStateException("RendererOptions::getAttributeOptions, the member \"attributeOptions\" has not been set.");
        }
        return this.attributeOptions;
    }

    public String getElementType() {
        if (Objects.isNull(this.elementType)) {
            throw new IllegalStateException("RendererOptions::getElementType, the member \"elementType\" has not been set.");
        }
        return this.elementType;
    }

    public MetadataOptions[] getMetadataOptions() {
        if (Objects.isNull(this.metadataOptions)) {
            throw new IllegalStateException("RendererOptions::getMetadataOptions, the member \"metadataOptions\" has not been set.");
        }
        return this.metadataOptions;
    }

    public NestedTemplates[] getNestedTemplates() {
        if (Objects.isNull(this.nestedTemplates)) {
            throw new IllegalStateException("RendererOptions::getNestedTemplates, the member \"nestedTemplates\" has not been set.");
        }
        return this.nestedTemplates;
    }

    public OutliningOptions[] getOutliningOptions() {
        if (Objects.isNull(this.outliningOptions)) {
            throw new IllegalStateException("RendererOptions::getOutliningOptions, the member \"outliningOptions\" has not been set.");
        }
        return this.outliningOptions;
    }

    public boolean isValid() {
        if (Objects.isNull(this.attributeOptions) || Objects.isNull(this.elementType) || !elementTypes.contains(this.elementType) || Objects.isNull(this.metadataOptions) || Objects.isNull(this.nestedTemplates) || Objects.isNull(this.outliningOptions)) {
            return false;
        }
        switch (this.elementType) {
            case "Artifact": {
                return this.nestedTemplates.length == 0 && !Arrays.stream(this.attributeOptions).anyMatch(Predicate.not(AttributeOptions::isValid)) && !Arrays.stream(this.metadataOptions).anyMatch(Predicate.not(MetadataOptions::isValid)) && !Arrays.stream(this.outliningOptions).anyMatch(Predicate.not(OutliningOptions::isValid));
            }
            case "NestedTemplate": {
                return this.attributeOptions.length == 0 && this.metadataOptions.length == 0 && this.outliningOptions.length == 0 && !Arrays.stream(this.nestedTemplates).anyMatch(Predicate.not(NestedTemplates::isValid));
            }
        }
        return false;
    }

    public void setAttributeOptions(AttributeOptions[] attributeOptions) {
        if (Objects.nonNull(this.attributeOptions)) {
            throw new IllegalStateException("RendererOptions::setAttributeOptions, member \"attributeOptions\" has already been set.");
        }
        this.attributeOptions = Objects.requireNonNull(attributeOptions, "RendererOptions::new, parameter \"attributeOptions\" cannot be null.");
    }

    public void setElementType(String elementType) {
        if (Objects.nonNull(this.elementType)) {
            throw new IllegalStateException("RendererOptions::setElementType, member \"elementType\" has already been set.");
        }
        Objects.requireNonNull(elementType, "RendererOptions::new, parameter \"elementType\" cannot be null.");
        RendererOptions.validateElementType(elementType);
        this.elementType = elementType;
    }

    public void setMetadataOptions(MetadataOptions[] metadataOptions) {
        if (Objects.nonNull(this.metadataOptions)) {
            throw new IllegalStateException("RendererOptions::setMetadataOptions, member \"metadataOptions\" has already been set.");
        }
        this.metadataOptions = Objects.requireNonNull(metadataOptions, "RendererOptions::new, parameter \"metadataOptions\" cannot be null.");
    }

    public void setNestedTemplates(NestedTemplates[] nestedTemplates) {
        if (Objects.nonNull(this.nestedTemplates)) {
            throw new IllegalStateException("RendererOptions::setNestedTemplates, member \"nestedTemplates\" has already been set.");
        }
        this.nestedTemplates = Objects.requireNonNull(nestedTemplates, "RendererOptions::new, parameter \"nestedTemplates\" cannot be null.");
    }

    public void setOutliningOptions(OutliningOptions[] outliningOptions) {
        if (Objects.nonNull(this.outliningOptions)) {
            throw new IllegalStateException("RendererOptions::setOutliningOptions, member \"outliningOptions\" has already been set.");
        }
        this.outliningOptions = Objects.requireNonNull(outliningOptions, "RendererOptions::new, parameter \"outliningOptions\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Renderer Options").indentInc().segment((CharSequence)"Element Type", (Object)this.elementType);
        switch (this.elementType) {
            case "Artifact": {
                outMessage.segmentIndexedArray((CharSequence)"Attribute Options", (Object[])this.attributeOptions).segmentIndexedArray((CharSequence)"Metadata Options", (Object[])this.metadataOptions).segmentIndexedArray((CharSequence)"Outlining Options", (Object[])this.outliningOptions);
                break;
            }
            case "NestedTemplate": {
                outMessage.segmentIndexedArray((CharSequence)"NestedTemplates", (Object[])this.nestedTemplates);
            }
        }
        outMessage.indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

